/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.ioc.IOC;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.twophase.InitScriptPatchActions;
import oracle.opatch.twophase.MakePatchActions;
import oracle.opatch.twophase.PostScriptPatchActions;
import oracle.opatch.twophase.PreScriptPatchActions;
import oracle.opatch.twophase.TwoPhaseMatchType;
import oracle.opatch.wrappers.WrapperFactory;

public class PhaseTwoOperatorHelper {
    public static TwoPhaseMatchType getMatchType(String oh) {
        ProcessFileVersions proc = new ProcessFileVersions();
        OneOffEntry[] pohs = new OneOffEntry[]{};
        OneOffEntry[] pis = new OneOffEntry[]{};
        String branchKey = OPatchEnv.getBranchKey();
        TwoPhaseMatchType t = TwoPhaseMatchType.SAME;
        if (branchKey.equals("CLI")) {
            return t;
        }
        try {
            if (!IOC.INSTANCE.isInventoryConverted()) {
                pohs = PrereqAPI.getInstalledOneOff(oh);
            }
            if ((pis = OPatchUtilHelper.getPatchesToApply(oh, OPatchEnv.getNApplySessionName())).length == 0) {
                PatchObject[] pis_rollback = OPatchUtilHelper.getPatchesToRollback(oh, OPatchUtilHelper.getPatchesToRollback(), OPatchEnv.getNRollbackSessionName());
                pis = OPatchUtilHelper.getOneOffObjects(oh, pis_rollback);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
        }
        t = proc.checkMatchType(oh, pohs, pis);
        OLogger.justlog(OLogger.INFO, "PhaseTwoOperatorHelper:: getMatchType is " + (Object)((Object)t));
        return t;
    }

    public static void mergeInventory(String oh, String soh) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseTwoOperatorHelper::mergeInventory(String oh, String soh)");
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        try {
            PatchObject[] mergePatches = new PatchObject[]{};
            mergePatches = PhaseTwoOperatorHelper.getPatchesToMergeInv(oh, soh);
            if (!rwServices.isLocked()) {
                try {
                    rwServices.lock(oh);
                    if (!rwServices.isInventoryLoaded()) {
                        rwServices.loadInventory(oh);
                    }
                }
                catch (RuntimeException e2) {
                    OLogger.printlnOnLog("Load rwServices inventory error: " + e2.getMessage());
                }
            }
            for (PatchObject po : mergePatches) {
                rwServices.add(po);
                rwServices.savePatch(po);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            rwServices.release();
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseTwoOperatorHelper::mergeInventory(String oh, String soh)");
    }

    private static Set<String> getPatchSet(String dir) {
        HashSet<String> res = new HashSet<String>();
        Path file = WrapperFactory.getNioServiceWrapper().getPath(dir, new String[0]);
        DirectoryStream<Path> files = null;
        try {
            files = Files.newDirectoryStream(file);
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        for (Path f2 : files) {
            if (!Files.isDirectory(f2, new LinkOption[0])) continue;
            String path = f2.toString();
            path = path.substring(dir.length() + 1);
            res.add(path);
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    private static PatchObject[] getPatchesToMergeInv(String oh, String soh) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<Path, String> getIgnoreList() {
        HashMap<Path, String> ignore = new HashMap<Path, String>();
        Path inv = WrapperFactory.getNioServiceWrapper().getPath("inventory", new String[0]);
        ignore.put(inv, "inventory");
        return ignore;
    }

    public static boolean shouldRunCopyOH(InitScriptPatchActions inits, PreScriptPatchActions pres, PostScriptPatchActions posts, MakePatchActions makes) {
        if (inits.hasAnyActions()) {
            return true;
        }
        if (pres.hasAnyActions()) {
            return true;
        }
        if (posts.hasAnyActions()) {
            return true;
        }
        return makes.hasAnyActions();
    }

    public static String getPrefixFileName(String oh, String key) {
        return OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + key;
    }

    public static String getPostfixFileName() {
        if (OPatchEnv.isOPatchSDKMode()) {
            return "SDK";
        }
        return "CLI";
    }

    public static void clear(String oh, String pre, String post) {
        OLogger.justlog(OLogger.INFO, "Clearing cached patch information..");
        String cacheLoc = OPatchEnv.getPrereqResultFileLoc(oh);
        Path cacheLocFile = WrapperFactory.getNioServiceWrapper().getPath(cacheLoc, new String[0]);
        DirectoryStream<Path> listOfFiles = null;
        try {
            listOfFiles = Files.newDirectoryStream(cacheLocFile);
        }
        catch (IOException e1) {
            OLogger.debug(e1.getMessage());
        }
        for (Path fv : listOfFiles) {
            if (fv.getFileName().toString().startsWith(pre) && fv.getFileName().toString().endsWith(post)) {
                OLogger.justlog(OLogger.INFO, "Deleting file " + fv.getFileName().toString());
                try {
                    Files.delete(fv);
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            OLogger.justlog(OLogger.INFO, "Finished clearing cached patch information.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPatchGen(String oh, Set<OPatchPatchKey> opKeySet) {
        OLogger.justlog(OLogger.INFO, "Running patchgen for db home..");
        LinkedList<String> keysToRun = new LinkedList<String>();
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isInventoryLoaded()) {
            boolean alreadyLocked = readServices.isLocked();
            try {
                if (!alreadyLocked) {
                    readServices.lock(oh);
                }
                readServices.loadInventory(oh);
                OPatchEnv.setDesiredHome(readServices.isDesiredHome());
            }
            catch (Throwable ti) {
                OLogger.justlog(OLogger.INFO, "Exception while checking if DB home requires patchgen. Skipping patchgen");
            }
            finally {
                if (!alreadyLocked) {
                    readServices.release();
                }
            }
        } else {
            OPatchEnv.setDesiredHome(readServices.isDesiredHome());
        }
        Iterator<OPatchPatchKey> iterator = opKeySet.iterator();
        while (iterator.hasNext()) {
            CASFileServices cas = new CASFileServices();
            OPatchPatchKey opKey = iterator.next();
            List<String> pkeys = cas.getPatchInfo(opKey.toString());
            if (pkeys != null && pkeys.size() > 0) {
                for (String pkey : pkeys) {
                    keysToRun.add(pkey);
                }
                continue;
            }
            keysToRun.add(opKey.toString());
        }
        for (String key : keysToRun) {
            int first = key.indexOf("_");
            String id = key.substring(0, first);
            int last = key.lastIndexOf("_");
            String session = key.substring(last + 1);
            OPatchSession.runPatchgen(oh, id, session.equals("napply"), false);
        }
        OLogger.justlog(OLogger.INFO, "Finished running patchgen for db home.");
    }
}

