/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.ccme;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.ncm.ccme.CCMEFIPS140Provider;
import com.rsa.crypto.ncm.ccme.CCMEHandle;
import com.rsa.crypto.ncm.ccme.CCMEPKCS11Provider;
import com.rsa.crypto.ncm.ccme.CCMEProvider;
import com.rsa.cryptoj.e.cq;

public class CCMELibraryContext
extends CCMEHandle {
    protected final CCMEProvider provider;
    protected final CCMEFIPS140Provider fipsProvider;
    private final boolean isPKCS11Context;
    private int mode = 1;

    public CCMELibraryContext() {
        if (cq.f()) {
            this.fipsProvider = new CCMEFIPS140Provider(null);
            this.provider = null;
            this.createFIPS140LibraryContext(this.fipsProvider, 1);
        } else {
            this.fipsProvider = null;
            this.provider = null;
            this.createLibraryContext();
        }
        this.isPKCS11Context = false;
    }

    public CCMELibraryContext(CCMEPKCS11Provider cCMEPKCS11Provider, CCMEFIPS140Provider cCMEFIPS140Provider, int n2) {
        this.provider = cCMEPKCS11Provider;
        this.fipsProvider = cCMEFIPS140Provider;
        this.isPKCS11Context = true;
        this.mode = n2;
        this.createPKCS11LibraryContext(cCMEPKCS11Provider, cCMEFIPS140Provider, n2);
    }

    public CCMELibraryContext(CCMEFIPS140Provider cCMEFIPS140Provider, int n2) {
        if (!cq.f()) {
            throw new CryptoException("Toolkit is not FIPS140 Compliant");
        }
        this.provider = null;
        this.fipsProvider = cCMEFIPS140Provider;
        this.isPKCS11Context = false;
        this.mode = n2;
        this.createFIPS140LibraryContext(cCMEFIPS140Provider, n2);
    }

    public CCMEProvider getProvider() {
        if (this.isPKCS11Context) {
            return this.provider;
        }
        if (this.provider != null) {
            return this.provider;
        }
        if (this.fipsProvider != null) {
            return this.fipsProvider;
        }
        return null;
    }

    public boolean isPKCS11Context() {
        return this.isPKCS11Context;
    }

    public int getMode() {
        return this.mode;
    }

    public synchronized void close() {
        if (this.provider != null) {
            this.provider.close();
        }
        if (this.fipsProvider != null) {
            this.fipsProvider.close();
        }
        this.freeLibraryContext();
    }

    protected void finalize() throws Throwable {
        try {
            this.freeLibraryContext();
        }
        finally {
            super.finalize();
        }
    }

    private void freeLibraryContext() {
        if (!this.isHandleNull()) {
            this.freeLibraryContextNative();
        }
    }

    private native void createLibraryContext();

    private native void createPKCS11LibraryContext(CCMEPKCS11Provider var1, CCMEFIPS140Provider var2, int var3);

    private native void createFIPS140LibraryContext(CCMEFIPS140Provider var1, int var2);

    private native void freeLibraryContextNative();
}

