/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.key;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.AlgParamGenerator;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.DomainParams;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEAlgorithmIdentifier;
import com.rsa.crypto.ncm.ccme.CCMECryptoObject;
import com.rsa.crypto.ncm.ccme.CCMEPKeyContext;
import com.rsa.crypto.ncm.ccme.CCMEParameters;
import com.rsa.crypto.ncm.key.DHParamsImpl;
import com.rsa.crypto.ncm.key.ParamGeneratorImpl;

public class DHParamGenerator
extends ParamGeneratorImpl
implements AlgParamGenerator {
    protected static final String a = "DH_PARAMETER_GENERATION";
    protected Integer b;
    protected Integer c;

    public DHParamGenerator(b b2, String string) {
        super(b2, CCMEAlgorithmIdentifier.getAlgId(a));
    }

    @Override
    public void initGen(AlgorithmParams algorithmParams, SecureRandom secureRandom) {
        if (!(algorithmParams instanceof AlgInputParams)) {
            this.getClass();
            throw new InvalidAlgorithmParameterException("Parameters object invalid for algorithm.");
        }
        AlgInputParams algInputParams = (AlgInputParams)algorithmParams;
        Integer n2 = (Integer)algInputParams.get("primeLen");
        Integer n3 = (Integer)algInputParams.get("subprimeLen");
        Integer n4 = n3 == null ? this.calculateMinimumGeneratorOrder(n2) : n3.intValue();
        if (n2 < 1024 || n2 > 4096 || n2 % 256 != 0) {
            throw new InvalidAlgorithmParameterException("Invalid DH prime size. Prime size must be between 1024 and 4096 bits and a multiple of 256.");
        }
        if (n4 < 160 || n4 >= n2) {
            throw new InvalidAlgorithmParameterException("Invalid exponent/subprime size. Should be between 160 and " + n2 + " (the Prime size) bits.");
        }
        this.a(secureRandom);
        this.b = n2;
        this.c = n4;
        this.g = 1;
    }

    @Override
    public void initVerify(AlgorithmParams algorithmParams, SecureRandom secureRandom) {
        throw new CryptoException("This functionality is not supported by the native module.");
    }

    @Override
    public boolean verify() {
        throw new CryptoException("This functionality is not supported by the native module.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlgorithmParams generate() {
        if (this.isHandleNull()) {
            this.createObject(this.cryptoModule.b(), this.cryptoModule.e(), this.e);
        }
        this.a();
        DHParamsImpl dHParamsImpl = new DHParamsImpl(this.cryptoModule, this.c);
        this.initDHNative(this.cryptoModule.c(), this.cryptoModule.e(), dHParamsImpl, this.f, this.b, this.c);
        try {
            this.generateNative(dHParamsImpl);
        }
        finally {
            this.freeObject();
            try {
                ((CCMEParameters)dHParamsImpl).cache();
            }
            finally {
                dHParamsImpl.destroy();
            }
            this.freeObject();
            this.g = 0;
        }
        return dHParamsImpl;
    }

    protected native void initDHNative(CCMEPKeyContext var1, byte[] var2, DomainParams var3, CCMECryptoObject var4, int var5, int var6);

    private native int calculateMinimumGeneratorOrder(int var1);
}

