/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import com.rsa.cryptoj.e.qa;
import com.rsa.cryptoj.e.qd;
import com.rsa.cryptoj.e.qf;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public final class EVChecker {
    public static final int COMPAT_STRICT = 0;
    public static final int COMPAT_BUS_CAT_ABSENT = 1;
    public static final int COMPAT_EXTRA_KEY_USAGE_BIT = 2;
    public static final int COMPAT_NON_CRITICAL_KEY_USAGE = 4;
    public static final int COMPAT_WEAK_RSA_KEY_SIZE = 8;
    public static final int COMPAT_CERT_POLICY_ABSENT = 16;

    private EVChecker() {
    }

    public static boolean isEVCompliant(X509Certificate[] x509CertificateArray, List<String> list) throws CertificateException {
        int n2 = qf.a();
        return EVChecker.isEVCompliant(x509CertificateArray, list, n2);
    }

    public static boolean isEVCompliant(X509Certificate[] x509CertificateArray, List<String> list, int n2) throws CertificateException {
        boolean bl2 = true;
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            if (!(x509CertificateArray[i2] instanceof qd)) {
                x509CertificateArray[i2] = qa.a(ByteBuffer.wrap(x509CertificateArray[i2].getEncoded()));
            }
            qd qd2 = (qd)x509CertificateArray[i2];
            bl2 = bl2 && qf.a((X509Certificate)qd2, list, n2);
        }
        return bl2;
    }

    public static boolean isEVCompliantRoot(X509Certificate x509Certificate) throws CertificateException {
        qd qd2 = qa.a(ByteBuffer.wrap(x509Certificate.getEncoded()));
        int n2 = qf.a();
        return qf.a((X509Certificate)qd2, n2);
    }

    public static int getDefaultCompatibilityMask() {
        return qf.a();
    }
}

