/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.e.a;
import com.rsa.cryptoj.e.aa;
import com.rsa.cryptoj.e.b;
import com.rsa.cryptoj.e.d;
import com.rsa.cryptoj.e.dj;
import com.rsa.cryptoj.e.dn;
import com.rsa.cryptoj.e.dw;
import com.rsa.cryptoj.e.f;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.GeneralSubtree;
import com.rsa.jsafe.cert.InvalidEncodingException;
import com.rsa.jsafe.cert.ObjectID;
import java.security.cert.PolicyQualifierInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class X509ExtensionRequestSpec
implements Cloneable {
    public static final int KEY_USAGE_DIGITAL_SIGNATURE = 0;
    public static final int KEY_USAGE_NON_REPUDIATION = 1;
    public static final int KEY_USAGE_KEY_ENCIPHERMENT = 2;
    public static final int KEY_USAGE_DATA_ENCIPHERMENT = 3;
    public static final int KEY_USAGE_KEY_AGREEMENT = 4;
    public static final int KEY_USAGE_KEY_CERTSIGN = 5;
    public static final int KEY_USAGE_CRL_SIGN = 6;
    public static final int KEY_USAGE_ENCIPHER_ONLY = 7;
    public static final int KEY_USAGE_DECIPHER_ONLY = 8;
    public static final int NUM_DEFINED_KEY_USAGE_BITS = 9;
    private static final String b = "Input cannot be null.";
    private static final int c = 9;
    private boolean[] d;
    private List<GeneralName> e;
    private List<ObjectID> f;
    private int g = -1;
    private List<List<ObjectID>> h;
    private Map<ObjectID, List<PolicyQualifierInfo>> i;
    private int j = -1;
    private int k = -1;
    private int l = -1;
    private List<GeneralSubtree> m = Collections.emptyList();
    private List<GeneralSubtree> n = Collections.emptyList();
    private List<Attribute> o;
    private List<byte[]> p;
    private boolean q;
    boolean a = true;

    public void setKeyUsage(boolean[] blArray) {
        if (blArray == null || blArray.length < 1) {
            throw new IllegalArgumentException("Input must be non-null array of at least length 1.");
        }
        if (blArray.length <= 9) {
            this.d = new boolean[9];
            System.arraycopy(blArray, 0, this.d, 0, blArray.length);
        } else {
            int n2 = blArray.length - 1;
            while (!blArray[n2]) {
                --n2;
            }
            int n3 = n2 < 9 ? 9 : n2 + 1;
            this.d = new boolean[n3];
            System.arraycopy(blArray, 0, this.d, 0, n2 + 1);
        }
        this.a = false;
    }

    public void setSubjectAlternativeNames(List<GeneralName> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("names must not be null and must not contain null entries.");
        }
        this.a(list);
        this.e = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
        this.a = false;
    }

    public void setExtendedKeyUsage(List<ObjectID> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("usageOIDs must not be null and must not contain null entries.");
        }
        this.f = Collections.unmodifiableList(new ArrayList<ObjectID>(list));
        this.a = false;
    }

    public void setBasicConstraints(int n2) {
        if (n2 < -1) {
            throw new IllegalArgumentException("Invalid pathLenConstraint value.");
        }
        this.q = true;
        this.g = n2;
        this.a = false;
    }

    public void setPolicyMappings(List<List<ObjectID>> list) {
        if (list == null) {
            throw new IllegalArgumentException(b);
        }
        ArrayList<List<ObjectID>> arrayList = new ArrayList<List<ObjectID>>();
        for (List<ObjectID> list2 : list) {
            if (list2 == null || list2.size() != 2) {
                throw new IllegalArgumentException("Expected each List<ObjectID> to be of size 2.");
            }
            if (list2.contains(null)) {
                throw new IllegalArgumentException("List contained null entry.");
            }
            arrayList.add(Collections.unmodifiableList(new ArrayList<ObjectID>(list2)));
        }
        this.h = Collections.unmodifiableList(arrayList);
        this.a = false;
    }

    public void setCertificatePolicies(Map<ObjectID, List<PolicyQualifierInfo>> map) {
        if (map == null) {
            throw new IllegalArgumentException(b);
        }
        HashMap hashMap = new HashMap();
        for (ObjectID objectID : map.keySet()) {
            if (objectID == null) {
                throw new IllegalArgumentException("Map contained entry with null key.");
            }
            if (map.get(objectID) == null) {
                hashMap.put(objectID, null);
                continue;
            }
            hashMap.put(objectID, Collections.unmodifiableList(new ArrayList(map.get(objectID))));
        }
        this.i = Collections.unmodifiableMap(hashMap);
        this.a = false;
    }

    public void setCertificatePolicies(Set<ObjectID> set) {
        if (set == null || set.contains(null)) {
            throw new IllegalArgumentException("policies must not be null and must not contain a null entry.");
        }
        HashMap<ObjectID, Object> hashMap = new HashMap<ObjectID, Object>(set.size());
        for (ObjectID objectID : set) {
            hashMap.put(objectID, null);
        }
        this.i = Collections.unmodifiableMap(hashMap);
        this.a = false;
    }

    public void setPolicyConstraints(int n2, int n3) {
        if (n2 < -1 || n3 < -1) {
            throw new IllegalArgumentException("Invalid policy mapping value.");
        }
        this.j = n2;
        this.k = n3;
        this.a = false;
    }

    public void setInhibitAnyPolicy(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("skipCerts must be at least 0.");
        }
        this.l = n2;
        this.a = false;
    }

    public void setNameConstraints(List<GeneralSubtree> list, List<GeneralSubtree> list2) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("permittedSubtrees must be non-null and must not contain null entry.");
        }
        if (list2 == null || list2.contains(null)) {
            throw new IllegalArgumentException("excludedSubtrees must be non-null and must not contain null entry.");
        }
        if (!list.isEmpty() || !list2.isEmpty()) {
            this.m = Collections.unmodifiableList(new ArrayList<GeneralSubtree>(list));
            this.n = Collections.unmodifiableList(new ArrayList<GeneralSubtree>(list2));
            this.a = false;
        }
    }

    public void setSubjectDirectoryAttributes(List<Attribute> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("attributes List must be non-null and must not contain null entry.");
        }
        this.o = Collections.unmodifiableList(new ArrayList<Attribute>(list));
        this.a = false;
    }

    public void addOtherExtension(byte[] byArray) throws InvalidEncodingException {
        if (byArray == null) {
            throw new IllegalArgumentException(b);
        }
        try {
            com.rsa.cryptoj.e.a.a("Extension", byArray, 0);
        }
        catch (b b2) {
            throw new InvalidEncodingException("Invalid extension encoding.");
        }
        if (this.p == null) {
            this.p = new ArrayList<byte[]>();
        }
        this.p.add(dj.a(byArray));
        this.a = false;
    }

    public boolean[] getKeyUsage() {
        return dj.a(this.d);
    }

    public List<GeneralName> getSubjectAlternativeNames() {
        return this.e;
    }

    public List<ObjectID> getExtendedKeyUsage() {
        return this.f;
    }

    public int getBasicConstraints() {
        return this.g;
    }

    public List<List<ObjectID>> getPolicyMappings() {
        return this.h;
    }

    public Map<ObjectID, List<PolicyQualifierInfo>> getCertificatePolicies() {
        return this.i;
    }

    public int getRequireExplicitPolicy() {
        return this.j;
    }

    public int getInhibitPolicyMapping() {
        return this.k;
    }

    public int getInhibitAnyPolicy() {
        return this.l;
    }

    public List<GeneralSubtree> getNameConstraintsPermitted() {
        return this.m;
    }

    public List<GeneralSubtree> getNameConstraintsExcluded() {
        return this.n;
    }

    public List<Attribute> getSubjectDirectoryAttributes() {
        return this.o;
    }

    public boolean isBasicConstraintsSpecified() {
        return this.q;
    }

    public List<byte[]> getOtherExtensions() {
        if (this.p == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        dw.a(arrayList, this.p);
        return arrayList;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = dn.a(n2, this.q);
        n2 = dn.a(n2, this.g);
        n2 = dn.a(n2, this.k);
        n2 = dn.a(n2, this.j);
        n2 = dn.a(n2, this.l);
        n2 = dn.a(n2, this.d);
        n2 = this.a(n2);
        n2 = dn.a(n2, this.f);
        n2 = dn.a(n2, this.n);
        n2 = dn.a(n2, this.m);
        n2 = dn.a(n2, this.h);
        n2 = dn.a(n2, this.e);
        n2 = dn.a(n2, this.o);
        n2 = dn.a(n2, this.p);
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof X509ExtensionRequestSpec)) {
            return false;
        }
        X509ExtensionRequestSpec x509ExtensionRequestSpec = (X509ExtensionRequestSpec)object;
        return this.q == x509ExtensionRequestSpec.q && this.g == x509ExtensionRequestSpec.g && this.k == x509ExtensionRequestSpec.k && this.j == x509ExtensionRequestSpec.j && this.l == x509ExtensionRequestSpec.l && Arrays.equals(this.d, x509ExtensionRequestSpec.d) && this.a(x509ExtensionRequestSpec.i) && dw.b(this.f, x509ExtensionRequestSpec.f) && dw.b(this.n, x509ExtensionRequestSpec.n) && dw.b(this.m, x509ExtensionRequestSpec.m) && dw.b(this.h, x509ExtensionRequestSpec.h) && dw.b(this.e, x509ExtensionRequestSpec.e) && dw.b(this.o, x509ExtensionRequestSpec.o) && dw.b(this.p, x509ExtensionRequestSpec.p);
    }

    private int a(int n2) {
        int n3 = n2;
        if (this.i == null) {
            return dn.a(n3, 0);
        }
        for (ObjectID objectID : this.i.keySet()) {
            List<PolicyQualifierInfo> list = this.i.get(objectID);
            n3 = dn.a(n3, objectID);
            if (list == null) continue;
            for (PolicyQualifierInfo policyQualifierInfo : list) {
                if (policyQualifierInfo == null) {
                    n3 = dn.a(n3, 0);
                    continue;
                }
                n3 = dn.a(n3, policyQualifierInfo.getEncoded());
            }
        }
        return n3;
    }

    private boolean a(Map<ObjectID, List<PolicyQualifierInfo>> map) {
        if (this.i == map) {
            return true;
        }
        if (this.i == null || map == null) {
            return false;
        }
        for (Map.Entry<ObjectID, List<PolicyQualifierInfo>> entry : this.i.entrySet()) {
            ObjectID objectID = entry.getKey();
            List<PolicyQualifierInfo> list = entry.getValue();
            if (list == null) {
                if (map.get(objectID) == null && map.containsKey(objectID)) continue;
                return false;
            }
            List<PolicyQualifierInfo> list2 = map.get(objectID);
            if (list2 == null || list.size() != list2.size()) {
                return false;
            }
            Iterator<PolicyQualifierInfo> iterator = list.iterator();
            Iterator<PolicyQualifierInfo> iterator2 = list2.iterator();
            while (iterator.hasNext()) {
                PolicyQualifierInfo policyQualifierInfo = iterator.next();
                PolicyQualifierInfo policyQualifierInfo2 = iterator2.next();
                if (Arrays.equals(policyQualifierInfo.getEncoded(), policyQualifierInfo2.getEncoded())) continue;
                return false;
            }
        }
        return true;
    }

    void a(List<GeneralName> list) {
        for (GeneralName generalName : list) {
            if (generalName.getType() != GeneralName.Type.DNS_NAME || !generalName.toString().trim().isEmpty()) continue;
            throw new IllegalArgumentException("dNSName must not be a string with only space(s).");
        }
    }

    public Object clone() {
        X509ExtensionRequestSpec x509ExtensionRequestSpec;
        try {
            x509ExtensionRequestSpec = (X509ExtensionRequestSpec)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not clone object");
        }
        x509ExtensionRequestSpec.d = dj.a(this.d);
        x509ExtensionRequestSpec.p = dj.a(this.p);
        return x509ExtensionRequestSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Requested Extensions [ ").append(dw.a);
        if (this.isBasicConstraintsSpecified()) {
            stringBuffer.append("BasicConstraints [").append(dw.a);
            stringBuffer.append("   ").append("cA: ").append(this.g == -1 ? "false" : "true").append(dw.a);
            if (this.g != Integer.MAX_VALUE) {
                stringBuffer.append("   ").append("pathLenConstraint: ").append(this.g).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.i != null) {
            stringBuffer.append("CertificatePolicies [").append(dw.a);
            for (Map.Entry object : this.i.entrySet()) {
                stringBuffer.append("   ").append(object.getKey()).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.f != null) {
            stringBuffer.append("ExtKeyUsage [").append(dw.a);
            for (ObjectID objectID : this.f) {
                stringBuffer.append("   ").append(objectID).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.l != -1) {
            stringBuffer.append("InhibitAnyPolicy [").append(dw.a);
            stringBuffer.append("   ").append("SkipCerts: ").append(this.l).append(dw.a);
            stringBuffer.append("]").append(dw.a);
        }
        if (this.d != null) {
            stringBuffer.append("KeyUsage [").append(dw.a);
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                stringBuffer.append(this.d[i2]).append(", ");
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (!this.m.isEmpty() || !this.n.isEmpty()) {
            stringBuffer.append("NameConstraints [").append(dw.a);
            if (!this.m.isEmpty()) {
                stringBuffer.append("   ").append("permitted: [").append(dw.a);
                for (GeneralSubtree generalSubtree : this.m) {
                    stringBuffer.append("      ").append(generalSubtree);
                }
                stringBuffer.append("   ").append("]").append(dw.a);
            }
            if (!this.n.isEmpty()) {
                stringBuffer.append("   ").append("excluded: [").append(dw.a);
                for (GeneralSubtree generalSubtree : this.n) {
                    stringBuffer.append("      ").append(generalSubtree);
                }
                stringBuffer.append("   ").append("]").append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.k != -1 || this.j != -1) {
            stringBuffer.append("PolicyConstraints [").append(dw.a);
            if (this.j != -1) {
                stringBuffer.append("   ").append("requireExplicitPolicy: ").append(this.j).append(dw.a);
            }
            if (this.k != -1) {
                stringBuffer.append("   ").append("inhibitPolicyMapping: ").append(this.k).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.h != null) {
            stringBuffer.append("PolicyMappings [").append(dw.a);
            for (List<ObjectID> list : this.h) {
                stringBuffer.append("   ").append("issuerDomainPolicy: ").append(list.get(0));
                stringBuffer.append(" -> subjectDomainPolicy: ").append(list.get(1)).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.e != null) {
            stringBuffer.append("SubjectAltName [").append(dw.a);
            for (GeneralName generalName : this.e) {
                stringBuffer.append("   ").append(generalName).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.o != null) {
            stringBuffer.append("SubjectDirectoryAttributes [").append(dw.a);
            for (Attribute attribute : this.o) {
                stringBuffer.append("   ").append(attribute);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.p != null) {
            for (byte[] byArray : this.p) {
                d d2 = com.rsa.cryptoj.e.a.a("Extension", byArray, 0);
                aa aa2 = (aa)d2.a(0);
                stringBuffer.append("Extension OID.").append(aa2).append(dw.a);
                stringBuffer.append("Value: ").append(dw.a(((f)d2.a(2)).h())).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        stringBuffer.append("]").append(dw.a);
        return stringBuffer.toString();
    }
}

