/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import oracle.security.xmlsec.dsig.Referable;
import oracle.security.xmlsec.enc.XEReferenceList;
import oracle.security.xmlsec.keys.KeyDerivationMethod;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DerivedKey
extends XMLElement
implements Referable,
KeyInfoData {
    private static final String[] nsURIs = new String[]{"http://www.w3.org/2009/xmlenc11#", "http://www.w3.org/2001/04/xmlenc#", "http://www.w3.org/2009/xmlenc11#", "http://www.w3.org/2009/xmlenc11#"};
    private static final String[] localNames = new String[]{"KeyDerivationMethod", "ReferenceList", "DerivedKeyName", "MasterKeyName"};

    public DerivedKey(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2009/xmlenc11#", "DerivedKey", systemId);
    }

    public DerivedKey(Document owner, String nsURI, String localName) throws DOMException {
        this(owner, null);
    }

    public DerivedKey(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public DerivedKey(Element element) throws DOMException {
        super(element);
    }

    public void setKeyDerivationMethod(KeyDerivationMethod keyDerivationMethod) {
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2009/xmlenc11#", "KeyDerivationMethod");
        XMLUtils.insertChild(this, keyDerivationMethod, nsURIs, localNames);
    }

    public KeyDerivationMethod getKeyDerivationMethod() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "KeyDerivationMethod");
        if (nodes.getLength() != 0) {
            return new KeyDerivationMethod((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public String getDerivedKeyName() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "DerivedKeyName");
        if (nList.getLength() != 0) {
            return XMLUtils.collectText(nList.item(0));
        }
        return null;
    }

    public void setDerivedKeyName(String val) {
        XMLUtils.insertChildElementWithText(this, "http://www.w3.org/2009/xmlenc11#", "DerivedKeyName", nsURIs, localNames, val, true);
    }

    public String getMasterKeyName() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "MasterKeyName");
        if (nList.getLength() != 0) {
            return XMLUtils.collectText(nList.item(0));
        }
        return null;
    }

    public void setMasterKeyName(String val) {
        XMLUtils.insertChildElementWithText(this, "http://www.w3.org/2009/xmlenc11#", "MasterKeyName", nsURIs, localNames, val, true);
    }

    public XEReferenceList getReferenceList() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        if (nList.getLength() != 0) {
            return new XEReferenceList((Element)nList.item(0));
        }
        return null;
    }

    public void setReferenceList(XEReferenceList refList) {
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        XMLUtils.insertChild(this, refList, nsURIs, localNames);
    }

    public String getRecipient() {
        return this.hasAttribute("Recipient") ? this.getAttribute("Recipient") : null;
    }

    public void setRecipient(String val) {
        this.setAttribute("Recipient", val);
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2009/xmlenc11#DerivedKey";
    }

    public String getKeyDerivationType() {
        return this.hasAttribute("Type") ? this.getAttribute("Type") : null;
    }

    public void setKetDerivationType(String val) {
        this.setAttribute("Type", val);
    }

    @Override
    public void setId(String id) {
        this.setAttribute("Id", id);
    }

    @Override
    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }
}

