/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.util.Map;
import oracle.security.xmlsec.transform.NodeFilterTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XPathFilter;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EbxmlXPathFilter
extends XSTransformer
implements NodeFilterTransform {
    private static final String ACTOR1 = "urn:oasis:names:tc:ebxml-msg:actor:nextMSH";
    private static final String ACTOR2 = "http://schemas.xmlsoap.org/soap/actor/next";
    private static final String ACTOR1_2 = "urn:oasis:names:tc:ebxml-msg:service:nextMSH";
    private static final String XPATH = "not(ancestor-or-self::node()[@SOAP:actor=\"urn:oasis:names:tc:ebxml-msg:actor:nextMSH\"]|ancestor-or-self::node()[@SOAP:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])";
    private static final String XPATH_OR = "not(ancestor-or-self::node()[@SOAP:actor=\"urn:oasis:names:tc:ebxml-msg:actor:nextMSH\"]orancestor-or-self::node()[@SOAP:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])";
    private static final String XPATH_2 = "not(ancestor-or-self::node()[@SOAP:actor=\"urn:oasis:names:tc:ebxml-msg:service:nextMSH\"]|ancestor-or-self::node()[@SOAP:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])";
    private static final String XPATH_2_OR = "not(ancestor-or-self::node()[@SOAP:actor=\"urn:oasis:names:tc:ebxml-msg:service:nextMSH\"]orancestor-or-self::node()[@SOAP:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])";
    private XPathFilter xpfilter;

    public static boolean isEbXMLFilter(XPathFilter filter) {
        String xpath = filter.getXPath();
        if (!xpath.contains("ebxml-msg")) {
            return false;
        }
        xpath = xpath.replaceAll("\\s", "");
        xpath = xpath.replace("'", "\"");
        xpath = xpath.replace("@actor", "@SOAP:actor");
        Map<String, String> nsMap = XMLUtils.getAncestorNamespaces(filter.transform.getElement());
        for (String nsPrefix : nsMap.keySet()) {
            String nsValue = nsMap.get(nsPrefix);
            if (!nsValue.equals("http://schemas.xmlsoap.org/soap/envelope/")) continue;
            xpath = xpath.replaceAll(nsPrefix + ":", "SOAP:");
        }
        return xpath.equals(XPATH_OR) || xpath.equals(XPATH_2_OR) || xpath.equals(XPATH) || xpath.equals(XPATH_2);
    }

    public EbxmlXPathFilter(XPathFilter xpfilter) {
        this.xpfilter = xpfilter;
    }

    @Override
    public String getAlgorithmURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        return this.xpfilter.transform(source);
    }

    @Override
    public int accept(Node node) throws TransformationException {
        if (node.getNodeType() != 1) {
            return 1;
        }
        Element elem = (Element)node;
        if (("http://schemas.xmlsoap.org/soap/envelope/".equals(elem.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(elem.getNamespaceURI())) && "Body".equals(elem.getLocalName())) {
            return 3;
        }
        Element parent = (Element)elem.getParentNode();
        if (parent != null && ("http://schemas.xmlsoap.org/soap/envelope/".equals(parent.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(parent.getNamespaceURI())) && "Header".equals(parent.getLocalName())) {
            String actor = elem.getAttributeNS(parent.getNamespaceURI(), "actor");
            if (ACTOR1.equals(actor) || ACTOR2.equals(actor) || ACTOR1_2.equals(actor)) {
                return 4;
            }
            return 3;
        }
        return 1;
    }
}

