/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.ArrayTable;
import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class ComdevHelper {
    public static String cLF = "\n";
    public static boolean cIsWin32 = false;
    public static boolean cIsWin64;
    public static boolean cIsJDK14;
    public static boolean cIsJDK15;

    public static File findHome(String jarFile) {
        File myself = ComdevHelper.findMyself(jarFile);
        if (myself != null && myself.isFile()) {
            myself = myself.getParentFile();
        }
        return myself == null ? null : myself.getParentFile().getParentFile();
    }

    public static File findMyself(String jarFile) {
        ClassLoader systemClassLoader = ComdevHelper.class.getClassLoader();
        if (systemClassLoader == null) {
            return null;
        }
        if (jarFile != null) {
            return ComdevHelper.determineMyself11(jarFile);
        }
        return ComdevHelper.determineMyself(systemClassLoader);
    }

    public static void parseArgs(ArrayTable preset, String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-') {
                int sep = args[i].indexOf(61);
                if (sep == -1) {
                    if (args.length > i + 1 && args[i + 1].charAt(0) != '-') {
                        if (preset.containsKey(args[i])) {
                            preset.put(args[i], args[i + 1]);
                        }
                        i += 2;
                        continue;
                    }
                    if (preset.containsKey(args[i])) {
                        preset.put(args[i], null);
                    }
                } else {
                    String key = args[i].substring(0, sep);
                    String val = args[i].substring(sep + 1);
                    if (preset.containsKey(key)) {
                        preset.put(key, val);
                    }
                }
            }
            ++i;
        }
    }

    public static String encodingJava2std(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("ISO8859_")) {
            return "ISO-8859-" + s.substring(8);
        }
        if (s.startsWith("8859_")) {
            return "ISO-8859-" + s.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(s) || "ASCII".equalsIgnoreCase(s)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(s)) {
            return "UTF-8";
        }
        if (s.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(s)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(s)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(s)) {
            return "EUC-JP";
        }
        return s;
    }

    private static File determineMyself11(String jarFile) {
        String classpath = System.getProperty("java.class.path");
        String[] array = classpath.split(System.getProperty("path.separator"));
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].endsWith(jarFile)) continue;
            File jar = new File(array[i]);
            return jar;
        }
        return null;
    }

    private static File determineMyself(ClassLoader systemClassLoader) {
        try {
            String className = ComdevHelper.class.getName().replace('.', '/') + ".class";
            URL classResource = systemClassLoader.getResource(className);
            String fileComponent = classResource.getFile();
            if (classResource.getProtocol().equals("file")) {
                int classFileIndex = fileComponent.lastIndexOf(className);
                if (classFileIndex != -1) {
                    fileComponent = fileComponent.substring(0, classFileIndex);
                }
                File classFilesDir = new File(URLDecoder.decode(fileComponent, "UTF-8"));
                return classFilesDir;
            }
            if (classResource.getProtocol().equals("jar")) {
                int classSeparatorIndex = fileComponent.lastIndexOf("!");
                if (classSeparatorIndex != -1) {
                    fileComponent = fileComponent.substring(0, classSeparatorIndex);
                }
                URL u = new URL(URLDecoder.decode(fileComponent, "UTF-8"));
                File jarFile = new File(u.getFile());
                return jarFile;
            }
        }
        catch (UnsupportedEncodingException use) {
            use.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isWindows() {
        return cIsWin32 || cIsWin64;
    }

    public static boolean isUNCPath(String path) {
        if (!ComdevHelper.isWindows() || StringUtil.isNullOrEmpty(path)) {
            return false;
        }
        File f = new File(path);
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            path = f.getAbsolutePath();
        }
        return path.startsWith(File.separator + File.separator);
    }

    static {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("windows") != -1) {
            cIsWin32 = true;
            cLF = "\r\n";
        }
        cIsWin64 = false;
        if (cIsWin32 && (System.getProperty("os.arch").equals("ia64") || System.getProperty("os.arch").equals("amd64"))) {
            cIsWin64 = true;
        }
        cIsJDK14 = false;
        cIsJDK15 = false;
        String vmVersion = System.getProperty("java.vm.version");
        String vmVendor = System.getProperty("java.vm.vendor");
        if (vmVersion.indexOf("1.4") != -1 && vmVendor.indexOf("Sun") != -1) {
            cIsJDK14 = true;
        } else if (vmVersion.indexOf("1.5") != -1 && vmVendor.indexOf("Sun") != -1) {
            cIsJDK15 = true;
        }
    }
}

