/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeFilter;

public abstract class TreeFilterAdapter
implements TreeFilter {
    private Tree _root;

    public TreeFilterAdapter(Tree root) {
        this._root = root;
    }

    public TreeFilterAdapter() {
    }

    @Override
    public void setRoot(Tree t) {
        this._root = t;
    }

    @Override
    public Tree getRoot() {
        return this._root;
    }

    @Override
    public Tree getSubtree(Tree parent, int index) {
        int i;
        int count = 0;
        for (i = 0; i < parent.getDegree() && index > count - 1; ++i) {
            Tree t = parent.getSubtree(i);
            if (!this.isAccepted(t)) continue;
            ++count;
        }
        return index == count - 1 ? parent.getSubtree(i - 1) : null;
    }

    @Override
    public int getDegree(Tree t) {
        return this.getChildCount(t);
    }

    @Override
    public int getIndexOfSubtree(Tree parent, Tree child) {
        int index = -1;
        for (int i = 0; i < parent.getDegree(); ++i) {
            Tree t = parent.getSubtree(i);
            if (!this.isAccepted(t)) continue;
            ++index;
            if (t != child) continue;
            return index;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Tree node) {
        return node.isLeaf() || this.getChildCount(node) == 0;
    }

    public abstract boolean isAccepted(Tree var1);

    private int getChildCount(Tree t) {
        int count = 0;
        for (int i = 0; i < t.getDegree(); ++i) {
            Tree c = t.getSubtree(i);
            if (!this.isAccepted(c)) continue;
            ++count;
        }
        return count;
    }
}

