/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.LinkedList;

public class LinkedComponentsFocusPolicy
extends FocusTraversalPolicy {
    private LinkedList _linkedComps = null;

    public LinkedComponentsFocusPolicy(LinkedList linkedComps) {
        this._linkedComps = linkedComps;
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int pos = this._linkedComps.indexOf(aComponent);
        Component nextComp = pos == this._linkedComps.size() - 1 ? (Component)this._linkedComps.get(0) : (Component)this._linkedComps.get(pos + 1);
        if (nextComp != null) {
            nextComp.requestFocusInWindow();
            return nextComp;
        }
        return (Component)this._linkedComps.get(0);
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int pos = this._linkedComps.indexOf(aComponent);
        Component prevComp = pos == 0 ? (Component)this._linkedComps.get(this._linkedComps.size() - 1) : (pos < 0 ? null : (Component)this._linkedComps.get(pos - 1));
        if (prevComp != null) {
            return prevComp;
        }
        return (Component)this._linkedComps.get(0);
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return (Component)this._linkedComps.get(0);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return (Component)this._linkedComps.get(this._linkedComps.size() - 1);
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        return (Component)this._linkedComps.get(0);
    }
}

