/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.Execute;
import com.oracle.cie.common.util.FileSystemInfo;
import com.oracle.cie.common.util.Platform;
import com.oracle.cie.common.util.logging.LogFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class DetectFreeSpace {
    private static final Logger s_logger = Logger.getLogger(DetectFreeSpace.class.getName());
    private static final String windowsCommand = "@echo off" + Execute.newLineSep + "dir /w/-c %1 " + Execute.newLineSep;
    private static final String unixCommand = "if [ \"${#}\" -lt 1 ];then" + Execute.newLineSep + " echo 255;" + Execute.newLineSep + " exit 255;" + Execute.newLineSep + "fi" + Execute.newLineSep + "if [ -z \"${1}\" ];" + Execute.newLineSep + "then" + Execute.newLineSep + " echo 255;" + Execute.newLineSep + " exit 255;" + Execute.newLineSep + "fi" + Execute.newLineSep + "dirName=\"${1}\";" + Execute.newLineSep + "if [ -z \"${dirName}\" ];" + Execute.newLineSep + "then" + Execute.newLineSep + " echo 255;" + Execute.newLineSep + " exit 255;" + Execute.newLineSep + "fi" + Execute.newLineSep + Execute.newLineSep + Execute.newLineSep + "solarisDfCommand=\"/usr/xpg4/bin/df\";" + Execute.newLineSep + Execute.newLineSep + "linuxDfCommand=\"/bin/df\"" + Execute.newLineSep + "allOtherDfCommand=\"/usr/bin/df\"" + Execute.newLineSep + "command=\"${allOtherDfCommand}\";" + Execute.newLineSep + "command=\"${solarisDfCommand}\";" + Execute.newLineSep + Execute.newLineSep + "POSIXLY_CORRECT=\"1\";" + Execute.newLineSep + "export POSIXLY_CORRECT;" + Execute.newLineSep + "if [ -x \"${solarisDfCommand}\" ];" + Execute.newLineSep + "then" + Execute.newLineSep + " command=\"${solarisDfCommand}\";" + Execute.newLineSep + "elif [ -x \"${allOtherDfCommand}\" ];" + Execute.newLineSep + "then" + Execute.newLineSep + " command=\"${allOtherDfCommand}\";" + Execute.newLineSep + "elif [ -x \"${linuxDfCommand}\" ];" + Execute.newLineSep + "then" + Execute.newLineSep + " command=\"${linuxDfCommand}\";" + Execute.newLineSep + "else" + Execute.newLineSep + " echo 1;" + Execute.newLineSep + " exit 1;" + Execute.newLineSep + "fi" + Execute.newLineSep + "${command} -P ${dirName} " + Execute.newLineSep;

    private DetectFreeSpace() {
    }

    public static final synchronized FileSystemInfo findFreeSpace(String place) {
        FileSystemInfo fsi;
        block23: {
            s_logger.fine(".findFreeSpace()");
            s_logger.fine(" Using Os space detection");
            if (place == null || place.length() == 0) {
                return null;
            }
            fsi = null;
            try {
                File theFile;
                for (theFile = new File(place); theFile != null && !theFile.exists(); theFile = theFile.getParentFile()) {
                }
                if (theFile != null && theFile.exists()) {
                    int lineNum;
                    String fileSystemName = null;
                    String freeSpace = null;
                    String mountPt = null;
                    File tmpFile = File.createTempFile("execdf", ".cmd");
                    tmpFile.deleteOnExit();
                    int spacePos = 4;
                    int fileSystemNamePos = 1;
                    int mountPtPos = 0;
                    int maxPos = 4;
                    byte[] theBytes = null;
                    String realCommand = null;
                    if (Execute.osIsUnix) {
                        fileSystemNamePos = 1;
                        spacePos = 4;
                        mountPtPos = 6;
                        maxPos = 6;
                        theBytes = unixCommand.getBytes();
                        realCommand = "sh " + tmpFile.getAbsolutePath() + " " + theFile.getAbsolutePath();
                    } else if (Execute.osIsOldWindows) {
                        fileSystemNamePos = 1;
                        spacePos = 1;
                        maxPos = 3;
                        theBytes = windowsCommand.getBytes();
                        realCommand = tmpFile.getAbsolutePath() + " \"" + theFile.getAbsolutePath() + "\"";
                    } else if (Execute.osIsNewWindows) {
                        fileSystemNamePos = 1;
                        spacePos = 3;
                        maxPos = 5;
                        theBytes = windowsCommand.getBytes();
                        realCommand = tmpFile.getAbsolutePath() + " \"" + theFile.getAbsolutePath() + "\"";
                    } else {
                        s_logger.severe("detectFreeSpace: unknown OS");
                        return null;
                    }
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile));
                    out.write(theBytes, 0, theBytes.length);
                    out.flush();
                    out.close();
                    Execute execCommand = new Execute();
                    execCommand.exec(realCommand);
                    List errorList = execCommand.getErrorList();
                    if (!errorList.isEmpty()) {
                        s_logger.fine("detectFreeSpace: got error output");
                        for (String line : errorList) {
                            s_logger.severe(line);
                        }
                        return null;
                    }
                    List outputList = execCommand.getOutputList();
                    if (outputList.isEmpty()) break block23;
                    StringBuffer line = new StringBuffer();
                    int n = lineNum = Execute.osIsUnix ? 1 : outputList.size() - 1;
                    while (lineNum < outputList.size()) {
                        StringTokenizer parseFsName;
                        if (line.length() > 0) {
                            line.append(" ");
                        }
                        line.append(outputList.get(lineNum));
                        StringTokenizer parser = new StringTokenizer(line.toString(), " ");
                        if (parser.countTokens() == maxPos) {
                            int i = 0;
                            while (parser.hasMoreTokens()) {
                                String nextValue = parser.nextToken();
                                if (Execute.osIsUnix && ++i == fileSystemNamePos) {
                                    fileSystemName = nextValue;
                                }
                                if (i == spacePos) {
                                    freeSpace = nextValue;
                                }
                                if (!Execute.osIsUnix || i != mountPtPos) continue;
                                mountPt = nextValue;
                            }
                        }
                        if ((Execute.osIsOldWindows || Execute.osIsNewWindows) && (parseFsName = new StringTokenizer(theFile.getAbsolutePath(), ":")).countTokens() >= fileSystemNamePos) {
                            int i = 0;
                            while (parseFsName.hasMoreTokens()) {
                                String nextValue = parseFsName.nextToken();
                                if (++i != fileSystemNamePos) continue;
                                fileSystemName = nextValue;
                                mountPt = fileSystemName + ":\\";
                            }
                        }
                        if (fileSystemName != null && fileSystemName.length() > 0 && freeSpace != null && freeSpace.length() > 0) {
                            fsi = new FileSystemInfo(fileSystemName, freeSpace, mountPt);
                            if (!fileSystemName.equals(theFile.getAbsolutePath())) break block23;
                            line = new StringBuffer();
                            fileSystemName = null;
                            freeSpace = null;
                            mountPt = null;
                        }
                        ++lineNum;
                    }
                    break block23;
                }
                s_logger.severe("detectFreeSpace: file " + place + " does not exist");
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
        return fsi;
    }

    public static final long getFreeSpace(String place) {
        s_logger.fine("getFreeSpace: place=" + place);
        if (place == null || place.length() == 0) {
            return 0L;
        }
        return new File(place).getUsableSpace();
    }

    public static void main(String[] args) {
        LogFactory.getFactory().setupLogging("stdout", "debug", true, new String[0]);
        if (args.length <= 0) {
            System.out.println("usage: file");
        } else {
            FileSystemInfo fsi = DetectFreeSpace.findFreeSpace(args[0]);
            if (fsi != null) {
                System.out.println("fileSystemName='" + fsi.getName() + "' freeSpace'" + fsi.getFreeSpace() + "' mountPoint'" + fsi.getMountPoint() + "'");
            } else {
                System.out.println("result is null");
            }
        }
    }

    public static File[] listRoots() {
        File[] rootDirs = null;
        if (Platform.isWin()) {
            rootDirs = File.listRoots();
        } else {
            String[] fields;
            Execute execCommand = new Execute();
            execCommand.exec("df");
            List errorList = execCommand.getErrorList();
            if (!errorList.isEmpty()) {
                return null;
            }
            List outputList = execCommand.getOutputList();
            if (outputList.isEmpty()) {
                return null;
            }
            ArrayList<File> rootDirList = new ArrayList<File>();
            String expr = "\\s+";
            int id = -1;
            for (String line : outputList) {
                fields = line.split(expr);
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].equals("/")) continue;
                    id = i;
                    break;
                }
                if (id == -1) continue;
                break;
            }
            if (id == -1) {
                return null;
            }
            for (String line : outputList) {
                fields = line.split(expr);
                try {
                    if (!fields[id].startsWith("/")) continue;
                    rootDirList.add(new File(fields[id]));
                }
                catch (ArrayIndexOutOfBoundsException ar) {
                    return null;
                }
            }
            rootDirs = new File[rootDirList.size()];
            System.arraycopy(rootDirList.toArray(), 0, rootDirs, 0, rootDirList.size());
        }
        return rootDirs;
    }
}

