/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.ICommonConstants;
import com.oracle.cie.common.NVPair;
import com.oracle.cie.common.comdev.Base64;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOUtil {
    private static final Logger _log = Logger.getLogger(IOUtil.class.getName());
    private static final String INVALID_CHARACTERS_TEXT = "common.invalidFolder.text";
    private static final String INVALID_CHARACTERS_LEADING_TEXT = "common.invalidFolder.leading.text";
    private static final String ERROR_BACKUP = "common.error.backup";
    private static final String ERROR_BACKUP2 = "common.error.backup2";
    private static final String INVALID_FILE = "common.error.invalid.file";

    public static String getResourceString(String key) {
        ResourceBundleManager.manageBundles("comdev", ICommonConstants.COMMON_BUNDLES);
        return ResourceBundleManager.getString("comdev", key);
    }

    public static String getInvalidChars() {
        return IOUtil.getResourceString(INVALID_CHARACTERS_TEXT);
    }

    public static String getInvalidLeadingChars() {
        return IOUtil.getResourceString(INVALID_CHARACTERS_LEADING_TEXT);
    }

    public static boolean isValidFolderName(String folderName) {
        String invalidChars = IOUtil.getInvalidChars();
        if (invalidChars == null) {
            throw new RuntimeException("No character set found to check the validity of " + folderName);
        }
        for (int i = 0; i < invalidChars.length(); ++i) {
            if (folderName.indexOf(invalidChars.charAt(i)) < 0) continue;
            return false;
        }
        String invalidLeadingChars = IOUtil.getInvalidLeadingChars();
        if (invalidLeadingChars != null && invalidLeadingChars.trim().length() > 0) {
            invalidLeadingChars = invalidLeadingChars.trim();
            for (int i = 0; i < invalidLeadingChars.length(); ++i) {
                if (!folderName.startsWith(String.valueOf(invalidLeadingChars.charAt(i)))) continue;
                return false;
            }
        }
        return true;
    }

    public static String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (-1 == index) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String removePath(String filePath) {
        int index = filePath.lastIndexOf(File.separatorChar);
        if (-1 == index) {
            return filePath;
        }
        return filePath.substring(index + 1);
    }

    public static String removeName(String filePath) {
        int index = filePath.lastIndexOf(File.separatorChar);
        if (-1 == index) {
            return ".";
        }
        return filePath.substring(0, index);
    }

    public static void mkdirs(String name) {
        String path = IOUtil.removeName(name);
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static void rmdir(File dir) throws IOException {
        if (!dir.isDirectory()) {
            dir.delete();
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IOUtil.rmdir(f);
                }
                f.delete();
            }
        }
        dir.delete();
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int count;
        int BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        while (-1 != (count = input.read(buffer, 0, 4096))) {
            output.write(buffer, 0, count);
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.copy(is, baos);
        return baos.toByteArray();
    }

    public static byte[] toByteArray(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            byte[] byArray = IOUtil.toByteArray(connection.getInputStream());
            return byArray;
        }
        finally {
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    public static String toString(InputStream is) throws IOException {
        byte[] bytes = IOUtil.toByteArray(is);
        return bytes != null ? new String(bytes) : null;
    }

    public static String toString(URL url) throws IOException {
        byte[] bytes = IOUtil.toByteArray(url);
        return bytes != null ? new String(bytes) : null;
    }

    public static void copyURLToFile(URL url, File file) throws IOException {
        IOUtil.copyURLToFile(url, file, -1, -1);
    }

    public static void copyURLToFile(URL url, File file, int connectionTimeout, int readTimeout) throws IOException {
        IOUtil.copyURLToFile(url, file, connectionTimeout, readTimeout, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL url, File file, int connectionTimeout, int readTimeout, String username, String password) throws IOException {
        if (url == null) {
            throw new NullPointerException("The url specified was null.");
        }
        if (file == null) {
            throw new NullPointerException("The file specified was null.");
        }
        URLConnection connection = url.openConnection();
        try {
            if (connectionTimeout > 0) {
                connection.setConnectTimeout(connectionTimeout);
            }
            if (readTimeout > 0) {
                connection.setReadTimeout(readTimeout);
            }
            if (!StringUtil.isNullOrEmpty(username, true) && !StringUtil.isNullOrEmpty(password, true)) {
                String userPassword = username + ":" + password;
                String encoding = Base64.bytesToBase64(userPassword.getBytes());
                encoding = encoding.replaceAll("\n", "");
                connection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(file);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
        }
        finally {
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLToOutputStream(URL url, OutputStream outputStream, int connectionTimeout, int readTimeout, String username, String password) throws IOException {
        if (url == null) {
            throw new NullPointerException("The url specified was null.");
        }
        if (outputStream == null) {
            throw new NullPointerException("The output stream specified was null.");
        }
        int responseCode = 200;
        URLConnection connection = url.openConnection();
        if (connectionTimeout > 0) {
            connection.setConnectTimeout(connectionTimeout);
        }
        if (readTimeout > 0) {
            connection.setReadTimeout(readTimeout);
        }
        if (!StringUtil.isNullOrEmpty(username, true) && !StringUtil.isNullOrEmpty(password, true)) {
            String userPassword = username + ":" + password;
            String encoding = Base64.bytesToBase64(userPassword.getBytes());
            encoding = encoding.replaceAll("\n", "");
            connection.setRequestProperty("Authorization", "Basic " + encoding);
        }
        try {
            if (connection instanceof HttpURLConnection) {
                responseCode = ((HttpURLConnection)connection).getResponseCode();
            }
            if (responseCode == 200) {
                ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
                WritableByteChannel wbc = Channels.newChannel(outputStream);
                IOUtil.channelTransfer(rbc, wbc);
            }
        }
        finally {
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
        return responseCode;
    }

    public static void channelTransfer(ReadableByteChannel sourceChannel, WritableByteChannel destinationChannel) throws IOException {
        if (sourceChannel == null) {
            throw new IOException("The source channel specified was null");
        }
        if (destinationChannel == null) {
            throw new IOException("The destination channel specified was null");
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (sourceChannel.read(buffer) > -1) {
            buffer.flip();
            destinationChannel.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            destinationChannel.write(buffer);
        }
    }

    public static void bufferedCopy(InputStream source, OutputStream destination) throws IOException {
        BufferedInputStream input = new BufferedInputStream(source);
        BufferedOutputStream output = new BufferedOutputStream(destination);
        IOUtil.copy(input, output);
        output.flush();
    }

    public static boolean isDirectoryEmpty(String dir) {
        File f = new File(dir);
        String[] fileList = f.list();
        return fileList != null && fileList.length == 0;
    }

    public static String getPathOnly(File f) {
        if (f == null || !f.isFile()) {
            throw new IllegalArgumentException(IOUtil.getResourceString(INVALID_FILE));
        }
        String path = f.getAbsolutePath();
        int index = path.lastIndexOf(File.separatorChar);
        path = path.substring(0, index);
        return path;
    }

    public static NVPair getFileNameAndExtension(File f) {
        if (f == null || !f.isFile()) {
            throw new IllegalArgumentException(IOUtil.getResourceString(INVALID_FILE));
        }
        String fname = f.getName();
        int index = fname.lastIndexOf(46);
        NVPair pair = index != -1 ? new NVPair(fname.substring(0, index), index + 1 >= fname.length() ? "" : fname.substring(index + 1)) : new NVPair(fname, "");
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readTextFile(File f) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        char[] buffer = new char[1024];
        FileReader reader = null;
        try {
            int count;
            reader = new FileReader(f);
            while ((count = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, count);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sb;
    }

    public static File getBackupFile(File file) {
        return IOUtil.getTemporaryFile(file, ".bak");
    }

    public static File getTemporaryFile(File file, String ext) {
        Random r = new Random();
        int num = r.nextInt() & 0xFFFF;
        File f = new File(file.getParentFile(), file.getName() + num + ext);
        while (f.exists()) {
            num = r.nextInt() & 0xFFFF;
            f = new File(file.getParentFile(), file.getName() + num + ext);
        }
        return f;
    }

    public static File backupFile(File file, boolean copy) throws IOException {
        File backup = IOUtil.getBackupFile(file);
        if (copy) {
            try {
                FileCopy.copy(file, backup);
            }
            catch (IOException e) {
                if (backup != null && backup.exists()) {
                    backup.delete();
                }
                throw e;
            }
        } else if (!file.renameTo(backup)) {
            throw new IOException(IOUtil.getResourceString(ERROR_BACKUP) + " " + file + " " + IOUtil.getResourceString(ERROR_BACKUP2) + " " + backup);
        }
        return backup;
    }

    public static void getFileList(File file, List<File> list) {
        IOUtil.getFileList(file, list, false);
    }

    public static void getFileList(File file, List<File> list, boolean includeDirs) {
        if (file != null && list != null) {
            if (file.isDirectory()) {
                File[] files;
                if (includeDirs) {
                    list.add(file);
                }
                if ((files = file.listFiles()) != null) {
                    for (File f : files) {
                        IOUtil.getFileList(f, list);
                    }
                }
            } else if (file.exists()) {
                list.add(file);
            }
        }
    }

    public static Set<File> getFiles(File directory, FileFilter filter) throws IOException {
        return IOUtil.getFiles(directory, false, filter);
    }

    public static Set<File> getFiles(File directory, boolean filterDirs, FileFilter filter) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            throw new FileNotFoundException("You must provide a valid existing directory.");
        }
        HashSet<File> fileList = new HashSet<File>();
        File[] files = directory.listFiles(filter);
        if (files != null && files.length > 0) {
            if (filterDirs) {
                for (File f : files) {
                    if (f.isDirectory()) continue;
                    fileList.add(f);
                }
            } else {
                fileList.addAll(Arrays.asList(files));
            }
            for (File file : files) {
                if (!file.isDirectory()) continue;
                fileList.addAll(IOUtil.getFiles(file, filterDirs, filter));
            }
        }
        return fileList;
    }

    public static File getFile(String file) {
        return file == null ? null : IOUtil.getFile(new File(file));
    }

    public static File getFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, "Unable to convert file to canonical form: " + file, ex);
            return file.getAbsoluteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readLineChars(Reader reader, int bufferSize) throws IOException, ArrayIndexOutOfBoundsException {
        char[] buf = new char[bufferSize];
        try {
            int c;
            int indx = 0;
            while ((c = reader.read()) >= 0) {
                if (indx >= bufferSize) {
                    throw new ArrayIndexOutOfBoundsException("Line being read exceeds buffer size.");
                }
                if (c == 13) {
                    reader.mark(1);
                    c = reader.read();
                    if (c == 10 || c < 0) break;
                    reader.reset();
                    break;
                }
                if (c == 10) break;
                buf[indx++] = (char)c;
            }
            char[] cArray = Arrays.copyOfRange(buf, 0, indx);
            return cArray;
        }
        finally {
            Arrays.fill(buf, 0, bufferSize, ' ');
        }
    }
}

