/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarUtils {
    private static final Logger _logger = Logger.getLogger(JarUtils.class.getName());
    private static List<String> nonArchiveExtensions = Arrays.asList("pptx", "ppt");

    private JarUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchive(File file) {
        JarHelper jarHelper = null;
        try {
            jarHelper = new JarHelper(file);
            Collection<String> entries = jarHelper.getEntries();
            String extension = file.getName().contains(".") ? file.getName().substring(file.getName().lastIndexOf(".") + 1) : "";
            boolean bl = null != entries && !entries.isEmpty() && !nonArchiveExtensions.contains(extension);
            return bl;
        }
        catch (IOException ioException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (jarHelper != null) {
                jarHelper.close();
            }
        }
    }

    public static boolean isArchive(File jarFile, String entryName) throws IOException {
        JarHelper archiveHelper = new JarHelper(jarFile);
        boolean result = JarUtils.isArchive(archiveHelper, entryName);
        if (archiveHelper != null) {
            archiveHelper.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isArchive(JarHelper archiveHelper, String entryName) throws IOException {
        ZipEntry jarEntry = null;
        ZipInputStream jarIs = null;
        boolean isArchive = true;
        try {
            boolean bl;
            block20: {
                String entry;
                String jarEntryName = null;
                if (StringUtil.isNullOrEmpty(entryName)) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (entryName.endsWith("/")) {
                    entryName = entryName.substring(0, entryName.length() - 1);
                }
                entryName = entryName.replace("\\", "/");
                Iterator<String> iterator = archiveHelper.getEntries().iterator();
                while (iterator.hasNext() && (!(jarEntryName = (entry = iterator.next()).endsWith("/") ? entry.substring(0, entry.length() - 1) : entry).endsWith(entryName) || !entryName.equals(jarEntry = archiveHelper.getJarEntry(entry)) && !entryName.equals(entry))) {
                }
                if (jarEntry == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (jarEntry.isDirectory()) {
                    boolean bl4 = false;
                    return bl4;
                }
                BufferedInputStream bis = null;
                try {
                    String extension;
                    bis = new BufferedInputStream(archiveHelper.getInputStream(jarEntry.getName()));
                    jarIs = new JarInputStream(bis);
                    String string = extension = jarEntryName.contains(".") ? jarEntryName.substring(jarEntryName.lastIndexOf(".") + 1) : "";
                    if (((JarInputStream)jarIs).getNextJarEntry() == null && ((JarInputStream)jarIs).getManifest() == null || nonArchiveExtensions.contains(extension)) {
                        isArchive = false;
                    }
                    bl = isArchive;
                    if (bis == null) break block20;
                }
                catch (Exception e) {
                    boolean bl5;
                    block22: {
                        block21: {
                            _logger.warning("Invalid or corrupt file " + entryName + ". " + e);
                            bl5 = false;
                            if (bis == null) break block21;
                            bis.close();
                        }
                        if (jarIs == null) break block22;
                        jarIs.close();
                    }
                    return bl5;
                    {
                        catch (Throwable throwable) {
                            if (bis != null) {
                                bis.close();
                            }
                            throw throwable;
                        }
                    }
                }
                bis.close();
            }
            return bl;
        }
        finally {
            if (jarIs != null) {
                jarIs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(File jar, String jarEntryName) throws IllegalArgumentException, IOException {
        JarHelper jarHelper = null;
        try {
            jarHelper = new JarHelper(jar);
            boolean bl = JarUtils.contains(jarHelper, jarEntryName);
            return bl;
        }
        finally {
            if (jarHelper != null) {
                jarHelper.close();
            }
        }
    }

    public static boolean contains(JarHelper jarHelper, String jarEntryName) throws IllegalArgumentException, IOException {
        Collection<String> entries = jarHelper.getEntries();
        if (null == entries || entries.isEmpty()) {
            return false;
        }
        return entries.contains(jarEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractIntoTempFile(File parentJarFile, String innerEntryName) throws IOException {
        JarHelper jarHelper = null;
        try {
            jarHelper = new JarHelper(parentJarFile);
            File file = JarUtils.extractIntoTempFile(jarHelper, innerEntryName);
            return file;
        }
        finally {
            if (jarHelper != null) {
                jarHelper.close();
            }
        }
    }

    public static File extractIntoTempFile(JarHelper jarHelper, String innerEntryName) throws IOException {
        innerEntryName = innerEntryName.replace("\\", "/");
        JarEntry jarEntry = JarUtils.getJarEntry(jarHelper, innerEntryName);
        return JarUtils.extractIntoTempFile(jarHelper, jarEntry);
    }

    public static File extractIntoTempFile(JarHelper jarHelper, JarEntry jarEntry) throws IOException {
        File tempFile;
        File tmpDir;
        if (jarEntry == null) {
            return null;
        }
        String innerEntryName = jarEntry.getName();
        if (!StringUtil.isNullOrEmpty(System.getProperty("java.io.tmpdir")) && !(tmpDir = new File(System.getProperty("java.io.tmpdir"))).exists()) {
            tmpDir.mkdirs();
        }
        if (innerEntryName.contains("/") && !innerEntryName.endsWith("/")) {
            if (innerEntryName.substring(innerEntryName.lastIndexOf("/")).length() < 3) {
                innerEntryName = innerEntryName + "-temp";
            }
            tempFile = File.createTempFile(innerEntryName.substring(innerEntryName.lastIndexOf("/")), null);
        } else {
            tempFile = innerEntryName.endsWith("/") ? File.createTempFile(innerEntryName.substring(0, innerEntryName.length() - 1), null) : File.createTempFile(innerEntryName, null);
        }
        jarHelper.extract(jarEntry, tempFile);
        return tempFile;
    }

    public static JarEntry getJarEntry(JarHelper jarHelper, String entryName) {
        if (jarHelper == null || entryName == null) {
            throw new IllegalArgumentException("The jarHelper and entryName parameters are required.");
        }
        return jarHelper.getJarEntry(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasDifferentBytes(InputStream rootInputStream, InputStream diffInputStream) throws IOException {
        BufferedInputStream rootBis = null;
        BufferedInputStream diffBis = null;
        try {
            rootBis = new BufferedInputStream(rootInputStream);
            diffBis = new BufferedInputStream(diffInputStream);
            int baseEntryByte = rootBis.read();
            int entryByte = diffBis.read();
            while (baseEntryByte == entryByte && baseEntryByte != -1 && entryByte != -1) {
                baseEntryByte = rootBis.read();
                entryByte = diffBis.read();
            }
            if (baseEntryByte != entryByte) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (rootBis != null) {
                rootBis.close();
            }
            if (diffBis != null) {
                diffBis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getJarEntries(File jar, String regex) throws IllegalArgumentException, IOException {
        List<String> matchingEntries = null;
        JarHelper jarHelper = null;
        try {
            jarHelper = new JarHelper(jar);
            matchingEntries = JarUtils.getJarEntries(jarHelper.getEntries(), regex);
        }
        finally {
            if (jarHelper != null) {
                jarHelper.close();
            }
        }
        return matchingEntries;
    }

    public static List<String> getJarEntries(Collection<String> entries, String regex) {
        ArrayList<String> matchingEntries = new ArrayList<String>();
        for (String entry : entries) {
            if (regex != null && !entry.matches(regex)) continue;
            matchingEntries.add(entry);
        }
        return matchingEntries;
    }
}

