/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;

public class ManifestInfo {
    protected static final Logger s_logger = Logger.getLogger(ManifestInfo.class.getName());

    public static String getAttributeValue(JarFile jar, String name) throws IOException {
        return ManifestInfo.getAttributeValue(jar, name, null);
    }

    public static String getAttributeValue(JarFile jar, String name, String section) throws IOException {
        return ManifestInfo.getAttributeValue(jar, new Attributes.Name(name), section);
    }

    public static String getAttributeValue(JarFile jar, Attributes.Name name) throws IOException {
        return ManifestInfo.getAttributeValue(jar, name, null);
    }

    public static String getAttributeValue(JarFile jar, Attributes.Name name, String section) throws IOException {
        String value = null;
        Manifest manifest = jar.getManifest();
        if (manifest != null) {
            Attributes a = null;
            a = section != null ? manifest.getAttributes(section) : manifest.getMainAttributes();
            if (a != null) {
                value = a.getValue(name);
            } else {
                s_logger.warning("Unable to find any attributes in " + jar.getName());
            }
        } else {
            s_logger.warning("Unable to find a manifest in " + jar.getName());
        }
        return value;
    }

    public static String getRunningJarName(Class clazz) {
        String jarName = null;
        URL url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
        s_logger.fine("url=" + url);
        if ("jar".equals(url.getProtocol())) {
            try {
                jarName = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
                s_logger.fine("jarName=" + jarName);
                jarName = URLDecoder.decode(jarName, "UTF-8");
                jarName = new File(jarName).getCanonicalPath();
            }
            catch (UnsupportedEncodingException uee) {
                s_logger.fine("Caught UnsupportedEncodingException: " + uee.getMessage());
            }
            catch (IOException ioe) {
                s_logger.fine("Caught IOException: " + ioe.getMessage());
            }
        }
        s_logger.fine("getRunningJarName=" + jarName);
        return jarName;
    }

    public static JarFile getRunningJar(Class clazz) throws IOException {
        String jarName = ManifestInfo.getRunningJarName(clazz);
        return jarName != null ? new JarFile(jarName) : null;
    }

    public static String replaceAll(String s, String find, String replace) {
        StringBuffer buffer = new StringBuffer(s);
        int i = 0;
        while ((i = buffer.toString().indexOf(find, i)) > -1) {
            buffer.replace(i, i + find.length(), replace);
            i += replace.length();
        }
        return buffer.toString();
    }
}

