/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IOUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringSubstitution {
    public static boolean substituteString(String input, Map map, StringBuffer output) {
        Pattern pattern = Pattern.compile("@([^@\\s]+)@");
        Matcher m = pattern.matcher(input);
        if (!m.find()) {
            return false;
        }
        boolean changed = false;
        do {
            String found = m.group(0);
            String replacement = (String)map.get(found = found.substring(1, found.length() - 1));
            if (replacement == null) continue;
            m.appendReplacement(output, replacement);
            changed = true;
        } while (m.find());
        m.appendTail(output);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void substituteFile(File f, Map map) {
        String input;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            ByteArrayOutputStream bw = new ByteArrayOutputStream();
            IOUtil.bufferedCopy(is, bw);
            input = bw.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        StringBuffer output = new StringBuffer();
        boolean changed = StringSubstitution.substituteString(input, map, output);
        if (!changed) {
            return;
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(f));
            os.write(output.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

