/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.xmldiff;

import com.oracle.cie.common.xmldiff.XmlDiffAction;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffTree;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XmlDiffApplicator {
    private static final Logger _log = Logger.getLogger(XmlDiffApplicator.class.getName());
    private XmlDiffAspect _aspect;
    private XmlDiffTree _xmlDiffTree;
    private XmlDiffTreeFilter _xmlDiffTreeFilter;
    private boolean _orderBasedProcessing = false;
    private String _idKey;
    private boolean _ignoreMissingElements = Boolean.getBoolean("XmlDiffApplicator.ignore.missing.elements");
    private boolean _tolerateMissingElements = Boolean.getBoolean("XmlDiffApplicator.tolerate.missing.elements");

    public static void applyDiff(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree) throws XmlDiffException {
        XmlDiffApplicator.applyDiff(aspect, xmlDiffTree, false);
    }

    public static void applyDiff(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree, XmlDiffTreeFilter xmlDiffTreeFilter) throws XmlDiffException {
        XmlDiffApplicator.applyDiff(aspect, xmlDiffTree, false, xmlDiffTreeFilter);
    }

    public static void applyDiff(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree, boolean orderBasedProcessing) throws XmlDiffException {
        XmlDiffApplicator.applyDiff(aspect, xmlDiffTree, orderBasedProcessing, null);
    }

    public static void applyDiff(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree, boolean orderBasedProcessing, XmlDiffTreeFilter xmlDiffTreeFilter) throws XmlDiffException {
        XmlDiffApplicator xmlDiff = new XmlDiffApplicator(aspect, xmlDiffTree, xmlDiffTreeFilter);
        xmlDiff.setOrderBasedProcessing(orderBasedProcessing);
        xmlDiff.apply();
    }

    public static void fixupDiff(XmlDiffAspect aspect, XmlDiffTree node) throws XmlDiffException {
        XmlDiffApplicator.fixupDiff(aspect, node, null);
    }

    public static void fixupDiff(XmlDiffAspect aspect, XmlDiffTree node, XmlDiffTreeFilter xmlDiffTreeFilter) throws XmlDiffException {
        XmlDiffApplicator xmlDiff = new XmlDiffApplicator(aspect, node, xmlDiffTreeFilter);
        xmlDiff.fixup();
    }

    public XmlDiffApplicator(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree) throws XmlDiffException {
        this(aspect, xmlDiffTree, (String)null);
    }

    public XmlDiffApplicator(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree, XmlDiffTreeFilter xmlDiffTreeFilter) throws XmlDiffException {
        this(aspect, xmlDiffTree, null, xmlDiffTreeFilter);
    }

    public XmlDiffApplicator(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree, String idKey) throws XmlDiffException {
        this(aspect, xmlDiffTree, idKey, null);
    }

    public XmlDiffApplicator(XmlDiffAspect aspect, XmlDiffTree xmlDiffTree, String idKey, XmlDiffTreeFilter xmlDiffTreeFilter) throws XmlDiffException {
        this._aspect = aspect;
        this._xmlDiffTree = xmlDiffTree;
        this._idKey = idKey != null ? idKey : "Id";
        this._xmlDiffTreeFilter = xmlDiffTreeFilter;
        if (this._aspect == null) {
            throw new XmlDiffException("The aspect specified was null.");
        }
        if (this._xmlDiffTree == null) {
            throw new XmlDiffException("The xml diff tree specified was null.");
        }
        if (!aspect.getElement().equals(xmlDiffTree.getElementName())) {
            throw new XmlDiffException("Cannot apply diff aspect which do not match the diff tree element.");
        }
    }

    public XmlDiffTree getDiffTree() {
        return this._xmlDiffTree;
    }

    public XmlDiffAspect getAspect() {
        return this._aspect;
    }

    public boolean isOrderBasedProcessing() {
        return this._orderBasedProcessing;
    }

    public void setOrderBasedProcessing(boolean orderBasedProcessing) {
        this._orderBasedProcessing = orderBasedProcessing;
    }

    public boolean isIgnoreMissingElements() {
        return this._ignoreMissingElements;
    }

    public boolean isTolerateMissingElements() {
        return this._tolerateMissingElements;
    }

    public void setTolerateMissingElements(boolean tolerateMissingElements) {
        this._tolerateMissingElements = tolerateMissingElements;
    }

    public void setIgnoreMissingElements(boolean ignoreMissingElements) {
        this._ignoreMissingElements = ignoreMissingElements;
    }

    public void apply() throws XmlDiffException {
        this.applyElements(this.getAspect(), this.getDiffTree());
    }

    protected void applyElements(XmlDiffAspect aspect, XmlDiffTree node) throws XmlDiffException {
        if (!aspect.getElement().equals(node.getElementName())) {
            throw new XmlDiffException("The aspect and xml diff tree node did not reference the same element.");
        }
        if (!node.hasChange() || this._xmlDiffTreeFilter != null && this._xmlDiffTreeFilter.excludeComplexElement(aspect)) {
            return;
        }
        if (node.getAction().isModify() || node.getAction().isCreate()) {
            this.applySimpleTypes(aspect, node);
            this.applyAttributes(aspect, node);
        }
        Map<String, List<XmlDiffTree>> childrenMap = node.getChildrenMap();
        for (String complexName : childrenMap.keySet()) {
            List<XmlDiffTree> treeChildren = childrenMap.get(complexName);
            XmlDiffAspect[] childAspectsArray = aspect.getComplexValue(complexName);
            List<AspectTreeMapping> mappings = this.getXmlDiffAspectTreeMappings(treeChildren, childAspectsArray, node, aspect);
            ArrayList<XmlDiffAspect> modifiedChildAspects = new ArrayList<XmlDiffAspect>();
            boolean modifiedChildren = false;
            for (AspectTreeMapping mapping : mappings) {
                XmlDiffAspect childAspect = mapping.getAspect();
                XmlDiffTree childTree = mapping.getTree();
                if (childAspect == null) {
                    if (childTree.getAction().isCreate()) {
                        modifiedChildren = true;
                        XmlDiffAspect newChildAspect = aspect.createComplexValue(complexName);
                        if (newChildAspect == null) {
                            throw new XmlDiffException("Failed to create child aspect of type " + complexName);
                        }
                        modifiedChildAspects.add(newChildAspect);
                        this.applyElements(newChildAspect, childTree);
                        continue;
                    }
                    if (!childTree.hasChange()) continue;
                    String message = "The xml and diff tree nodes are not in sync. Unable to find child element(s) in XML.\nParent XML Node: " + aspect + "\nParent DiffTree Node: " + node.toString("", false);
                    if (this.isIgnoreMissingElements() || this.isTolerateMissingElements()) {
                        _log.warning(message);
                        if (!this.isTolerateMissingElements() || !childTree.getAction().isModify()) continue;
                        boolean found = false;
                        for (AspectTreeMapping mapping2 : mappings) {
                            if (!this.treeMatchesAspect(childTree, mapping2.getAspect(), true)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        modifiedChildren = true;
                        XmlDiffAspect newChildAspect = aspect.createComplexValue(complexName);
                        if (newChildAspect == null) {
                            throw new XmlDiffException("Failed to create child aspect of type " + complexName);
                        }
                        modifiedChildAspects.add(newChildAspect);
                        this.applyElements(newChildAspect, childTree);
                        continue;
                    }
                    throw new XmlDiffException(message);
                }
                if (childTree == null) {
                    modifiedChildAspects.add(childAspect);
                    continue;
                }
                if (childTree.getAction().isDelete()) {
                    modifiedChildren = true;
                    continue;
                }
                modifiedChildAspects.add(childAspect);
                this.applyElements(childAspect, childTree);
            }
            if (!modifiedChildren) continue;
            aspect.setComplexValue(complexName, !modifiedChildAspects.isEmpty() ? modifiedChildAspects.toArray(new XmlDiffAspect[modifiedChildAspects.size()]) : null);
        }
    }

    private List<AspectTreeMapping> getXmlDiffAspectTreeMappings(List<XmlDiffTree> childXmlDiffTrees, XmlDiffAspect[] childAspectsArray, XmlDiffTree parentTree, XmlDiffAspect parentAspect) throws XmlDiffException {
        ArrayList<AspectTreeMapping> mappings;
        block13: {
            ArrayList<XmlDiffTree> treeChildren;
            block12: {
                treeChildren = new ArrayList<XmlDiffTree>();
                if (childXmlDiffTrees != null) {
                    treeChildren.addAll(childXmlDiffTrees);
                }
                ArrayList<XmlDiffAspect> childAspects = new ArrayList<XmlDiffAspect>();
                if (childAspectsArray != null) {
                    childAspects.addAll(Arrays.asList(childAspectsArray));
                }
                mappings = new ArrayList<AspectTreeMapping>();
                boolean noMatches = true;
                if (!this.isOrderBasedProcessing()) {
                    for (XmlDiffAspect xmlDiffAspect : childAspects) {
                        XmlDiffTree diffTree = null;
                        Iterator it = treeChildren.iterator();
                        while (it.hasNext()) {
                            XmlDiffTree tree = (XmlDiffTree)it.next();
                            if (!this.treeMatchesAspect(tree, xmlDiffAspect)) continue;
                            diffTree = tree;
                            it.remove();
                            noMatches = false;
                            break;
                        }
                        mappings.add(new AspectTreeMapping(xmlDiffAspect, diffTree));
                    }
                }
                if (!noMatches) break block12;
                mappings.clear();
                int order = 0;
                for (XmlDiffTree diffTree : treeChildren) {
                    XmlDiffAspect childAspect;
                    if (diffTree.getAction().isCreate()) {
                        mappings.add(new AspectTreeMapping(null, diffTree));
                        continue;
                    }
                    if (childAspectsArray == null || childAspectsArray.length <= order) {
                        String message = "The xml and diff tree nodes are not in sync. Expected additional child element(s) in XML.\nParent XML Node: " + parentAspect + "\nParent DiffTree Node: " + parentTree.toString("", false) + "\nChild DiffTree Node:" + diffTree.toString("", false);
                        if (!this.isIgnoreMissingElements()) {
                            throw new XmlDiffException(message);
                        }
                        _log.warning(message);
                        childAspect = null;
                    } else {
                        childAspect = childAspectsArray[order];
                    }
                    mappings.add(new AspectTreeMapping(childAspect, diffTree));
                    ++order;
                }
                break block13;
            }
            if (childXmlDiffTrees == null || treeChildren.isEmpty()) break block13;
            for (XmlDiffTree xmlDiffTree : treeChildren) {
                AspectTreeMapping mapping = new AspectTreeMapping(null, xmlDiffTree);
                int index = childXmlDiffTrees.indexOf(xmlDiffTree);
                if (index >= mappings.size()) {
                    mappings.add(mapping);
                    continue;
                }
                mappings.add(index, mapping);
            }
        }
        return mappings;
    }

    private boolean treeMatchesAspect(XmlDiffTree diffTree, XmlDiffAspect aspect) {
        return this.treeMatchesAspect(diffTree, aspect, false);
    }

    private boolean treeMatchesAspect(XmlDiffTree diffTree, XmlDiffAspect aspect, boolean forceCurrentValue) {
        if (diffTree == null || aspect == null || diffTree.getAttributes().isEmpty() ^ aspect.getAttributeNames().length == 0) {
            return false;
        }
        for (Map.Entry<String, XmlDiffTree.DiffTreeAttribute> attributes : diffTree.getAttributes().entrySet()) {
            Object originalValue;
            String attributeName = attributes.getKey();
            if (this._xmlDiffTreeFilter != null && this._xmlDiffTreeFilter.excludeAttribute(aspect, attributeName)) continue;
            XmlDiffTree.DiffTreeAttribute attribute = attributes.getValue();
            if (!aspect.hasAttributeName(attributeName)) {
                return false;
            }
            Object attributeValue = this.convertEnumValue(aspect.getAttributeValue(attributeName));
            if (forceCurrentValue) {
                originalValue = this.convertEnumValue(attribute.getCurrentValue());
            } else {
                originalValue = this.convertEnumValue(attribute.getOriginalValue());
                if (originalValue == null && !attribute.getAction().isModify()) {
                    originalValue = this.convertEnumValue(attribute.getCurrentValue());
                }
            }
            if (!(attributeValue == null ^ originalValue == null) && (attributeValue == null || attributeValue.equals(originalValue))) continue;
            return false;
        }
        return true;
    }

    private Object convertEnumValue(Object object) {
        block3: {
            if (object != null && object.getClass().isEnum()) {
                try {
                    object = object.getClass().getMethod("value", new Class[0]).invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Failed to get value from enum " + object.getClass() + " value=" + object);
                    if (!_log.isLoggable(Level.FINER)) break block3;
                    _log.log(Level.FINER, "Failed to get value from enum " + object.getClass() + " value=" + object, e);
                }
            }
        }
        return object;
    }

    public void fixup() throws XmlDiffException {
        this.fixup(this.getAspect(), this.getDiffTree());
    }

    protected void fixup(XmlDiffAspect aspect, XmlDiffTree node) throws XmlDiffException {
        if (!aspect.getElement().equals(node.getElementName())) {
            throw new XmlDiffException("The aspect and xml diff tree node did not reference the same element.");
        }
        if (this._xmlDiffTreeFilter != null && this._xmlDiffTreeFilter.excludeComplexElement(aspect)) {
            return;
        }
        Map<String, List<XmlDiffTree>> childrenMap = node.getChildrenMap();
        for (String complexName : childrenMap.keySet()) {
            List<AspectTreeMapping> mappings;
            List<XmlDiffTree> treeChildren = childrenMap.get(complexName);
            XmlDiffAspect[] childAspectsArray = aspect.getComplexValue(complexName);
            try {
                mappings = this.getXmlDiffAspectTreeMappings(treeChildren, childAspectsArray, node, aspect);
            }
            catch (XmlDiffException e) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Failed to get xml diff aspect tree mappings, fixup will be skipped the " + complexName + " child elements...", e);
                    continue;
                }
                _log.log(Level.WARNING, "Failed to get xml diff aspect tree mappings, fixup will be skipped the " + complexName + " child elements...");
                continue;
            }
            ArrayList<XmlDiffTree> modifiedDiffTrees = new ArrayList<XmlDiffTree>();
            for (AspectTreeMapping mapping : mappings) {
                XmlDiffTree childTree = mapping.getTree();
                XmlDiffAspect childAspect = mapping.getAspect();
                if (childTree != null) {
                    if (childAspect != null || childTree.getAction().isCreate()) {
                        modifiedDiffTrees.add(childTree);
                        if (childAspect == null) continue;
                        this.fixup(childAspect, childTree);
                        if (childTree.getAction().isCreate()) {
                            childTree.setAction(XmlDiffAction.NONE);
                            for (XmlDiffTree.DiffTreeAttribute attribute : childTree.getAttributes().values()) {
                                attribute.setAction(XmlDiffAction.NONE);
                            }
                        }
                        this.fixupAttributes(childAspect, childTree.getAttributes());
                        this.fixupAttributes(childAspect, childTree.getSimpleTypes());
                        continue;
                    }
                    if (!childTree.hasChange()) continue;
                    throw new XmlDiffException("Failed to fix up xml diff because diff tree has changes in node that could not be located in the XML.\nParent XML Node: " + aspect + "\nParent DiffTree Node: " + node.toString("", false) + "\nChild DiffTree Node:" + childTree.toString("", false));
                }
                XmlDiffTree missingTree = new XmlDiffTree(childAspect.getElement(), XmlDiffAction.NONE);
                for (String attribute : childAspect.getAttributeNames()) {
                    missingTree.addAttribute(attribute, childAspect.getAttributeType(attribute), null, childAspect.getAttributeValue(attribute), XmlDiffAction.NONE);
                }
                modifiedDiffTrees.add(missingTree);
            }
            node.setChildren(complexName, modifiedDiffTrees);
        }
    }

    protected void fixupAttributes(XmlDiffAspect childAspect, Map<String, XmlDiffTree.DiffTreeAttribute> childAttributes) {
        for (XmlDiffTree.DiffTreeAttribute attribute : childAttributes.values()) {
            if (attribute.getAction().isCreate() || !childAspect.hasAttributeName(attribute.getName())) continue;
            Object attributeValue = childAspect.getAttributeValue(attribute.getName());
            if (attribute.getAction().isModify()) {
                attribute.setOriginalValue(attributeValue);
                continue;
            }
            attribute.setCurrentValue(attributeValue);
        }
    }

    protected void applySimpleTypes(XmlDiffAspect aspect, XmlDiffTree node) {
        Set<String> simpleNames = node.getSimpleTypeNames();
        if (simpleNames != null && !simpleNames.isEmpty()) {
            for (String simpleName : simpleNames) {
                if (!node.hasSimpleTypeModification(simpleName) || this._xmlDiffTreeFilter != null && this._xmlDiffTreeFilter.excludeSimpleElement(simpleName, aspect.getSimpleValue(simpleName))) continue;
                Object value = node.getSimpleTypeValue(simpleName);
                Object currentValue = aspect.getSimpleValue(simpleName);
                if (currentValue == null && value == null || currentValue != null && currentValue.equals(value)) continue;
                aspect.setSimpleValue(simpleName, value);
            }
        }
    }

    protected void applyAttributes(XmlDiffAspect aspect, XmlDiffTree node) {
        Set<String> attributes = node.getAttributeNames();
        if (attributes != null && !attributes.isEmpty()) {
            for (String attrib : attributes) {
                if (!node.hasAttributeModification(attrib) || this._xmlDiffTreeFilter != null && this._xmlDiffTreeFilter.excludeAttribute(aspect, attrib)) continue;
                Object value = node.getAttributeValue(attrib);
                Object currentValue = aspect.getAttributeValue(attrib);
                if (currentValue == null && value == null || currentValue != null && currentValue.equals(value)) continue;
                aspect.setAttributeValue(attrib, value);
            }
        }
    }

    class AspectTreeMapping {
        XmlDiffAspect _aspect;
        XmlDiffTree _tree;

        public AspectTreeMapping(XmlDiffAspect aspect, XmlDiffTree tree) {
            this._aspect = aspect;
            this._tree = tree;
        }

        public XmlDiffAspect getAspect() {
            return this._aspect;
        }

        public XmlDiffTree getTree() {
            return this._tree;
        }
    }
}

