/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.xmldiff;

import com.oracle.cie.common.xmldiff.XmlDiffAction;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XmlDiffMerge
implements Cloneable {
    private static final Logger _log = Logger.getLogger(XmlDiffMerge.class.getName());
    private List<XmlDiffTree> _xmlDiffTrees = new ArrayList<XmlDiffTree>();
    private boolean _ignoreMergeConflicts = Boolean.getBoolean("XmlDiffTree.ignore.merge.conflicts");

    public XmlDiffMerge(XmlDiffTree ... xmlDiffTrees) {
        if (xmlDiffTrees != null) {
            for (XmlDiffTree diffTree : xmlDiffTrees) {
                this.addDiffTree(diffTree);
            }
        }
    }

    public void addDiffTree(XmlDiffTree diffTree) {
        this._xmlDiffTrees.add(diffTree);
    }

    public List<XmlDiffTree> getXmlDiffTrees() {
        return this._xmlDiffTrees;
    }

    public boolean isIgnoreMergeConflicts() {
        return this._ignoreMergeConflicts;
    }

    public void setIgnoreMergeConflicts(boolean ignoreMergeConflicts) {
        this._ignoreMergeConflicts = ignoreMergeConflicts;
    }

    public XmlDiffTree merge() throws XmlDiffException {
        List<XmlDiffTree> xmlDiffTrees = this.getXmlDiffTrees();
        if (xmlDiffTrees.size() < 2) {
            throw new XmlDiffException("At least two diff trees must be provided.");
        }
        XmlDiffTree merged = this.mergeElements(xmlDiffTrees.get(0), xmlDiffTrees.get(1));
        for (int x = 2; x < xmlDiffTrees.size(); ++x) {
            merged = this.mergeElements(merged, xmlDiffTrees.get(x));
        }
        return merged;
    }

    private XmlDiffTree mergeElements(XmlDiffTree diffTree1, XmlDiffTree diffTree2) throws XmlDiffException {
        ArrayList<XmlDiffTree> merged;
        String elementName;
        String name;
        if (diffTree1 == null && diffTree2 == null) {
            throw new XmlDiffException("The diff trees specified for merging were null.");
        }
        try {
            if (diffTree1 == null || diffTree1.getAction().isNone() && diffTree2 != null && diffTree2.getAction().isDelete() || diffTree1.getAction().isDelete() && diffTree2 != null && diffTree2.getAction().isDelete()) {
                return (XmlDiffTree)diffTree2.clone();
            }
            if (diffTree2 == null || diffTree2.getAction().isNone() && diffTree1.getAction().isDelete()) {
                return (XmlDiffTree)diffTree1.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new XmlDiffException("Failed to clone diff tree.", e);
        }
        if (!diffTree1.getElementName().equals(diffTree2.getElementName())) {
            throw new XmlDiffException("The first diff tree's element name \"" + diffTree1.getElementName() + "\" was not the same as the second diff tree's element name \"" + diffTree2.getElementName() + "\".");
        }
        if (diffTree1.getAction().isDelete() && diffTree2.getAction().isModify() || diffTree1.getAction().isModify() && diffTree2.getAction().isDelete()) {
            String message = "Encountered conflicting element diff action " + diffTree1.toString(false) + " vs. " + diffTree2.toString(false);
            if (this.isIgnoreMergeConflicts()) {
                _log.warning(message);
            } else {
                throw new XmlDiffException(message);
            }
        }
        XmlDiffTree mergedDiffTree = new XmlDiffTree(diffTree1.getElementName(), diffTree1.getId());
        if (diffTree1.getAction().isCreate() || diffTree2.getAction().isCreate()) {
            mergedDiffTree.setAction(XmlDiffAction.CREATE);
        }
        try {
            Map<String, XmlDiffTree.DiffTreeAttribute> attributes1 = diffTree1.getAttributes();
            LinkedHashMap<String, XmlDiffTree.DiffTreeAttribute> attributes2 = new LinkedHashMap<String, XmlDiffTree.DiffTreeAttribute>(diffTree2.getAttributes());
            for (Map.Entry<String, XmlDiffTree.DiffTreeAttribute> entry : attributes1.entrySet()) {
                name = entry.getKey();
                XmlDiffTree.DiffTreeAttribute attribute1 = entry.getValue();
                XmlDiffTree.DiffTreeAttribute attribute2 = (XmlDiffTree.DiffTreeAttribute)attributes2.remove(name);
                mergedDiffTree.addAttribute(name, this.getMergedAttribute(attribute1, attribute2, "attribute"));
            }
            if (!attributes2.isEmpty()) {
                for (Map.Entry<String, XmlDiffTree.DiffTreeAttribute> entry : attributes2.entrySet()) {
                    mergedDiffTree.addAttribute(entry.getKey(), (XmlDiffTree.DiffTreeAttribute)entry.getValue().clone());
                }
            }
        }
        catch (CloneNotSupportedException e) {
            throw new XmlDiffException("Failed to clone diff tree attribute.", e);
        }
        try {
            Map<String, XmlDiffTree.DiffTreeAttribute> simples1 = diffTree1.getSimpleTypes();
            LinkedHashMap<String, XmlDiffTree.DiffTreeAttribute> simples2 = new LinkedHashMap<String, XmlDiffTree.DiffTreeAttribute>(diffTree2.getSimpleTypes());
            for (Map.Entry<String, XmlDiffTree.DiffTreeAttribute> entry : simples1.entrySet()) {
                name = entry.getKey();
                XmlDiffTree.DiffTreeAttribute simple1 = entry.getValue();
                XmlDiffTree.DiffTreeAttribute simple2 = (XmlDiffTree.DiffTreeAttribute)simples2.remove(name);
                mergedDiffTree.addSimpleType(name, this.getMergedAttribute(simple1, simple2, "simple type"));
            }
            if (!simples2.isEmpty()) {
                for (Map.Entry<String, XmlDiffTree.DiffTreeAttribute> entry : simples2.entrySet()) {
                    mergedDiffTree.addSimpleType(entry.getKey(), (XmlDiffTree.DiffTreeAttribute)entry.getValue().clone());
                }
            }
        }
        catch (CloneNotSupportedException e) {
            throw new XmlDiffException("Failed to clone diff tree attribute.", e);
        }
        Map<String, List<XmlDiffTree>> childrenMap1 = diffTree1.getChildrenMap();
        LinkedHashMap<String, List<XmlDiffTree>> childrenMap2 = new LinkedHashMap<String, List<XmlDiffTree>>(diffTree2.getChildrenMap());
        for (Map.Entry<String, Object> entry : childrenMap1.entrySet()) {
            elementName = entry.getKey();
            List<DiffTreeMapping> diffTreeMappings = this.getXmlDiffAspectTreeMappings((List)entry.getValue(), (List)childrenMap2.remove(elementName), diffTree1, diffTree2);
            merged = new ArrayList();
            mergedDiffTree.setChildren(elementName, merged);
            for (DiffTreeMapping diffTreeMapping : diffTreeMappings) {
                XmlDiffTree tree1 = diffTreeMapping.getTree1();
                XmlDiffTree tree2 = diffTreeMapping.getTree2();
                merged.add(this.mergeElements(tree1, tree2));
            }
        }
        for (Map.Entry<String, Object> entry : childrenMap2.entrySet()) {
            elementName = entry.getKey();
            List elements2 = (List)entry.getValue();
            merged = new ArrayList<XmlDiffTree>();
            mergedDiffTree.setChildren(elementName, merged);
            for (XmlDiffTree element2 : elements2) {
                merged.add(this.mergeElements(null, element2));
            }
        }
        return mergedDiffTree;
    }

    private XmlDiffTree.DiffTreeAttribute getMergedAttribute(XmlDiffTree.DiffTreeAttribute attribute1, XmlDiffTree.DiffTreeAttribute attribute2, String type) throws XmlDiffException {
        try {
            XmlDiffTree.DiffTreeAttribute attribute;
            if (attribute1 == null && attribute2 == null) {
                throw new XmlDiffException("Both " + type + " objects provided cannot be null.");
            }
            if (attribute1 == null) {
                return (XmlDiffTree.DiffTreeAttribute)attribute2.clone();
            }
            if (attribute2 == null || attribute2.getAction().isNone() || attribute1.getAction().isDelete() && attribute2.getAction().isDelete()) {
                return (XmlDiffTree.DiffTreeAttribute)attribute1.clone();
            }
            if (!(attribute1.getAction().isNone() || attribute2.getAction().isNone() || this.attributeValuesMatch(attribute1, attribute2, true))) {
                String message = "Encountered conflicting " + type + " diff action " + attribute1.toString() + " vs. " + attribute2.toString();
                if (this.isIgnoreMergeConflicts()) {
                    _log.warning(message);
                } else {
                    throw new XmlDiffException(message);
                }
            }
            if (attribute1.getAction().isModify() && attribute2.getAction().isCreate()) {
                attribute = (XmlDiffTree.DiffTreeAttribute)attribute1.clone();
                attribute.setAction(XmlDiffAction.CREATE);
            } else if (attribute2.getAction().isModify() && attribute1.getAction().isCreate()) {
                attribute = (XmlDiffTree.DiffTreeAttribute)attribute2.clone();
                attribute.setAction(XmlDiffAction.CREATE);
            } else {
                attribute = (XmlDiffTree.DiffTreeAttribute)attribute2.clone();
            }
            return attribute;
        }
        catch (CloneNotSupportedException e) {
            throw new XmlDiffException("Failed to clone diff tree " + type + ".", e);
        }
    }

    private List<DiffTreeMapping> getXmlDiffAspectTreeMappings(List<XmlDiffTree> childXmlDiffTrees1, List<XmlDiffTree> childXmlDiffTrees2, XmlDiffTree parentTree1, XmlDiffTree parentTree2) throws XmlDiffException {
        ArrayList<XmlDiffTree> treeChildren1 = new ArrayList<XmlDiffTree>();
        if (childXmlDiffTrees1 != null) {
            treeChildren1.addAll(childXmlDiffTrees1);
        }
        ArrayList<XmlDiffTree> treeChildren2 = new ArrayList<XmlDiffTree>();
        if (childXmlDiffTrees2 != null) {
            treeChildren2.addAll(childXmlDiffTrees2);
        }
        ArrayList<DiffTreeMapping> mappings = new ArrayList<DiffTreeMapping>();
        boolean noMatches = true;
        for (XmlDiffTree xmlDiffTree : treeChildren1) {
            XmlDiffTree diffTree = null;
            Iterator it = treeChildren2.iterator();
            while (it.hasNext()) {
                XmlDiffTree tree2 = (XmlDiffTree)it.next();
                if (!this.treesMatch(xmlDiffTree, tree2)) continue;
                diffTree = tree2;
                it.remove();
                noMatches = false;
                break;
            }
            mappings.add(new DiffTreeMapping(xmlDiffTree, diffTree));
        }
        if (noMatches) {
            mappings.clear();
            Iterator treeChildren2Iterator = treeChildren2.iterator();
            for (XmlDiffTree diffTree1 : treeChildren1) {
                if (diffTree1.getAction().isCreate()) {
                    mappings.add(new DiffTreeMapping(diffTree1, null));
                    continue;
                }
                XmlDiffTree diffTree2 = null;
                try {
                    diffTree2 = (XmlDiffTree)treeChildren2Iterator.next();
                    while (diffTree2 != null && diffTree2.getAction().isCreate()) {
                        mappings.add(new DiffTreeMapping(null, diffTree2));
                        treeChildren2Iterator.remove();
                        diffTree2 = (XmlDiffTree)treeChildren2Iterator.next();
                    }
                }
                catch (NoSuchElementException e) {
                    String message = "The xml tree nodes are not in sync. Expected additional child tree.\nParent DiffTree Node1: " + parentTree1 + "\nParent DiffTree Node2: " + parentTree2 + "\nChild DiffTree Node:" + diffTree1.toString("", false);
                    if (this.isIgnoreMergeConflicts()) {
                        _log.log(Level.WARNING, message, e);
                    }
                    throw new XmlDiffException(message, e);
                }
                mappings.add(new DiffTreeMapping(diffTree1, diffTree2));
                treeChildren2Iterator.remove();
            }
        }
        if (childXmlDiffTrees2 != null && !treeChildren2.isEmpty()) {
            for (XmlDiffTree xmlDiffTree : treeChildren2) {
                DiffTreeMapping mapping = new DiffTreeMapping(null, xmlDiffTree);
                int index = childXmlDiffTrees2.indexOf(xmlDiffTree);
                if (index >= mappings.size()) {
                    mappings.add(mapping);
                    continue;
                }
                mappings.add(index, mapping);
            }
        }
        return mappings;
    }

    private boolean treesMatch(XmlDiffTree diffTree1, XmlDiffTree diffTree2) {
        if (diffTree1 == null || diffTree2 == null || diffTree1.getAttributes().isEmpty() ^ diffTree2.getAttributes().isEmpty()) {
            return false;
        }
        Map<String, XmlDiffTree.DiffTreeAttribute> attributes1 = diffTree1.getAttributes();
        Map<String, XmlDiffTree.DiffTreeAttribute> attributes2 = diffTree2.getAttributes();
        if (attributes1.isEmpty() ^ attributes2.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, XmlDiffTree.DiffTreeAttribute> entry : attributes1.entrySet()) {
            if (this.attributeValuesMatch(entry.getValue(), attributes2.get(entry.getKey()), false)) continue;
            return false;
        }
        return true;
    }

    private boolean attributeValuesMatch(XmlDiffTree.DiffTreeAttribute attribute1, XmlDiffTree.DiffTreeAttribute attribute2, boolean useCurrentValue) {
        if (attribute1 == null && attribute2 == null) {
            return true;
        }
        if (attribute1 == null || attribute2 == null) {
            return false;
        }
        if (useCurrentValue) {
            Object value2;
            Object value1 = attribute1.getCurrentValue();
            if (value1 == null ^ (value2 = attribute2.getCurrentValue()) == null || value1 != null && !value1.equals(value2)) {
                return false;
            }
        } else if (attribute1.getAction().isModify() && attribute2.getAction().isCreate()) {
            Object currentValue1 = attribute1.getCurrentValue();
            Object originalValue1 = attribute1.getOriginalValue();
            Object value2 = attribute2.getCurrentValue();
            if (value2 == null || !value2.equals(currentValue1) && !value2.equals(originalValue1)) {
                return false;
            }
        } else if (attribute2.getAction().isModify() && attribute1.getAction().isCreate()) {
            Object value1 = attribute1.getCurrentValue();
            Object currentValue2 = attribute2.getCurrentValue();
            Object originalValue2 = attribute2.getOriginalValue();
            if (value1 == null || !value1.equals(currentValue2) && !value1.equals(originalValue2)) {
                return false;
            }
        } else {
            Object value2;
            Object value1 = attribute1.getAction().isCreate() || attribute1.getAction().isNone() ? attribute1.getCurrentValue() : attribute1.getOriginalValue();
            if (value1 == null ^ (value2 = attribute2.getAction().isCreate() || attribute2.getAction().isNone() ? attribute2.getCurrentValue() : attribute2.getOriginalValue()) == null || value1 != null && !value1.equals(value2)) {
                return false;
            }
        }
        return true;
    }

    class DiffTreeMapping {
        XmlDiffTree _tree1;
        XmlDiffTree _tree2;

        public DiffTreeMapping(XmlDiffTree tree1, XmlDiffTree tree2) {
            this._tree1 = tree1;
            this._tree2 = tree2;
        }

        public XmlDiffTree getTree1() {
            return this._tree1;
        }

        public XmlDiffTree getTree2() {
            return this._tree2;
        }
    }
}

