/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OPatchAutoCleanupShutdownHook {
    private static boolean _debug = Boolean.getBoolean("OPatchAutoCleanupShutdownHook.debug");
    public static boolean _isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
    public static final String DELETE_SCRIPT_PREFIX = "delete";
    public static final String DELETE_SCRIPT_EXT_WINDOWS = ".cmd";
    public static final String DELETE_SCRIPT_EXT_UNIX = ".sh";
    public static String DELETE_SCRIPT_SLEEP_SECONDS = System.getProperty("oracle.installer.delete_script_sleep_seconds", "10");
    private static boolean _hookRegistered;
    private static Set<File> _files;
    private static Set<File> _directories;
    private static Set<File> _forceFiles;
    private static Set<File> _forceDirs;
    public static String LS;

    public static Set<File> getFiles() {
        return _files;
    }

    public static Set<File> getDirectories() {
        return _directories;
    }

    public static void add(File file) {
        OPatchAutoCleanupShutdownHook.add(file, false);
    }

    public static void add(File file, boolean force) {
        if (file != null) {
            if (!_hookRegistered) {
                OPatchAutoCleanupShutdownHook.registerShutdownHook();
            }
            if (file.isDirectory()) {
                if (force) {
                    _forceDirs.add(file);
                } else {
                    _directories.add(file);
                }
            } else if (force) {
                _forceFiles.add(file);
            } else {
                _files.add(file);
            }
        }
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                OPatchAutoHelper.restoreStandardStreams();
                OPatchAutoCleanupShutdownHook.runHooks();
            }
        });
        _hookRegistered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<OPatchAutoCleanupShutdownHook> clazz = OPatchAutoCleanupShutdownHook.class;
        synchronized (OPatchAutoCleanupShutdownHook.class) {
            Set<File> files = _files;
            Set<File> directories = _directories;
            Set<File> forceFiles = _forceFiles;
            Set<File> forceDirs = _forceDirs;
            _files = null;
            _directories = null;
            _forceFiles = null;
            _forceDirs = null;
            // ** MonitorExit[var4] (shouldn't be in output)
            if (_debug) {
                System.out.println("Executing shutdown hook to create delete script");
            }
            ArrayList<File> filesToBeDeleted = new ArrayList<File>(files);
            ArrayList<File> dirsToBeDeleted = new ArrayList<File>(directories);
            ArrayList<File> forceFilesToBeDeleted = new ArrayList<File>(forceFiles);
            ArrayList<File> forceDirsToBeDeleted = new ArrayList<File>(forceDirs);
            Collections.sort(dirsToBeDeleted);
            Collections.reverse(dirsToBeDeleted);
            Collections.sort(forceDirsToBeDeleted);
            Collections.reverse(forceDirsToBeDeleted);
            try {
                File scriptLocation = OPatchAutoCleanupShutdownHook.generateDeleteScript(filesToBeDeleted, forceFilesToBeDeleted, dirsToBeDeleted, forceDirsToBeDeleted);
                if (scriptLocation != null && scriptLocation.exists()) {
                    OPatchAutoCleanupShutdownHook.invokeDeleteScript(scriptLocation);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File generateDeleteScript(List<File> files, List<File> forceFiles, List<File> directories, List<File> forceDirs) throws IOException {
        if (_debug) {
            System.out.println("Generating delete script, files=" + (files == null ? "0" : Integer.valueOf(files.size())) + " forceFiles=" + (forceFiles == null ? "0" : Integer.valueOf(forceFiles.size())) + " directories=" + (directories == null ? "0" : Integer.valueOf(directories.size())) + " forceDirs=" + (forceDirs == null ? "0" : Integer.valueOf(forceDirs.size())));
        }
        ArrayList<String> deletes = new ArrayList<String>();
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                if (!file.exists()) continue;
                if (_debug) {
                    System.out.println("Adding file " + file.getPath());
                }
                deletes.add(OPatchAutoCleanupShutdownHook.getDeleteCommand(file, false, false));
            }
        }
        if (forceFiles != null && !forceFiles.isEmpty()) {
            for (File file : forceFiles) {
                if (!file.exists()) continue;
                if (_debug) {
                    System.out.println("Adding file " + file.getPath());
                }
                deletes.add(OPatchAutoCleanupShutdownHook.getDeleteCommand(file, false, true));
            }
        }
        if (directories != null && !directories.isEmpty()) {
            Collections.sort(directories);
            Collections.reverse(directories);
            for (File dir : directories) {
                if (!dir.exists() || !dir.isAbsolute()) continue;
                if (_debug) {
                    System.out.println("Adding directory " + dir.getPath());
                }
                deletes.add(OPatchAutoCleanupShutdownHook.getDeleteCommand(dir, true, false));
            }
        }
        if (forceDirs != null && !forceDirs.isEmpty()) {
            Collections.sort(forceDirs);
            Collections.reverse(forceDirs);
            for (File f : forceDirs) {
                if (!f.exists() || !f.isAbsolute()) continue;
                if (_debug) {
                    System.out.println("Adding force directory " + f.getPath());
                }
                deletes.add(OPatchAutoCleanupShutdownHook.getDeleteCommand(f, true, true));
            }
        }
        if (!deletes.isEmpty()) {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            tmpDir.mkdirs();
            String ext = _isWindows ? DELETE_SCRIPT_EXT_WINDOWS : DELETE_SCRIPT_EXT_UNIX;
            String name = DELETE_SCRIPT_PREFIX + OPatchAutoHelper.getCurrentDateTimeStamp("yyMMddHHmm") + ext;
            File deleteScript = new File(tmpDir, name);
            BufferedWriter bw = new BufferedWriter(new FileWriter(deleteScript));
            if (_isWindows) {
                bw.write("@ECHO OFF" + LS);
                bw.write("ping -n " + DELETE_SCRIPT_SLEEP_SECONDS + " 127.0.0.1 > nul" + LS);
            } else {
                bw.write("sleep " + DELETE_SCRIPT_SLEEP_SECONDS + LS);
            }
            for (String delete : deletes) {
                bw.write(delete + LS);
            }
            if (!_debug) {
                if (_isWindows) {
                    bw.write("(goto) 2>nul & del \"%~f0\"" + LS);
                } else {
                    bw.write(OPatchAutoCleanupShutdownHook.getDeleteCommand(deleteScript, false, true) + LS);
                }
            }
            bw.flush();
            bw.close();
            if (_debug) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(deleteScript));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (Exception e) {
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            return deleteScript;
        }
        if (_debug) {
            System.out.println("Shutdownhook delete script unnecessary");
        }
        return null;
    }

    private static String getDeleteCommand(File file, boolean dir, boolean force) {
        if (_isWindows) {
            if (dir) {
                if (force) {
                    return "RMDIR /S /Q \"" + file.getAbsolutePath().replace("/", "\\") + "\"";
                }
                return "CMD /C RMDIR \"" + file.getAbsolutePath().replace("/", "\\") + "\"";
            }
            if (force) {
                return "DEL /F \"" + file.getAbsolutePath().replace("/", "\\") + "\"";
            }
            return "DEL \"" + file.getAbsolutePath().replace("/", "\\") + "\"";
        }
        if (dir) {
            if (force) {
                return "rm -rf " + file.getAbsolutePath().replace("\\", "/");
            }
            return "rmdir " + file.getAbsolutePath().replace("\\", "/");
        }
        if (force) {
            return "rm -f " + file.getAbsolutePath().replace("\\", "/");
        }
        return "rm " + file.getAbsolutePath().replace("\\", "/");
    }

    private static void invokeDeleteScript(File scriptLocation) throws IOException {
        String[] stringArray;
        if (_debug) {
            System.out.println("Invoking delete script: " + scriptLocation.getAbsolutePath());
        }
        if (_isWindows) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "CMD";
            stringArray2[1] = "/C";
            stringArray = stringArray2;
            stringArray2[2] = scriptLocation.getPath();
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "sh";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = scriptLocation.getAbsolutePath();
        }
        String[] command = stringArray;
        OPatchAutoHelper.runtimeExec(Arrays.asList(command), scriptLocation.getParentFile(), null, true, false);
    }

    static {
        _files = new LinkedHashSet<File>();
        _directories = new LinkedHashSet<File>();
        _forceFiles = new LinkedHashSet<File>();
        _forceDirs = new LinkedHashSet<File>();
        LS = System.getProperty("line.separator");
    }
}

