/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.plan;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.plan.PatchPlanTargets;
import com.oracle.glcm.patch.auto.plan.PatchPlanTargetsImpl;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PatchPlanManager {
    private ProductSupportManager _productSupportManager;
    private Map<String, Set<PatchTarget>> _patchTargets = new HashMap<String, Set<PatchTarget>>();
    private PatchPlanTargets _currentPatchPlanTargets;
    private Map<String, PatchPlanTargets> _cache = new HashMap<String, PatchPlanTargets>();

    public static PatchPlanManager createPatchPlanManager(ProductSupportManager productSupportManager, PatchTarget ... patchTargets) {
        PatchPlanManager patchPlanManager = new PatchPlanManager();
        patchPlanManager.setProductSupportManager(productSupportManager);
        patchPlanManager.registerPatchTargets(patchTargets);
        return patchPlanManager;
    }

    public ProductSupportManager getProductSupportManager() {
        return this._productSupportManager;
    }

    public void setProductSupportManager(ProductSupportManager productSupportManager) {
        this._productSupportManager = productSupportManager;
    }

    public Set<PatchTarget> getPatchTargets() {
        HashSet<PatchTarget> patchTargets = new HashSet<PatchTarget>();
        for (Set<PatchTarget> targets : this._patchTargets.values()) {
            if (targets == null) continue;
            patchTargets.addAll(targets);
        }
        return patchTargets;
    }

    public Set<PatchTarget> getPatchTargets(String type) {
        HashSet<PatchTarget> patchTargets = new HashSet<PatchTarget>();
        Set<PatchTarget> targets = this._patchTargets.get(type);
        if (targets != null) {
            patchTargets.addAll(targets);
        }
        return patchTargets;
    }

    private PatchPlanTargets getPatchPlanTargets(Set<String> types, String cacheKey, String parentKey, boolean consolidateSharedHomes, boolean currentParentContainer) {
        PatchPlanTargets patchPlanTargets = null;
        if (types != null && !types.isEmpty()) {
            patchPlanTargets = this._cache.get(cacheKey);
            if (patchPlanTargets == null) {
                patchPlanTargets = new PatchPlanTargetsImpl(types, this.getProductSupportManager());
                if (!StringUtil.isNullOrEmpty((String)parentKey, (boolean)true)) {
                    PatchPlanTargets parentPatchPlanTargets = this._cache.get(parentKey);
                    if (parentPatchPlanTargets == null) {
                        throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68087", parentKey));
                    }
                    if (currentParentContainer && !parentPatchPlanTargets.isIncremental()) {
                        throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68088", parentKey));
                    }
                    patchPlanTargets.addPatchTargets(parentPatchPlanTargets.getPatchTargets(currentParentContainer, types));
                } else {
                    for (String type : types) {
                        patchPlanTargets.addPatchTargets((Collection<PatchTarget>)this._patchTargets.get(type));
                    }
                }
                this._cache.put(cacheKey, patchPlanTargets);
            }
            patchPlanTargets.setConsolidateSharedHomes(consolidateSharedHomes);
        }
        return patchPlanTargets;
    }

    public void registerPatchTargets(PatchTarget ... patchTargets) {
        if (patchTargets != null && patchTargets.length > 0) {
            for (PatchTarget patchTarget : patchTargets) {
                this.registerPatchTarget(patchTarget);
            }
        }
    }

    public void registerPatchTarget(PatchTarget patchTarget) {
        if (patchTarget != null) {
            String type = patchTarget.getType();
            Set<PatchTarget> patchTargets = this._patchTargets.get(type);
            if (patchTargets == null) {
                patchTargets = new LinkedHashSet<PatchTarget>();
                this._patchTargets.put(type, patchTargets);
            }
            patchTargets.add(patchTarget);
        }
    }

    public PatchPlanTargets getCurrentPatchPlanTargets() {
        if (this._currentPatchPlanTargets == null) {
            this.setCurrentPatchPlanTargetsTypes(null, false, "ALL", null, false, false);
        }
        return this._currentPatchPlanTargets;
    }

    public void setCurrentPatchPlanTargetsTypes(String currentPatchPlanTargetsType, boolean excludeDefault, String cacheKey, String parentKey, boolean consolidateSharedHomes, boolean currentParentContainer) {
        this._currentPatchPlanTargets = this.getPatchPlanTargets(this.getTypesSet(currentPatchPlanTargetsType, excludeDefault), cacheKey, parentKey, consolidateSharedHomes, currentParentContainer);
    }

    public void setCurrentPatchPlanTargetsTypes(String cacheKey, boolean consolidateSharedHomes) {
        PatchPlanTargets targets = this._cache.get(cacheKey);
        if (targets == null) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68089", cacheKey));
        }
        targets.setConsolidateSharedHomes(consolidateSharedHomes);
        this._currentPatchPlanTargets = targets;
    }

    public void resetPatchPlanTargets(String cacheKey) {
        PatchPlanTargets patchPlanTargets = this._cache.remove(cacheKey);
        if (patchPlanTargets != null) {
            patchPlanTargets.disposeIncrementalIterator();
        }
    }

    private Set<String> getTypesSet(String types, boolean excludeDefault) {
        LinkedHashSet<String> typesSet = new LinkedHashSet<String>();
        if (StringUtil.isNullOrEmpty((String)types, (boolean)true)) {
            typesSet.addAll(this._patchTargets.keySet());
        } else {
            for (String type : types.split(",")) {
                typesSet.add(type.trim());
            }
        }
        if (excludeDefault) {
            typesSet.remove("default");
        }
        return typesSet;
    }

    public boolean hasPatchPlanTargets(String cacheKey) {
        return this._cache.containsKey(cacheKey);
    }

    public boolean isLocalHomeTargetForPatching(String homeDir, Set<ProductType> productTypes) throws OPatchAutoException {
        if (homeDir != null && productTypes != null && !productTypes.isEmpty()) {
            LinkedHashSet<PatchTarget> patchTargets = new LinkedHashSet<PatchTarget>();
            for (ProductType productType : productTypes) {
                if (productType == null) continue;
                patchTargets.addAll(this.getPatchTargets(productType.getType()));
            }
            if (!patchTargets.isEmpty()) {
                File homeFile = ComdevHelper.isWindows() ? IOUtil.getFile((String)homeDir) : new File(homeDir);
                for (PatchTarget patchTarget : patchTargets) {
                    File targetHome;
                    File file = targetHome = ComdevHelper.isWindows() ? IOUtil.getFile((String)patchTarget.getHome(true).getLocation()) : new File(patchTarget.getHome(true).getLocation());
                    if (patchTarget.isRemote() || !homeFile.equals(targetHome)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

