/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.product;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.OPatchAutoOptionsException;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionManager;
import com.oracle.glcm.patch.auto.action.PatchActionManagerImpl;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.product.ProductTypeImpl;
import com.oracle.glcm.patch.auto.product.SupportType;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class ProductSupportManager {
    public static final String DEFAULT_PRODUCT_SUPPORT_TYPE = "default";
    private Set<ProductSupport> _productSupport = this.loadProductSupport();
    private ProductSupport _defaultProductSupport;
    private static ProductType _defaultProductType;
    private OPatchAutoOptions _options;
    private PatchActionManager _patchActionManager;

    public static ProductSupportManager getInstance() throws OPatchAutoException {
        return new ProductSupportManager();
    }

    protected ProductSupportManager() throws OPatchAutoException {
        this.loadResourceBundles();
    }

    protected Set<ProductSupport> loadProductSupport() throws OPatchAutoException {
        ServiceLoader<ProductSupport> loader = ServiceLoader.load(ProductSupport.class, OPatchAutoHelper.getPluginClassLoader());
        LinkedHashSet<ProductSupport> productSupports = new LinkedHashSet<ProductSupport>();
        for (ProductSupport productSupport : loader) {
            productSupports.add(productSupport);
            if (!DEFAULT_PRODUCT_SUPPORT_TYPE.equals(productSupport.getId())) continue;
            this._defaultProductSupport = productSupport;
        }
        if (this._defaultProductSupport == null && !Boolean.getBoolean("ProductSupportManager.default.product.support.optional")) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68092", new Object[0]));
        }
        for (ProductSupport productSupport : productSupports) {
            OPatchAutoHelper.getInstance().updatePluginClassLoader(productSupport.getAdditionalClasspath());
        }
        return productSupports;
    }

    protected void loadResourceBundles() throws OPatchAutoException {
        for (ProductSupport productSupport : this.getProductSupport()) {
            Set<String> resourceBundles = productSupport.getResourceBundles();
            if (resourceBundles == null) continue;
            for (String resourceBundle : resourceBundles) {
                ResourceBundleManager.manageBundle((String)"opatchauto", (String)resourceBundle, (ClassLoader)OPatchAutoHelper.getPluginClassLoader());
            }
        }
    }

    protected PatchActionManager loadPatchActions(OPatchAutoCommand command) throws OPatchAutoException {
        LinkedHashSet<Class<? extends PatchAction>> patchActionClasses = new LinkedHashSet<Class<? extends PatchAction>>();
        for (ProductSupport productSupport : this.getProductSupport()) {
            Set<Class<? extends PatchAction>> productClasses = productSupport.getPatchActions(command, this._options);
            if (productClasses == null) continue;
            patchActionClasses.addAll(productClasses);
        }
        this._patchActionManager = new PatchActionManagerImpl(patchActionClasses);
        return this._patchActionManager;
    }

    public Set<ProductSupport> getProductSupport() {
        return Collections.unmodifiableSet(this._productSupport);
    }

    public Set<ProductType> getProductSupportTypes(SupportType supportType) {
        LinkedHashSet<ProductType> types = new LinkedHashSet<ProductType>();
        for (ProductSupport support : this.getProductSupport()) {
            for (ProductType type : support.getTypes()) {
                if (supportType != type.getSupportType()) continue;
                types.add(type);
            }
        }
        return types;
    }

    public ProductSupport getProductSupportForProductType(String type) {
        for (ProductSupport support : this.getProductSupport()) {
            for (ProductType productType : support.getTypes()) {
                if (!productType.getType().equalsIgnoreCase(type)) continue;
                return support;
            }
        }
        return null;
    }

    public ProductSupport getProductSupport(String id) {
        for (ProductSupport support : this.getProductSupport()) {
            if (!support.getId().equalsIgnoreCase(id)) continue;
            return support;
        }
        return null;
    }

    public ProductSupport getDefaultProductSupport() {
        return this._defaultProductSupport;
    }

    public Set<String> getProductIds() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (ProductSupport support : this.getProductSupport()) {
            types.add(support.getId());
        }
        return types;
    }

    public OPatchAutoOptions getOptions() throws OPatchAutoException {
        if (this._options == null) {
            this._options = OPatchAutoOptions.getInstance();
            this._options.loadProductOptions(this);
        }
        return this._options;
    }

    public PatchActionManager getPatchActionManager() {
        return this._patchActionManager;
    }

    public void updatePatchActionOptions(Set<Goal> goals) throws OPatchAutoException {
        if (goals != null && !goals.isEmpty()) {
            for (Goal goal : goals) {
                List<PatchAction> patchActions = this.getPatchActionManager().getPatchActions(goal);
                if (patchActions == null) continue;
                for (PatchAction patchAction : patchActions) {
                    patchAction.updateOptions(this.getOptions(), goals);
                }
            }
        }
    }

    public void updateProductOptions() throws OPatchAutoException {
        for (ProductSupport productSupport : this.getProductSupport()) {
            productSupport.updateOptions(this._options);
        }
    }

    public void initialize(OPatchAutoCommand command) throws OPatchAutoException {
        for (ProductSupport productSupport : this.getProductSupport()) {
            productSupport.initialize(command, this._options);
        }
        this.loadPatchActions(command);
    }

    public Map<String, String> getPluginVersions() {
        LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
        for (ProductSupport productSupport : this.getProductSupport()) {
            Map<String, String> vers = productSupport.getPluginVersions();
            if (vers == null) continue;
            versions.putAll(vers);
        }
        return versions;
    }

    public void closeSession(OPatchAutoCommand command, boolean isSuccessful) {
        for (ProductSupport productSupport : this.getProductSupport()) {
            productSupport.closeSession(command, isSuccessful);
        }
    }

    public ProductSupport getHomeCloningProductSupport(PatchTarget patchTarget) throws OPatchAutoException {
        ProductSupport productSupport = null;
        for (ProductSupport ps : this.getProductSupport()) {
            if (!ps.isHomeCloningSupported(patchTarget)) continue;
            if (productSupport != null) {
                throw new OPatchAutoException("68093", patchTarget.getHome(), productSupport.getId(), ps.getId());
            }
            productSupport = ps;
        }
        return productSupport;
    }

    public boolean isDefaultTopologyDisabled() throws OPatchAutoException {
        for (ProductSupport productSupport : this.getProductSupport()) {
            if (!productSupport.isDefaultTopologyDisable(this.getOptions())) continue;
            return true;
        }
        return false;
    }

    public Set<ProductType> getExternalOPatchAutoProductTypes() {
        LinkedHashSet<ProductType> productTypes = new LinkedHashSet<ProductType>();
        for (ProductSupport productSupport : this.getProductSupport()) {
            Set<ProductType> types = productSupport.getExternalOPatchAutoProductTypes();
            if (types == null) continue;
            productTypes.addAll(types);
        }
        return productTypes;
    }

    private static Set<String> getDefaultProductTypeMarkerFilePaths() {
        LinkedHashSet<String> markers = new LinkedHashSet<String>();
        markers.add("inventory/registry.xml");
        markers.add("inventory/ContentsXML/comps.xml");
        return markers;
    }

    public static ProductType getDefaultProductType() {
        if (_defaultProductType == null) {
            _defaultProductType = new ProductTypeImpl(DEFAULT_PRODUCT_SUPPORT_TYPE, SupportType.home, (Set)ProductSupportManager.getDefaultProductTypeMarkerFilePaths(), true){

                @Override
                public boolean isSupportedHome(Home home) throws OPatchAutoException {
                    boolean supported = super.isSupportedHome(home);
                    if (!supported) {
                        if (home.getHost().isRemote()) {
                            throw new OPatchAutoException("68094", home.getHost().getHost(), home.getLocation());
                        }
                        throw new OPatchAutoException("68095", home.getLocation());
                    }
                    return true;
                }
            };
        }
        return _defaultProductType;
    }

    public void validatePatchPlanName(String patchPlan) throws OPatchAutoException {
        if (!StringUtil.isNullOrEmpty((String)patchPlan, (boolean)true)) {
            for (ProductSupport productSupport : this.getProductSupport()) {
                Set<String> patchPlans = productSupport.getPatchPlans();
                if (patchPlans == null || !patchPlans.contains(patchPlan)) continue;
                return;
            }
            throw new OPatchAutoOptionsException("68096", patchPlan);
        }
    }

    public void postPatchSessionInit(PatchSession patchSession) throws OPatchAutoException {
        if (patchSession != null) {
            for (ProductSupport productSupport : this.getProductSupport()) {
                productSupport.postPatchSessionInit(patchSession);
            }
        }
    }

    public void validatePatchSession(PatchSession patchSession) throws OPatchAutoException {
        if (patchSession != null) {
            for (ProductSupport productSupport : this.getProductSupport()) {
                productSupport.validatePatchSession(patchSession);
            }
        }
    }

    public Set<OPatchAutoCommand> getUnsupportedCommand() {
        HashSet<OPatchAutoCommand> unsupportedCommands = new HashSet<OPatchAutoCommand>();
        for (ProductSupport productSupport : this.getProductSupport()) {
            Set<? extends OPatchAutoCommand> unsupportedCommand = productSupport.getUnsupportedCommand();
            if (unsupportedCommand == null || unsupportedCommand.isEmpty()) continue;
            unsupportedCommands.addAll(unsupportedCommand);
        }
        return unsupportedCommands;
    }

    public void initializeOPatchAutoReporting(String reportingType) throws OPatchAutoException {
        for (ProductSupport productSupport : this.getProductSupport()) {
            productSupport.initializeOPatchAutoReporting(reportingType);
        }
    }
}

