/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.topology;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.product.SupportType;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Instance;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomeImpl
implements Home {
    private static final Logger _log = Logger.getLogger(HomeImpl.class.getName());
    private String _location;
    private List<ProductType> _productTypes = new ArrayList<ProductType>();
    private Host _host;
    private List<Instance> _instances = new ArrayList<Instance>();
    private String _invPtrLoc;
    private List<Home> _sharedHomeList = new ArrayList<Home>();
    private Map<String, String> _remoteExecEnvVars;
    private String _owner;
    private String _version;
    private boolean _gimr;

    @Override
    public String getLocation() {
        return this._location;
    }

    @Override
    public void setLocation(String location) {
        this._location = location;
    }

    @Override
    public Set<ProductType> getProductTypes() {
        return new LinkedHashSet<ProductType>(this._productTypes);
    }

    @Override
    public void addProductType(ProductType productType) {
        if (productType != null && !this._productTypes.contains(productType)) {
            if (!productType.getSupportType().isHome()) {
                throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68106", new Object[]{SupportType.home}));
            }
            this._productTypes.add(productType);
        }
    }

    @Override
    public void addProductTypes(Set<ProductType> productTypes) {
        if (productTypes != null) {
            for (ProductType productType : productTypes) {
                this.addProductType(productType);
            }
        }
    }

    @Override
    public void setProductTypes(Set<ProductType> productTypes) {
        if (!this._productTypes.isEmpty()) {
            this._productTypes.clear();
        }
        if (productTypes != null) {
            this.addProductTypes(productTypes);
        }
    }

    @Override
    public Host getHost() {
        return this._host;
    }

    @Override
    public void setHost(Host host) {
        this._host = host;
    }

    @Override
    public Set<Instance> getInstances() {
        return new LinkedHashSet<Instance>(this._instances);
    }

    @Override
    public void setInstances(Set<Instance> instances) {
        if (!this._instances.isEmpty()) {
            this._instances.clear();
        }
        if (instances != null) {
            for (Instance instance : instances) {
                this.addInstance(instance);
            }
        }
    }

    @Override
    public void addInstance(Instance instance) {
        if (instance != null && !this._instances.contains(instance)) {
            this._instances.add(instance);
        }
    }

    @Override
    public String getInvPtrLoc() {
        File invPtrLocFile;
        if (StringUtil.isNullOrEmpty((String)this._invPtrLoc, (boolean)true) && !ComdevHelper.isWindows() && (invPtrLocFile = new File(this.getLocation(), "/oraInst.loc")).exists()) {
            return invPtrLocFile.getAbsolutePath();
        }
        return this._invPtrLoc;
    }

    public void setInvPtrLoc(String invPtrLoc) {
        this._invPtrLoc = invPtrLoc;
    }

    @Override
    public List<Home> getSharedHomeList() {
        return new ArrayList<Home>(this._sharedHomeList);
    }

    @Override
    public String getDisplayLocation() {
        boolean isRemote = false;
        try {
            isRemote = this.getHost().isRemote();
        }
        catch (OPatchAutoException e) {
            _log.log(Level.WARNING, "Failed to determine if host " + this.getHost() + " is remote.", e);
        }
        return (isRemote ? this.getHost().getHost() + ":" : "") + this.getLocation();
    }

    @Override
    public Map<String, String> getRemoteExecEnvVars() {
        return this._remoteExecEnvVars;
    }

    public void setRemoteExecEnvVars(Map<String, String> remoteExecEnvVars) {
        this._remoteExecEnvVars = remoteExecEnvVars;
    }

    public void setSharedHomeList(List<Home> sharedHomeList) {
        if (!this._sharedHomeList.isEmpty()) {
            this._sharedHomeList.clear();
        }
        this._sharedHomeList.addAll(sharedHomeList);
    }

    @Override
    public boolean isSharedHome() {
        return this._sharedHomeList != null && !this._sharedHomeList.isEmpty();
    }

    @Override
    public String getOwner() {
        return this._owner;
    }

    @Override
    public void setOwner(String owner) {
        this._owner = owner;
    }

    @Override
    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    public boolean isGIMRHome() {
        return this._gimr;
    }

    public void setGIMR(boolean _gimr) {
        this._gimr = _gimr;
    }

    @Override
    public Home getShallowCopy() {
        HomeImpl home = new HomeImpl();
        home._location = this._location;
        home._invPtrLoc = this._invPtrLoc;
        home._productTypes.addAll(this._productTypes);
        home._sharedHomeList.addAll(this._sharedHomeList);
        home._host = this._host.getShallowCopy();
        home._remoteExecEnvVars = this._remoteExecEnvVars != null ? new LinkedHashMap<String, String>(this._remoteExecEnvVars) : null;
        home._owner = this._owner;
        home._version = this._version;
        home._gimr = this._gimr;
        return home;
    }

    public String toString() {
        String s = this.getLocation() + " " + this.getProductTypes();
        if (this._instances != null && !this._instances.isEmpty()) {
            s = s + " Instances: " + this._instances;
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HomeImpl)) {
            return false;
        }
        HomeImpl home = (HomeImpl)o;
        if (this._host != null ? !this._host.equals(home._host) : home._host != null) {
            return false;
        }
        return !(this._location != null ? !this._location.equals(home._location) : home._location != null);
    }

    public int hashCode() {
        int result = this._location != null ? this._location.hashCode() : 0;
        result = 31 * result + (this._host != null ? this._host.hashCode() : 0);
        return result;
    }
}

