/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.awt.image.RescaleOp;
import java.awt.image.ShortLookupTable;
import sun.java2d.SurfaceData;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

public class BufferedBufImgOps {
    public static void enableBufImgOp(RenderQueue renderQueue, SurfaceData surfaceData, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp) {
        if (bufferedImageOp instanceof ConvolveOp) {
            BufferedBufImgOps.enableConvolveOp(renderQueue, surfaceData, (ConvolveOp)bufferedImageOp);
        } else if (bufferedImageOp instanceof RescaleOp) {
            BufferedBufImgOps.enableRescaleOp(renderQueue, surfaceData, bufferedImage, (RescaleOp)bufferedImageOp);
        } else if (bufferedImageOp instanceof LookupOp) {
            BufferedBufImgOps.enableLookupOp(renderQueue, surfaceData, bufferedImage, (LookupOp)bufferedImageOp);
        } else {
            throw new InternalError("Unknown BufferedImageOp");
        }
    }

    public static void disableBufImgOp(RenderQueue renderQueue, BufferedImageOp bufferedImageOp) {
        if (bufferedImageOp instanceof ConvolveOp) {
            BufferedBufImgOps.disableConvolveOp(renderQueue);
        } else if (bufferedImageOp instanceof RescaleOp) {
            BufferedBufImgOps.disableRescaleOp(renderQueue);
        } else if (bufferedImageOp instanceof LookupOp) {
            BufferedBufImgOps.disableLookupOp(renderQueue);
        } else {
            throw new InternalError("Unknown BufferedImageOp");
        }
    }

    public static boolean isConvolveOpValid(ConvolveOp convolveOp) {
        Kernel kernel = convolveOp.getKernel();
        int n = kernel.getWidth();
        int n2 = kernel.getHeight();
        return n == 3 && n2 == 3 || n == 5 && n2 == 5;
    }

    private static void enableConvolveOp(RenderQueue renderQueue, SurfaceData surfaceData, ConvolveOp convolveOp) {
        boolean bl = convolveOp.getEdgeCondition() == 0;
        Kernel kernel = convolveOp.getKernel();
        int n = kernel.getWidth();
        int n2 = kernel.getHeight();
        int n3 = n * n2;
        int n4 = 4;
        int n5 = 24 + n3 * n4;
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderQueue.ensureCapacityAndAlignment(n5, 4);
        renderBuffer.putInt(120);
        renderBuffer.putLong(surfaceData.getNativeOps());
        renderBuffer.putInt(bl ? 1 : 0);
        renderBuffer.putInt(n);
        renderBuffer.putInt(n2);
        renderBuffer.put(kernel.getKernelData(null));
    }

    private static void disableConvolveOp(RenderQueue renderQueue) {
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderQueue.ensureCapacity(4);
        renderBuffer.putInt(121);
    }

    public static boolean isRescaleOpValid(RescaleOp rescaleOp, BufferedImage bufferedImage) {
        int n = rescaleOp.getNumFactors();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            throw new IllegalArgumentException("Rescaling cannot be performed on an indexed image");
        }
        if (n != 1 && n != colorModel.getNumColorComponents() && n != colorModel.getNumComponents()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of color or color/alpha  components");
        }
        int n2 = colorModel.getColorSpace().getType();
        if (n2 != 5 && n2 != 6) {
            return false;
        }
        return n != 2 && n <= 4;
    }

    private static void enableRescaleOp(RenderQueue renderQueue, SurfaceData surfaceData, BufferedImage bufferedImage, RescaleOp rescaleOp) {
        int n;
        int n2;
        int n3;
        float[] fArray;
        float[] fArray2;
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.hasAlpha() && colorModel.isAlphaPremultiplied();
        int n4 = rescaleOp.getNumFactors();
        float[] fArray3 = rescaleOp.getScaleFactors(null);
        float[] fArray4 = rescaleOp.getOffsets(null);
        if (n4 == 1) {
            fArray2 = new float[4];
            fArray = new float[4];
            for (n3 = 0; n3 < 3; ++n3) {
                fArray2[n3] = fArray3[0];
                fArray[n3] = fArray4[0];
            }
            fArray2[3] = 1.0f;
            fArray[3] = 0.0f;
        } else if (n4 == 3) {
            fArray2 = new float[4];
            fArray = new float[4];
            for (n3 = 0; n3 < 3; ++n3) {
                fArray2[n3] = fArray3[n3];
                fArray[n3] = fArray4[n3];
            }
            fArray2[3] = 1.0f;
            fArray[3] = 0.0f;
        } else {
            fArray2 = fArray3;
            fArray = fArray4;
        }
        if (colorModel.getNumComponents() == 1) {
            n3 = colorModel.getComponentSize(0);
            n2 = (1 << n3) - 1;
            n = 0;
            while (n < 3) {
                int n5 = n++;
                fArray[n5] = fArray[n5] / (float)n2;
            }
        } else {
            n3 = 0;
            while (n3 < colorModel.getNumComponents()) {
                n2 = colorModel.getComponentSize(n3);
                n = (1 << n2) - 1;
                int n6 = n3++;
                fArray[n6] = fArray[n6] / (float)n;
            }
        }
        n3 = 4;
        n2 = 16 + 4 * n3 * 2;
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderQueue.ensureCapacityAndAlignment(n2, 4);
        renderBuffer.putInt(122);
        renderBuffer.putLong(surfaceData.getNativeOps());
        renderBuffer.putInt(bl ? 1 : 0);
        renderBuffer.put(fArray2);
        renderBuffer.put(fArray);
    }

    private static void disableRescaleOp(RenderQueue renderQueue) {
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderQueue.ensureCapacity(4);
        renderBuffer.putInt(123);
    }

    public static boolean isLookupOpValid(LookupOp lookupOp, BufferedImage bufferedImage) {
        LookupTable lookupTable = lookupOp.getTable();
        int n = lookupTable.getNumComponents();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            throw new IllegalArgumentException("LookupOp cannot be performed on an indexed image");
        }
        if (n != 1 && n != colorModel.getNumComponents() && n != colorModel.getNumColorComponents()) {
            throw new IllegalArgumentException("Number of arrays in the  lookup table (" + n + ") is not compatible with the src image: " + bufferedImage);
        }
        int n2 = colorModel.getColorSpace().getType();
        if (n2 != 5 && n2 != 6) {
            return false;
        }
        if (n == 2 || n > 4) {
            return false;
        }
        if (lookupTable instanceof ByteLookupTable) {
            byte[][] byArray = ((ByteLookupTable)lookupTable).getTable();
            for (int i = 1; i < byArray.length; ++i) {
                if (byArray[i].length <= 256 && byArray[i].length == byArray[i - 1].length) continue;
                return false;
            }
        } else if (lookupTable instanceof ShortLookupTable) {
            short[][] sArray = ((ShortLookupTable)lookupTable).getTable();
            for (int i = 1; i < sArray.length; ++i) {
                if (sArray[i].length <= 256 && sArray[i].length == sArray[i - 1].length) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void enableLookupOp(RenderQueue renderQueue, SurfaceData surfaceData, BufferedImage bufferedImage, LookupOp lookupOp) {
        boolean bl;
        int n;
        int n2;
        Object object;
        boolean bl2 = bufferedImage.getColorModel().hasAlpha() && bufferedImage.isAlphaPremultiplied();
        LookupTable lookupTable = lookupOp.getTable();
        int n3 = lookupTable.getNumComponents();
        int n4 = lookupTable.getOffset();
        if (lookupTable instanceof ShortLookupTable) {
            object = ((ShortLookupTable)lookupTable).getTable();
            n2 = object[0].length;
            n = 2;
            bl = true;
        } else {
            object = ((ByteLookupTable)lookupTable).getTable();
            n2 = object[0].length;
            n = 1;
            bl = false;
        }
        int n5 = n3 * n2 * n;
        int n6 = n5 + 3 & 0xFFFFFFFC;
        int n7 = n6 - n5;
        int n8 = 32 + n6;
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderQueue.ensureCapacityAndAlignment(n8, 4);
        renderBuffer.putInt(124);
        renderBuffer.putLong(surfaceData.getNativeOps());
        renderBuffer.putInt(bl2 ? 1 : 0);
        renderBuffer.putInt(bl ? 1 : 0);
        renderBuffer.putInt(n3);
        renderBuffer.putInt(n2);
        renderBuffer.putInt(n4);
        if (bl) {
            short[][] sArray = ((ShortLookupTable)lookupTable).getTable();
            for (int i = 0; i < n3; ++i) {
                renderBuffer.put(sArray[i]);
            }
        } else {
            byte[][] byArray = ((ByteLookupTable)lookupTable).getTable();
            for (int i = 0; i < n3; ++i) {
                renderBuffer.put(byArray[i]);
            }
        }
        if (n7 != 0) {
            renderBuffer.position(renderBuffer.position() + n7);
        }
    }

    private static void disableLookupOp(RenderQueue renderQueue) {
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        renderQueue.ensureCapacity(4);
        renderBuffer.putInt(125);
    }
}

