/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.PrereqSession;
import oracle.opatch.ROSessionException;
import oracle.opatch.RWSessionException;
import oracle.opatch.Rac;
import oracle.opatch.RacImpl;
import oracle.opatch.RacSrvm;
import oracle.opatch.RacSrvmImpl;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.RacPrereqAPI;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;

public class RacPrereqAPIImpl
extends RacPrereqAPI {
    private RacSrvm racSrvm = new RacSrvmImpl();
    private Rac rac = new RacImpl();

    public PrereqResult checkForCRSHomeIfRAC(String oracleHomePath) {
        PrereqResult resObj;
        block11: {
            resObj = new PrereqResult();
            StringBuffer buff = new StringBuffer("RacPrereqAPI::checkForCRSHomeIfRAC()");
            OLogger.debug((StringBuffer)buff);
            try {
                buff = new StringBuffer("Setting up an OUI Session.");
                OLogger.debug((StringBuffer)buff);
                IIPMReadServices readServices = PrereqSession.getReadServices((String)oracleHomePath);
                Rac.RacType racType = null;
                try {
                    racType = this.rac.getInstance(readServices);
                }
                catch (RuntimeException e) {
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail((Object)e);
                    buff = new StringBuffer("Exception occured");
                    OLogger.printStackTrace((Throwable)e);
                    buff.append(e.getMessage());
                    OLogger.printlnOnLog((String)buff.toString());
                    return resObj;
                }
                buff = new StringBuffer(racType.getDetail());
                OLogger.debug((StringBuffer)buff);
                String toString = this.rac.toString(readServices);
                buff = new StringBuffer(toString);
                OLogger.printlnOnLog((String)buff.toString());
                if (racType != Rac.RacType.NO_RAC) {
                    if (readServices.isCRSHomePresent()) {
                        String crsHomeName = readServices.findCRSHomeName();
                        buff = new StringBuffer("CRS Home: ");
                        buff.append(crsHomeName);
                        OLogger.printlnOnLog((String)buff.toString());
                        buff = new StringBuffer("\nFound a CRS Home : ");
                        buff.append(crsHomeName);
                        OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
                        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    } else {
                        buff = new StringBuffer("\nNo CRS Home is registered with the given Central Inventory");
                        buff.append("\n Use -local_node <nodename> while invoking OPatch to specify which node to be taken as Local node.");
                        OLogger.printlnOnLog((String)buff.toString());
                        OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
                        resObj.addDetail((Object)buff.toString());
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    }
                    break block11;
                }
                if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
                    buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
                    buff.append("This could be because of one or more of the following:\n");
                    buff.append("   a) Problems with the clusterware detection.\n");
                    buff.append("   b) Problems getting the local node name.\n");
                    buff.append("   c) Problems getting the remote node names.\n");
                    buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
                    buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail((Object)buff.toString());
                    return resObj;
                }
                buff = new StringBuffer("Not a RAC setup.");
                OLogger.println((String)buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                return resObj;
            }
            catch (ROSessionException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("ROSessionException occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
            }
            catch (RWSessionException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("RWSessionException occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
            }
            catch (RuntimeException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("Exception occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)t);
                buff = new StringBuffer("Exception occured");
                OLogger.printStackTrace((Throwable)t);
                buff.append(t.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
        }
        return resObj;
    }

    public PrereqResult checkRACNodeList(String oracleHomePath) {
        StringBuffer buff;
        PrereqResult resObj;
        block29: {
            resObj = new PrereqResult();
            buff = new StringBuffer("RacPrereqAPI::checkRACNodeList()");
            OLogger.debug((StringBuffer)buff);
            try {
                buff = new StringBuffer("Setting up an OUI Session.");
                OLogger.debug((StringBuffer)buff);
                IIPMReadServices readServices = PrereqSession.getReadServices((String)oracleHomePath);
                Rac.RacType racType = null;
                try {
                    racType = this.rac.getInstance(readServices);
                }
                catch (RuntimeException e) {
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail((Object)e);
                    buff = new StringBuffer("Exception occured");
                    OLogger.printStackTrace((Throwable)e);
                    buff.append(e.getMessage());
                    OLogger.printlnOnLog((String)buff.toString());
                    return resObj;
                }
                buff = new StringBuffer(racType.getDetail());
                OLogger.debug((StringBuffer)buff);
                String toString = this.rac.toString(readServices);
                buff = new StringBuffer(toString);
                OLogger.printlnOnLog((String)buff.toString());
                if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
                    buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
                    buff.append("This could be because of one or more of the following:\n");
                    buff.append("   a) Problems with the clusterware detection.\n");
                    buff.append("   b) Problems getting the local node name.\n");
                    buff.append("   c) Problems getting the remote node names.\n");
                    buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
                    buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail((Object)buff.toString());
                    return resObj;
                }
                if (racType == Rac.RacType.MULTIPLE_NODE) {
                    String localNode = racType.getLocalNode();
                    String[] nodes = racType.getRemoteNodes();
                    buff = new StringBuffer("\nLocal Node : " + localNode);
                    if (nodes != null) {
                        buff.append("\nRemote Nodes : ");
                        for (int i = 0; i < nodes.length; ++i) {
                            buff.append(nodes[i]);
                            buff.append("   ");
                        }
                    }
                    OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
                    if (nodes != null && nodes.length > 0) {
                        ArrayList<String> aliveNodes = new ArrayList<String>();
                        int timeout = 100;
                        try {
                            new ClusterCmd().areNodesAlive(nodes, timeout, null);
                        }
                        catch (ClusterException e) {
                            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                            resObj.addDetail((Object)e);
                            buff = new StringBuffer("Exception occured");
                            OLogger.printStackTrace((Throwable)e);
                            buff.append(e.getMessage());
                            OLogger.printlnOnLog((String)buff.toString());
                            return resObj;
                        }
                        catch (RemoteFileOperationException e) {
                            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                            for (int i = 0; i < nodes.length; ++i) {
                                try {
                                    switch (e.getStatus(nodes[i])) {
                                        case 0: {
                                            aliveNodes.add(nodes[i]);
                                            break;
                                        }
                                        case 1: {
                                            resObj.addDetail((Object)("Not Alive : " + nodes[i]));
                                            break;
                                        }
                                        case 2: {
                                            resObj.addDetail((Object)("Not Alive : " + nodes[i]));
                                        }
                                    }
                                    continue;
                                }
                                catch (NoSuchNodeException nsne) {
                                    resObj.addDetail((Object)("Node does not exist : " + nodes[i]));
                                }
                            }
                        }
                        if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                            buff = new StringBuffer("Alive Remote Nodes are: ");
                            for (int nodeIter = 0; nodeIter < aliveNodes.size(); ++nodeIter) {
                                buff.append(aliveNodes.get(nodeIter));
                                if (nodeIter + 1 == aliveNodes.size()) continue;
                                buff.append(",");
                            }
                            OLogger.printlnOnLog((String)buff.toString());
                            resObj.addDetail((Object)buff.toString());
                        } else {
                            buff = new StringBuffer("Alive Remote Nodes are: ");
                            for (int nodeIter = 0; nodeIter < nodes.length; ++nodeIter) {
                                buff.append(nodes[nodeIter]);
                                if (nodeIter + 1 == nodes.length) continue;
                                buff.append(",");
                            }
                            OLogger.printlnOnLog((String)buff.toString());
                            resObj.addDetail((Object)buff.toString());
                        }
                        break block29;
                    }
                    buff = new StringBuffer("\nThere is no remote node.");
                    OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    return resObj;
                }
                if (racType == Rac.RacType.NO_RAC) {
                    OLogger.println((String)"Not a RAC setup.");
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    return resObj;
                }
            }
            catch (ROSessionException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("ROSessionException occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            catch (RWSessionException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("RWSessionException occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            catch (RuntimeException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("Exception occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)t);
                buff = new StringBuffer("Exception occured");
                OLogger.printStackTrace((Throwable)t);
                buff.append(t.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll nodes are alive and reachable");
            OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrereqResult checkRemoteCommandInvocable(String oracleHomePath) {
        StringBuffer buff;
        PrereqResult resObj;
        block19: {
            resObj = new PrereqResult();
            buff = new StringBuffer("RacPrereqAPI::checkRemoteCommandInvocable()");
            OLogger.debug((StringBuffer)buff);
            try {
                String remoteCmd;
                String[] nodes;
                block18: {
                    buff = new StringBuffer("\nSetting up an OUI Session.");
                    OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
                    IIPMReadServices readServices = PrereqSession.getReadServices((String)oracleHomePath);
                    Rac.RacType racType = null;
                    try {
                        racType = this.rac.getInstance(readServices);
                    }
                    catch (RuntimeException e) {
                        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                        resObj.addDetail((Object)e);
                        buff = new StringBuffer("Exception occured");
                        OLogger.printStackTrace((Throwable)e);
                        buff.append(e.getMessage());
                        OLogger.printlnOnLog((String)buff.toString());
                        return resObj;
                    }
                    buff = new StringBuffer(racType.getDetail());
                    OLogger.debug((StringBuffer)buff);
                    String toString = this.rac.toString(readServices);
                    buff = new StringBuffer(toString);
                    OLogger.printlnOnLog((String)buff.toString());
                    if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
                        buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
                        buff.append("This could be because of one or more of the following:\n");
                        buff.append("   a) Problems with the clusterware detection.\n");
                        buff.append("   b) Problems getting the local node name.\n");
                        buff.append("   c) Problems getting the remote node names.\n");
                        buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
                        buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
                        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                        resObj.addDetail((Object)buff.toString());
                        return resObj;
                    }
                    if (racType == Rac.RacType.MULTIPLE_NODE) {
                        String localNode = racType.getLocalNode();
                        nodes = racType.getRemoteNodes();
                        buff = new StringBuffer("\nLocal Node : " + localNode);
                        if (nodes != null) {
                            buff.append("\nRemote Nodes : ");
                            for (int i = 0; i < nodes.length; ++i) {
                                buff.append(nodes[i]);
                                buff.append("   ");
                            }
                        }
                        OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
                        if (nodes != null && nodes.length > 0) {
                            remoteCmd = "date";
                            break block18;
                        } else {
                            buff = new StringBuffer("\nThere is no remote Node.");
                            OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
                            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                            return resObj;
                        }
                    }
                    if (racType == Rac.RacType.NO_RAC) {
                        OLogger.println((String)"Not a RAC setup.");
                        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                        return resObj;
                    }
                    break block19;
                }
                for (int nodeIter = 0; nodeIter < nodes.length; ++nodeIter) {
                    try {
                        this.rac.srvmRunRemoteCommand(nodes[nodeIter], remoteCmd);
                        continue;
                    }
                    catch (RuntimeException e) {
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        resObj.addDetail((Object)e.getMessage());
                        buff = new StringBuffer("Exception occured");
                        buff.append(e.getMessage());
                        OLogger.printlnOnLog((String)buff.toString());
                    }
                }
            }
            catch (ROSessionException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("ROSessionException occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            catch (RWSessionException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("RWSessionException occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            catch (RuntimeException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("Exception occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)t);
                buff = new StringBuffer("Exception occured");
                OLogger.printStackTrace((Throwable)t);
                buff.append(t.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\n\"date\" command was executed successfully on all the remote nodes.");
            OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public PrereqResult checkRemoteCopyAndRemove(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("RacPrereqAPI::checkRemoteCopyAndRemove()");
        OLogger.debug((StringBuffer)buff);
        Rac.RacType racType = null;
        try {
            buff = new StringBuffer("\nSetting up an OUI Session.");
            OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
            IIPMReadServices readServices = PrereqSession.getReadServices((String)oracleHomePath);
            try {
                racType = this.rac.getInstance(readServices);
            }
            catch (RuntimeException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("Exception occured");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            buff = new StringBuffer(racType.getDetail());
            OLogger.debug((StringBuffer)buff);
            String toString = this.rac.toString(readServices);
            buff = new StringBuffer(toString);
            OLogger.printlnOnLog((String)buff.toString());
        }
        catch (ROSessionException e) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail((Object)e);
            buff = new StringBuffer("ROSessionException occured");
            OLogger.printStackTrace((Throwable)e);
            buff.append(e.getMessage());
            OLogger.printlnOnLog((String)buff.toString());
            return resObj;
        }
        catch (RWSessionException e) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail((Object)e);
            buff = new StringBuffer("RWSessionException occured");
            OLogger.printStackTrace((Throwable)e);
            buff.append(e.getMessage());
            OLogger.printlnOnLog((String)buff.toString());
            return resObj;
        }
        catch (RuntimeException e) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail((Object)e);
            buff = new StringBuffer("Exception occured");
            OLogger.printStackTrace((Throwable)e);
            buff.append(e.getMessage());
            OLogger.printlnOnLog((String)buff.toString());
            return resObj;
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail((Object)t);
            buff = new StringBuffer("Exception occured");
            OLogger.printStackTrace((Throwable)t);
            buff.append(t.getMessage());
            OLogger.printlnOnLog((String)buff.toString());
            return resObj;
        }
        if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
            buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
            buff.append("This could be because of one or more of the following:\n");
            buff.append("   a) Problems with the clusterware detection.\n");
            buff.append("   b) Problems getting the local node name.\n");
            buff.append("   c) Problems getting the remote node names.\n");
            buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
            buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail((Object)buff.toString());
            return resObj;
        }
        if (racType == Rac.RacType.MULTIPLE_NODE) {
            String[] nodes = racType.getRemoteNodes();
            String ohPatchStorage = OPatchEnv.getPatchStorageDirectoryPath((String)oracleHomePath);
            File f = new File(ohPatchStorage);
            if (!f.exists() && !f.mkdirs()) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff = new StringBuffer("Unable to create");
                buff.append(ohPatchStorage);
                OLogger.printlnOnLog((String)buff.toString());
                resObj.addDetail((Object)buff.toString());
                return resObj;
            }
            String listingFile = ohPatchStorage + File.separator + "prereq_files_propogation_list.txt";
            String finalCopyFile = ohPatchStorage + File.separator + "prereq_copy_instantiated.txt";
            String finalRemoveFile = ohPatchStorage + File.separator + "prereq_remove_instantiated.txt";
            try {
                if (!this.createAndPopulateListingFile(oracleHomePath, ohPatchStorage, listingFile)) {
                    buff = new StringBuffer("Files were not created to do remote copy/remove.");
                    OLogger.printlnOnLog((String)buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail((Object)buff.toString());
                    return resObj;
                }
            }
            catch (IOException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("Creation of listing and actual files failed");
                buff.append("Exception occured: ");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            try {
                this.racSrvm.propagateListedFilesToNodes(oracleHomePath, nodes, listingFile, finalCopyFile);
            }
            catch (RuntimeException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("File propogation failed.");
                buff.append("Exception occured: ");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            buff = new StringBuffer("\nFile has been propogated successfully");
            OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
            try {
                this.racSrvm.removeListedFilesOnNodes(oracleHomePath, nodes, listingFile, finalRemoveFile);
            }
            catch (RuntimeException e) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail((Object)e);
                buff = new StringBuffer("Remote file delete failed.");
                buff.append("Exception occured: ");
                OLogger.printStackTrace((Throwable)e);
                buff.append(e.getMessage());
                OLogger.printlnOnLog((String)buff.toString());
                return resObj;
            }
            buff = new StringBuffer("\nFile has been removed successfully on remote nodes.");
            OLogger.verbose((Object)OPatchSession.PREREQ, (StringBuffer)buff);
        } else if (racType == Rac.RacType.NO_RAC) {
            OLogger.println((String)"Not a RAC setup.");
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        OLogger.debug((StringBuffer)new StringBuffer("Prereq checkRemoteCopyAndRemove Passed."));
        return resObj;
    }

    private boolean createAndPopulateListingFile(String oracleHomePath, String ohPatchStorage, String listingFile) throws IOException {
        String actualFileToPropogate = ohPatchStorage + File.separator + "prereq_testing.txt";
        File f = new File(actualFileToPropogate);
        if (f.exists()) {
            f.delete();
        }
        if (!f.createNewFile()) {
            return false;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        StringBuffer buff = new StringBuffer("This is a temporary file, created as \n");
        buff.append("a part of prereq checks, to check file propogation\n");
        buff.append("to remote nodes.\n");
        bw.write(buff.toString(), 0, buff.length());
        bw.close();
        File fl = new File(listingFile);
        if (fl.exists()) {
            fl.delete();
        }
        if (!fl.createNewFile()) {
            return false;
        }
        BufferedWriter bw2 = new BufferedWriter(new FileWriter(fl));
        String fileToPropogate = oracleHomePath + File.separator + OPatchEnv.getPatchStorageName() + File.separator + "prereq_testing.txt";
        bw2.write(fileToPropogate, 0, fileToPropogate.length());
        bw2.close();
        return true;
    }
}

