/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.api;

import java.util.Collection;

public enum Result {
    NOT_EVALUATED(1),
    VERSION_MISMATCH(2),
    ERR_NOT_FOUND(3),
    PROCESS_COMPONENT(4),
    PROCESSING_NOT_REQUIRED(5),
    IGNORE_NOT_FOUND(6),
    METADATA_ERROR(7);

    int _precedence;

    private Result(int precedence) {
        this._precedence = precedence;
    }

    public int getPrecedence() {
        return this._precedence;
    }

    public boolean isNotEvaluated() {
        return this == NOT_EVALUATED;
    }

    public boolean isProcessComponent() {
        return this == PROCESS_COMPONENT;
    }

    public boolean isProcessingNotRequired() {
        return this == PROCESSING_NOT_REQUIRED;
    }

    public boolean isIgnoreNotFound() {
        return this == IGNORE_NOT_FOUND;
    }

    public boolean isErrNotFound() {
        return this == ERR_NOT_FOUND;
    }

    public boolean isVersionMismatch() {
        return this == VERSION_MISMATCH;
    }

    public boolean isMetaDataError() {
        return this == METADATA_ERROR;
    }

    public boolean isHigherPrecedence(Result otherResult) {
        return otherResult != null && this != otherResult && this.getPrecedence() > otherResult.getPrecedence();
    }

    public static Result getHighLevelResult(Collection<Result> results) {
        Result highLevelResult = NOT_EVALUATED;
        if (results != null) {
            for (Result result : results) {
                if (highLevelResult == result || !result.isHigherPrecedence(highLevelResult)) continue;
                highLevelResult = result;
            }
        }
        return highLevelResult;
    }
}

