/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.wallet.commandline;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.wallet.commandline.CommandLineHolder;
import com.oracle.glcm.patch.wallet.commandline.ConfigurationOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CommandLineParser {
    public CommandLineHolder parseCommandLineArg(String[] args, List<ConfigurationOption> supportedOptions) {
        LinkedHashMap<String, String> invalidOptions = new LinkedHashMap<String, String>();
        HashMap<String, ConfigurationOption> optionMap = new HashMap<String, ConfigurationOption>(supportedOptions.size(), 1.0f);
        for (ConfigurationOption configurationOption : supportedOptions) {
            optionMap.put(configurationOption.getName(), configurationOption);
        }
        HashMap<ConfigurationOption.ValueType, Map<String, List<String>>> parsedOptions = new HashMap<ConfigurationOption.ValueType, Map<String, List<String>>>();
        for (ConfigurationOption.ValueType valueType : ConfigurationOption.ValueType.values()) {
            parsedOptions.put(valueType, new LinkedHashMap());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> unattachedValues = new ArrayList<String>();
        ArrayList<String> warningMessages = new ArrayList<String>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (args != null) {
            ConfigurationOption currOption = null;
            for (String arg : args) {
                String value;
                String key;
                if (arg.startsWith("-") || arg.contains("=")) {
                    if (currOption != null) {
                        switch (currOption.getValueType()) {
                            case MULTI_VALUE: {
                                Map multiValueMap = (Map)parsedOptions.get((Object)ConfigurationOption.ValueType.MULTI_VALUE);
                                if (multiValueMap.containsKey(currOption.getName())) break;
                                multiValueMap.put(currOption.getName(), Collections.emptyList());
                                warningMessages.add(CommandLineParser.getI18nString("WalletTool.conf.warning.no.option.value", currOption.getName()));
                                break;
                            }
                            case SINGLE: {
                                ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.SINGLE)).put(currOption.getName(), Collections.emptyList());
                                warningMessages.add(CommandLineParser.getI18nString("WalletTool.conf.warning.no.option.value", currOption.getName()));
                                break;
                            }
                        }
                        currOption = null;
                    }
                    if (!arrayList.isEmpty()) {
                        unattachedValues.addAll(arrayList);
                        arrayList.clear();
                    }
                }
                int eqIdx = arg.indexOf(61);
                if (arg.startsWith("-")) {
                    if (eqIdx >= 0) {
                        key = arg.substring(1, eqIdx);
                        value = arg.substring(eqIdx + 1);
                        if (optionMap.containsKey(key)) {
                            ConfigurationOption option = (ConfigurationOption)optionMap.get(key);
                            if (!this.isValueSupported((ConfigurationOption)optionMap.get(key), value)) {
                                errorMessages.add(CommandLineParser.getI18nString("WalletTool.conf.errors.invalid.option", key, value));
                            }
                            ArrayList<String> values = new ArrayList<String>(1);
                            values.add(value);
                            switch (option.getValueType()) {
                                case MULTI_VALUE: {
                                    ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.MULTI_VALUE)).put(key, values);
                                    warningMessages.add(CommandLineParser.getI18nString("WalletTool.conf.warning.equal.sign.multivalue.option", key));
                                    break;
                                }
                                case SINGLE: {
                                    ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.SINGLE)).put(key, values);
                                    break;
                                }
                                case NO_VALUE: {
                                    ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.NO_VALUE)).put(key, values);
                                }
                            }
                            continue;
                        }
                        invalidOptions.put(key, arg.substring(eqIdx + 1));
                        continue;
                    }
                    key = arg.substring(1, arg.length());
                    if (optionMap.containsKey(key)) {
                        if (((ConfigurationOption)optionMap.get(key)).getValueType() == ConfigurationOption.ValueType.NO_VALUE) {
                            ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.NO_VALUE)).put(key, null);
                            continue;
                        }
                        currOption = (ConfigurationOption)optionMap.get(key);
                        continue;
                    }
                    invalidOptions.put(key, null);
                    continue;
                }
                if (eqIdx >= 0) {
                    key = arg.substring(0, eqIdx);
                    value = arg.substring(eqIdx + 1);
                    if (optionMap.containsKey(key)) {
                        if (!this.isValueSupported((ConfigurationOption)optionMap.get(key), value)) {
                            errorMessages.add(CommandLineParser.getI18nString("WalletTool.conf.errors.invalid.option", key, value));
                        }
                        ArrayList<String> values = new ArrayList<String>(1);
                        values.add(value);
                        switch (((ConfigurationOption)optionMap.get(key)).getValueType()) {
                            case MULTI_VALUE: {
                                ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.MULTI_VALUE)).put(key, values);
                                warningMessages.add(CommandLineParser.getI18nString("WalletTool.warning.conf.equal.sign.multivalue.option", key));
                                break;
                            }
                            case SINGLE: {
                                ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.SINGLE)).put(key, values);
                                break;
                            }
                            case NO_VALUE: {
                                invalidOptions.put(key, arg.substring(eqIdx + 1));
                            }
                        }
                        continue;
                    }
                    invalidOptions.put(key, value);
                    continue;
                }
                if (currOption != null) {
                    if (!this.isValueSupported(currOption, arg)) {
                        errorMessages.add(CommandLineParser.getI18nString("WalletTool.conf.errors.invalid.option", currOption.getName(), arg));
                    }
                    switch (currOption.getValueType()) {
                        case MULTI_VALUE: {
                            ArrayList<String> values;
                            Map multiValueMap = (Map)parsedOptions.get((Object)ConfigurationOption.ValueType.MULTI_VALUE);
                            if (!multiValueMap.containsKey(currOption.getName())) {
                                values = new ArrayList(5);
                                values.add(arg);
                                multiValueMap.put(currOption.getName(), values);
                                break;
                            }
                            ((List)multiValueMap.get(currOption.getName())).add(arg);
                            break;
                        }
                        case SINGLE: {
                            ArrayList<String> values = new ArrayList<String>(5);
                            values.add(arg);
                            ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.SINGLE)).put(currOption.getName(), values);
                            currOption = null;
                        }
                    }
                    continue;
                }
                unattachedValues.add(arg);
            }
            if (currOption != null) {
                switch (currOption.getValueType()) {
                    case MULTI_VALUE: {
                        Map multiValueMap = (Map)parsedOptions.get((Object)ConfigurationOption.ValueType.MULTI_VALUE);
                        if (multiValueMap.containsKey(currOption.getName())) break;
                        multiValueMap.put(currOption.getName(), Collections.emptyList());
                        warningMessages.add(CommandLineParser.getI18nString("WalletTool.conf.warning.no.option.value", currOption.getName()));
                        break;
                    }
                    case SINGLE: {
                        warningMessages.add(CommandLineParser.getI18nString("WalletTool.conf.warning.no.option.value", currOption.getName()));
                        ((Map)parsedOptions.get((Object)ConfigurationOption.ValueType.SINGLE)).put(currOption.getName(), Collections.emptyList());
                    }
                }
            }
        }
        return new CommandLineHolder(parsedOptions, invalidOptions, arrayList, unattachedValues, warningMessages, errorMessages);
    }

    public CommandLineHolder parseCommandLineArgs(String[] args) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> unattachedValues = new ArrayList<String>();
        if (args != null) {
            String currOption = null;
            for (String arg : args) {
                if (arg == null) continue;
                if (arg.startsWith("-") || arg.contains("=")) {
                    if (currOption != null) {
                        options.put(currOption, null);
                        currOption = null;
                    }
                    if (!arguments.isEmpty()) {
                        unattachedValues.addAll(arguments);
                        arguments.clear();
                    }
                }
                int eqIdx = arg.indexOf(61);
                if (arg.startsWith("-")) {
                    if (eqIdx >= 0) {
                        options.put(arg.substring(1, eqIdx), arg.substring(eqIdx + 1));
                        continue;
                    }
                    currOption = arg.substring(1, arg.length());
                    continue;
                }
                if (eqIdx >= 0) {
                    options.put(arg.substring(0, eqIdx), arg.substring(eqIdx + 1));
                    continue;
                }
                if (currOption != null) {
                    options.put(currOption, arg);
                    currOption = null;
                    continue;
                }
                arguments.add(arg);
            }
            if (currOption != null) {
                options.put(currOption, null);
            }
        }
        return new CommandLineHolder(options, arguments, unattachedValues);
    }

    private static String getI18nString(String key, Object ... params) {
        String value = ResourceBundleManager.getString((String)"operation", (String)key);
        return value == null ? key : MessageFormat.format(value, params);
    }

    private boolean isValueSupported(ConfigurationOption option, String valueToCheck) {
        if (option.getValueType() == ConfigurationOption.ValueType.NO_VALUE) {
            return StringUtil.isNullOrEmpty((String)valueToCheck);
        }
        String[] values = option.getAllowedValues();
        if (values == null || values.length <= 0) {
            return true;
        }
        for (String value : values) {
            if (!value.equals(valueToCheck)) continue;
            return true;
        }
        return false;
    }
}

