/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.progress;

import com.oracle.cie.wizard.ext.progress.Phase;
import com.oracle.cie.wizard.ext.progress.ProgressListener;
import com.oracle.cie.wizard.ext.progress.ProgressOperationException;
import com.oracle.cie.wizard.ext.progress.ProgressOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractProgressOperation
implements ProgressOperator {
    private List<ProgressListener> _listeners = new ArrayList<ProgressListener>(5);
    protected List<String> _warningMessages = new ArrayList<String>(5);
    protected volatile List<ProgressOperationException> _failureException = new ArrayList<ProgressOperationException>(5);
    protected boolean _done = false;
    protected boolean _success = false;

    @Override
    public List<String> getWarnings() {
        return Collections.unmodifiableList(this._warningMessages);
    }

    @Override
    public boolean isSuccess() {
        return this._success;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    @Override
    public void addProgressListener(ProgressListener l) {
        this._listeners.add(l);
    }

    @Override
    public List<ProgressListener> getProgressListeners() {
        return this._listeners;
    }

    @Override
    public boolean hasWarnings() {
        return !this._warningMessages.isEmpty();
    }

    @Override
    public boolean hasFailure() {
        return !this._failureException.isEmpty();
    }

    @Override
    public List<ProgressOperationException> getFailures() {
        return Collections.unmodifiableList(this._failureException);
    }

    protected void addWarningMessage(String warningMsg) {
        this._warningMessages.add(warningMsg);
    }

    public void notifyListeners(Phase phase, Phase.Status status) {
        for (ProgressListener pl : this.getProgressListeners()) {
            pl.updatePhaseStatus(phase, status);
        }
    }

    public void notifyListeners(int length) {
        for (ProgressListener pl : this.getProgressListeners()) {
            pl.updateTotalProgress(this, length);
        }
    }
}

