/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.roadmap.impl;

import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.event.WizardTaskActionEvent;
import com.oracle.cie.wizard.event.WizardWorkflowEvent;
import com.oracle.cie.wizard.event.WizardWorkflowListener;
import com.oracle.cie.wizard.gui.roadmap.RoadmapStep;
import com.oracle.cie.wizard.gui.roadmap.impl.RoadmapStepImpl;
import com.oracle.cie.wizard.wcf.TaskEntry;
import com.oracle.cie.wizard.wcf.UITaskEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;

class RoadmapListModelImpl
extends DefaultListModel
implements WizardWorkflowListener {
    private static final Logger _log = Logger.getLogger(RoadmapListModelImpl.class.getName());
    int currentSelectedIndex = 0;
    int startNavEnabledRange = 0;
    int endNavEnabledRange = 0;
    private boolean _errorState = false;
    private final ArrayList<UITaskEntry.StepCategory> reverseStepCategories = new ArrayList();
    private final ArrayList<UITaskEntry.StepCategory> forwardStepCategories = new ArrayList();
    private Direction _direction = Direction.BOTH;
    private List<WizardTaskActionEvent> eventList = null;
    private boolean _fwdNavigationForRdMapEnabled = true;

    public RoadmapListModelImpl(ControllerProxy proxy) {
        for (int i = 0; i < proxy.getWorkflowSize(); ++i) {
            TaskEntry task = proxy.getWorkflowEntryAt(i);
            if (!(task instanceof UITaskEntry)) continue;
            this.addElement(new RoadmapStepImpl(i, (UITaskEntry)task));
        }
        this.reverseStepCategories.add(UITaskEntry.StepCategory.MILESTONE);
        this.reverseStepCategories.add(UITaskEntry.StepCategory.FINAL);
        this.forwardStepCategories.add(UITaskEntry.StepCategory.MILESTONE);
        this.forwardStepCategories.add(UITaskEntry.StepCategory.FINAL);
        this.forwardStepCategories.add(UITaskEntry.StepCategory.SUMMARY);
    }

    public int getCurrentSelectedIndex() {
        return this.currentSelectedIndex;
    }

    public boolean isErrorState() {
        return this._errorState;
    }

    public void setErrorState(boolean isError) {
        this._errorState = isError;
        if (!this.isEmpty() && this.currentSelectedIndex != -1) {
            this.fireContentsChanged(this, this.getCurrentSelectedIndex(), this.getCurrentSelectedIndex());
        }
    }

    public int getStartNavEnabledRange() {
        return this.startNavEnabledRange;
    }

    public int getEndNavEnabledRange() {
        return this.endNavEnabledRange;
    }

    public Direction getDirectionOfNavigation() {
        return this._direction;
    }

    @Override
    public void entriesAdded(final WizardWorkflowEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.invokeEntriesAdded(e);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RoadmapListModelImpl.this.invokeEntriesAdded(e);
                }
            });
        }
    }

    @Override
    public void entriesRemoved(final WizardWorkflowEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.invokeEntriesRemoved(e);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RoadmapListModelImpl.this.invokeEntriesRemoved(e);
                }
            });
        }
    }

    public void taskActionPeformed(final WizardTaskActionEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.invokeTaskActionPeformed(event);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RoadmapListModelImpl.this.addEventsToRoadmapList(event);
                }
            });
        }
    }

    private int findUIStartIndex(WizardWorkflowEvent e) {
        int uiStartIdx = this.size();
        for (int i = 0; i < this.size(); ++i) {
            RoadmapStepImpl stepImplInstance = (RoadmapStepImpl)this.get(i);
            if (stepImplInstance.getCurrentIndex() < e.getStartIndex()) continue;
            uiStartIdx = i;
            break;
        }
        return uiStartIdx;
    }

    private void updateRoadmapSteps(WizardTaskActionEvent event) {
        if (!this.isEmpty()) {
            RoadmapStepImpl step = (RoadmapStepImpl)this.get(this.currentSelectedIndex);
            switch (event.getAction()) {
                case SKIPPED: {
                    if (!event.getTaskEntry().equals(step.getTaskEntry())) break;
                    step.setActive(false);
                    break;
                }
                case SCHEDULED: {
                    if (!event.getTaskEntry().equals(step.getTaskEntry())) break;
                    step.setActive(true);
                }
            }
            switch (event.getDirection()) {
                case FORWARD: {
                    if (this.currentSelectedIndex < 1) break;
                    step = (RoadmapStepImpl)this.get(this.currentSelectedIndex - 1);
                    step.setVisited(true);
                    this.setElementAt(step, this.currentSelectedIndex - 1);
                }
            }
            this.setNavigableRange();
            this.redrawRoadmap();
        }
    }

    private void invokeEntriesAdded(WizardWorkflowEvent e) {
        int i;
        int uiStartIdx = this.findUIStartIndex(e);
        int addedTotal = e.getTasks().size();
        for (int i2 = uiStartIdx; i2 < this.size(); ++i2) {
            RoadmapStepImpl stepImplInstance = (RoadmapStepImpl)this.get(i2);
            stepImplInstance.adjustIndex(addedTotal);
        }
        ArrayList<RoadmapStepImpl> stepsToAdd = new ArrayList<RoadmapStepImpl>();
        for (i = 0; i < addedTotal; ++i) {
            TaskEntry task = e.getTasks().get(i);
            if (!(task instanceof UITaskEntry)) continue;
            stepsToAdd.add(new RoadmapStepImpl(e.getStartIndex() + i, (UITaskEntry)task));
        }
        if (!stepsToAdd.isEmpty()) {
            for (i = 0; i < stepsToAdd.size(); ++i) {
                this.add(uiStartIdx + i, stepsToAdd.get(i));
            }
            this.setNavigableRange();
        }
    }

    private void invokeEntriesRemoved(WizardWorkflowEvent e) {
        RoadmapStep currentStep = (RoadmapStep)this.get(this.currentSelectedIndex);
        int uiStartIdx = this.findUIStartIndex(e);
        int removedTotal = e.getTasks().size();
        int endIndex = e.getStartIndex() + removedTotal - 1;
        ArrayList<RoadmapStepImpl> stepsToRemove = new ArrayList<RoadmapStepImpl>();
        for (int i = uiStartIdx; i < this.size(); ++i) {
            RoadmapStepImpl stepImplInstance = (RoadmapStepImpl)this.get(i);
            if (stepImplInstance.getCurrentIndex() <= endIndex) {
                stepsToRemove.add(stepImplInstance);
                continue;
            }
            stepImplInstance.adjustIndex(-removedTotal);
        }
        if (!stepsToRemove.isEmpty()) {
            for (RoadmapStepImpl step : stepsToRemove) {
                this.removeElement(step);
            }
            this.adjustCurrentIndex(currentStep);
            this.setNavigableRange();
        }
    }

    private void adjustCurrentIndex(RoadmapStep step) {
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != step) continue;
                this.currentSelectedIndex = i;
                break;
            }
        }
    }

    private void invokeTaskActionPeformed(WizardTaskActionEvent event) {
        switch (event.getDirection()) {
            case FORWARD: {
                RoadmapStepImpl step;
                if (this.currentSelectedIndex >= this.size() - 1 || (step = (RoadmapStepImpl)this.get(this.currentSelectedIndex + 1)).getTaskEntry() != event.getTaskEntry()) break;
                ++this.currentSelectedIndex;
                break;
            }
            case REVERSE: {
                RoadmapStepImpl step;
                if (this.currentSelectedIndex < 1 || (step = (RoadmapStepImpl)this.get(this.currentSelectedIndex - 1)).getTaskEntry() != event.getTaskEntry()) break;
                --this.currentSelectedIndex;
                this.setErrorState(false);
            }
        }
        this.updateRoadmapSteps(event);
    }

    private void setNavigableRange() {
        if (!this.isEmpty()) {
            int i = 0;
            RoadmapStepImpl step = null;
            if (this.currentSelectedIndex > 0 && this.currentSelectedIndex < this.size()) {
                this.startNavEnabledRange = i = this.currentSelectedIndex;
                i = this.currentSelectedIndex;
                step = (RoadmapStepImpl)this.get(i);
                while (i >= 0 && !step.getTaskEntry().isReverseDisallowed() && !this.reverseStepCategories.contains((Object)step.getTaskEntry().getCategory())) {
                    this.startNavEnabledRange = i;
                    step = (RoadmapStepImpl)this.get(i--);
                }
            }
            if (this.currentSelectedIndex < this.size() - 1) {
                if (!this._fwdNavigationForRdMapEnabled) {
                    this.endNavEnabledRange = this.currentSelectedIndex;
                    return;
                }
                UITaskEntry.StepCategory category = ((RoadmapStepImpl)this.get(this.currentSelectedIndex)).getTaskEntry().getCategory();
                if (UITaskEntry.StepCategory.SUMMARY.equals((Object)category) || UITaskEntry.StepCategory.FINAL.equals((Object)category)) {
                    this.endNavEnabledRange = this.currentSelectedIndex;
                    return;
                }
                this.endNavEnabledRange = i = this.currentSelectedIndex + 1;
                if (UITaskEntry.StepCategory.MILESTONE.equals((Object)((RoadmapStepImpl)this.get(i)).getTaskEntry().getCategory())) {
                    this.endNavEnabledRange = ++i;
                }
                step = (RoadmapStepImpl)this.get(i);
                while (i < this.getSize() - 1 && !this.forwardStepCategories.contains((Object)step.getTaskEntry().getCategory())) {
                    this.endNavEnabledRange = i++;
                    step = (RoadmapStepImpl)this.get(i);
                }
                if (UITaskEntry.StepCategory.SUMMARY.equals((Object)((RoadmapStepImpl)this.get(i)).getTaskEntry().getCategory())) {
                    this.endNavEnabledRange = i;
                }
            }
        }
    }

    public void enableForwardNavigation(boolean isEnabled) {
        if (isEnabled) {
            this._fwdNavigationForRdMapEnabled = true;
            this._direction = this._direction == Direction.NONE || this._direction == Direction.FORWARD ? Direction.FORWARD : Direction.BOTH;
        } else {
            this._fwdNavigationForRdMapEnabled = false;
            this._direction = this._direction == Direction.NONE || this._direction == Direction.FORWARD ? Direction.NONE : Direction.REVERSE;
        }
        this.redrawRoadmap();
    }

    public void enableReverseNavigation(boolean isEnabled) {
        this._direction = isEnabled ? (this._direction == Direction.NONE || this._direction == Direction.REVERSE ? Direction.REVERSE : Direction.BOTH) : (this._direction == Direction.NONE || this._direction == Direction.REVERSE ? Direction.NONE : Direction.FORWARD);
        this.redrawRoadmap();
    }

    private void redrawRoadmap() {
        this.setNavigableRange();
        this.fireContentsChanged(this, 0, this.size() - 1);
    }

    private void addEventsToRoadmapList(WizardTaskActionEvent event) {
        if (this.eventList == null) {
            this.eventList = new ArrayList<WizardTaskActionEvent>();
        }
        this.eventList.add(event);
        if (event.getAction() == WizardTaskActionEvent.Action.SCHEDULED) {
            for (WizardTaskActionEvent e : this.eventList) {
                this.invokeTaskActionPeformed(e);
            }
            this.eventList.clear();
        }
    }

    static enum Direction {
        NONE,
        FORWARD,
        REVERSE,
        BOTH;

    }
}

