/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ext.OperationSummary;
import com.oracle.cie.wizard.ext.OperationSummaryController;
import com.oracle.cie.wizard.ext.SummaryController;
import com.oracle.cie.wizard.ext.summary.SummaryPanelParser;
import com.oracle.cie.wizard.ext.summary.xml.ArgumentType;
import com.oracle.cie.wizard.ext.summary.xml.NodeType;
import com.oracle.cie.wizard.ext.summary.xml.SubItemType;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.components.SummaryTreeCellRenderer;
import com.oracle.cie.wizard.gui.components.SummaryTreeNode;
import com.oracle.cie.wizard.gui.tasks.AbstractGUITask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

@TaskDescription(name="summary_gui_task")
public class SummaryGUITask
extends AbstractGUITask {
    protected String _configFile;
    private String _operationSummaryClass;
    private String _summaryControllerClass;
    private NodeType _summaryTreeType;
    private String _finishButtonText;
    private String _finishButtonTooltip;
    private SummaryTreeCellRenderer _treeRenderer;
    protected OperationSummary _operationSummary;
    protected SummaryController _controller;
    protected JTree _tree;

    @TaskAttribute(required=true, type=TaskAttributeType.LITERAL)
    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.ext.OperationSummary"}, required=true)
    public void setOperationSummaryClass(String clazz) {
        this._operationSummaryClass = clazz;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY, required=false)
    public void setSummaryControllerClass(String clazz) {
        this._summaryControllerClass = clazz;
    }

    @TaskAttribute(required=false, type=TaskAttributeType.RESOURCE_KEY)
    public void setFinishButtonText(String finishButtonText) {
        this._finishButtonText = finishButtonText;
    }

    @TaskAttribute(required=false, type=TaskAttributeType.RESOURCE_KEY)
    public void setFinishButtonTooltip(String finishButtonTooltip) {
        this._finishButtonTooltip = finishButtonTooltip;
    }

    @Override
    public void configure(GUITaskContext context) throws TaskExecutionException {
        super.configure(context);
        try {
            this._operationSummaryClass = ((GUITaskContext)this._context).substitute(this._namespace, this._operationSummaryClass);
            this._summaryControllerClass = ((GUITaskContext)this._context).substitute(this._namespace, this._summaryControllerClass);
            ClassLoader classLoader = SummaryGUITask.class.getClassLoader();
            Class<?> loaderClass = classLoader.loadClass(this._operationSummaryClass);
            this._operationSummary = (OperationSummary)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this._operationSummary == null) {
                throw new TaskExecutionException(this, "Unable to initialze operation summary :: " + this._operationSummaryClass);
            }
            this._summaryTreeType = this.parseSchema();
            if (!StringUtil.isNullOrEmpty((String)this._summaryControllerClass)) {
                this._controller = (OperationSummaryController)classLoader.loadClass(this._summaryControllerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                this._logger.log(Level.FINEST, "No controller class (SummaryController) provided to controll summary panel.");
                this._controller = new OperationSummaryController();
            }
        }
        catch (TaskExecutionException e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new TaskExecutionException(this, ((GUITaskContext)this._context).getPublishedMessage(this._namespace, "64255", this._configFile, e.getMessage()).getFullMessage(), e);
        }
    }

    @Override
    public JComponent createUI() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this._tree = new JTree();
        this._tree.setOpaque(false);
        this._treeRenderer = new SummaryTreeCellRenderer();
        this._tree.setCellRenderer(this._treeRenderer);
        this._tree.setShowsRootHandles(true);
        this._tree.setRowHeight(0);
        this._tree.getSelectionModel().setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane(this._tree);
        this._tree.setBorder(BorderFactory.createEmptyBorder(16, 10, 16, 10));
        scrollPane.setWheelScrollingEnabled(true);
        this._tree.setModel(this.getTreeModel());
        mainPanel.add((Component)scrollPane, "Center");
        for (int i = 0; i < this._tree.getRowCount(); ++i) {
            this._tree.expandRow(i);
        }
        HyperlinkMouseListener listener = new HyperlinkMouseListener(this._tree);
        HyperlinkKeyListener keyListener = new HyperlinkKeyListener(this._tree);
        this._tree.addMouseListener(listener);
        this._tree.addMouseMotionListener(listener);
        this._tree.addKeyListener(keyListener);
        return mainPanel;
    }

    @Override
    public void postConfigureUI() {
        if (!StringUtil.isNullOrEmpty((String)this._finishButtonText)) {
            ((GUITaskContext)this._context).configureButton(GUITaskContext.ButtonType.FINISH, ((GUITaskContext)this._context).getI18nString(this._namespace, this._finishButtonText), ((GUITaskContext)this._context).getI18nString(this._namespace, this._finishButtonTooltip));
        }
    }

    @Override
    public boolean okNext() {
        return true;
    }

    @Override
    public boolean okPrev() {
        return true;
    }

    protected NodeType parseSchema() throws SAXException, JAXBException {
        return new SummaryPanelParser().parseSummaryConfig(this.getConfigurationStream());
    }

    protected InputStream getConfigurationStream() {
        return SummaryGUITask.class.getClassLoader().getResourceAsStream(this._configFile);
    }

    private TreeModel getTreeModel() {
        SummaryTreeNode rootNode = this.createNode(this._summaryTreeType);
        this.populateTree(rootNode, this.getSubNodes(this._summaryTreeType));
        return new DefaultTreeModel(rootNode);
    }

    private void populateTree(SummaryTreeNode parentNode, List<NodeType> nTypes) {
        if (!nTypes.isEmpty()) {
            for (NodeType nType : nTypes) {
                if (nType.getId() != null && !this._controller.showNode(nType.getId())) continue;
                SummaryTreeNode subNode = this.createNode(nType);
                parentNode.add(subNode);
                this.populateTree(subNode, this.getSubNodes(nType));
            }
        }
    }

    private List<NodeType> getSubNodes(NodeType nType) {
        List<Object> objects = nType.getArgAndSubItemAndNode();
        ArrayList<NodeType> nTypes = new ArrayList<NodeType>(objects.size());
        for (Object obj : objects) {
            if (!(obj instanceof NodeType)) continue;
            nTypes.add((NodeType)obj);
        }
        return nTypes;
    }

    private Object[] getParams(NodeType nType) {
        List<Object> objects = nType.getArgAndSubItemAndNode();
        ArrayList<ArgumentType> arguments = new ArrayList<ArgumentType>(objects.size());
        for (Object obj : objects) {
            if (!(obj instanceof ArgumentType)) continue;
            arguments.add((ArgumentType)obj);
        }
        Object[] params = null;
        if (!arguments.isEmpty()) {
            params = new Object[arguments.size()];
            int i = 0;
            for (ArgumentType arg : arguments) {
                Object param = this._operationSummary.getValue(arg.getId(), arg.isUseVariableApi());
                if (param == null) {
                    param = this._controller.getUndefinedArgument(arg.getId());
                }
                params[i++] = param;
            }
        }
        return params;
    }

    private SummaryTreeNode createNode(NodeType nType) {
        String nodeText = this.getI18nValue(nType.getTitleKey(), new Object[0]);
        Object[] params = this.getParams(nType);
        String hyperlinkText = null;
        if (nType.isHasHyperlink()) {
            if (nodeText.trim().endsWith("}") || nodeText.trim().endsWith("}\"")) {
                hyperlinkText = params[params.length - 1].toString();
            } else {
                String[] nodeTexts = nodeText.split(" ");
                if (nodeTexts != null && nodeTexts.length > 0) {
                    hyperlinkText = nodeTexts[nodeTexts.length - 1];
                }
            }
        }
        if (params != null) {
            nodeText = MessageFormat.format(nodeText, params);
        }
        SummaryTreeNode treeNode = new SummaryTreeNode(nodeText, nType.getFontType(), nType.getColor());
        if (hyperlinkText != null) {
            treeNode.setHyperLinkText(hyperlinkText);
        }
        this.addSubItems(nType.getArgAndSubItemAndNode(), treeNode);
        return treeNode;
    }

    protected String getI18nValue(String key, Object ... params) {
        String value = ((GUITaskContext)this._context).getI18nString(this._namespace, key);
        return value == null ? key : (params == null || params.length <= 0 ? value : MessageFormat.format(value, params));
    }

    private void addSubItems(List<Object> objects, SummaryTreeNode node) {
        LinkedList<SubItemType> subItemTypes = new LinkedList<SubItemType>();
        for (Object obj : objects) {
            if (!(obj instanceof SubItemType)) continue;
            subItemTypes.add((SubItemType)obj);
        }
        if (!subItemTypes.isEmpty()) {
            for (SubItemType subItemType : subItemTypes) {
                String subItemId = subItemType.getId();
                Collection<String> subItems = this._operationSummary.getSubItems(subItemId, subItemType.isUseVariableApi());
                if (subItems == null || subItems.isEmpty()) continue;
                for (String subItem : subItems) {
                    Collection<String> childItems;
                    SummaryTreeNode keyNode = new SummaryTreeNode(subItem, subItemType.getFontType(), subItemType.getColor());
                    if (subItemType.isExtraInfoHolder() && (childItems = this._operationSummary.getSubItems(subItem, subItemType.isUseVariableApi())) != null && !childItems.isEmpty()) {
                        for (String childItem : childItems) {
                            keyNode.add(new SummaryTreeNode(childItem, subItemType.getFontType(), subItemType.getColor()));
                        }
                    }
                    node.add(keyNode);
                }
            }
        }
    }

    protected void displayURI(URI uri) {
        Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        try {
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(uri);
            } else {
                this._logger.log(Level.WARNING, "Not able to get the default browser info.");
            }
        }
        catch (Exception ex) {
            this._logger.log(Level.WARNING, "URI is not correct:" + uri.toString(), ex);
        }
    }

    private void hyperLinkTrigger(Component comp) {
        if (comp != null && comp instanceof SummaryTreeCellRenderer.HyperLinkLabel) {
            String hyperlinkText = ((JLabel)comp).getText();
            if (hyperlinkText.startsWith("http")) {
                try {
                    URL url = new URL(hyperlinkText);
                    this.displayURI(url.toURI());
                }
                catch (Exception e1) {
                    this._logger.log(Level.WARNING, "URL is not correct:" + hyperlinkText, e1);
                }
            } else {
                File file;
                for (file = new File(hyperlinkText); file != null && !file.exists(); file = file.getParentFile()) {
                }
                if (file != null && file.exists()) {
                    this.displayURI(file.toURI());
                }
            }
        }
    }

    private final class HyperlinkKeyListener
    extends KeyAdapter {
        private final JTree _tree;

        private HyperlinkKeyListener(JTree tree) {
            this._tree = tree;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                Object lastPath;
                Component rComponent;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
                TreePath selectionPath = this._tree.getSelectionPath();
                int selRow = this._tree.getRowForPath(selectionPath);
                SummaryTreeCellRenderer renderer = (SummaryTreeCellRenderer)this._tree.getCellRenderer();
                if (node.isLeaf() && (rComponent = renderer.getTreeCellRendererComponent(this._tree, lastPath = selectionPath.getLastPathComponent(), this._tree.isRowSelected(selRow), this._tree.isExpanded(selRow), this._tree.getModel().isLeaf(lastPath), selRow, true)) instanceof JPanel) {
                    Rectangle pathBounds = this._tree.getPathBounds(selectionPath);
                    JPanel panel = (JPanel)rComponent;
                    Component[] components = panel.getComponents();
                    Component comp = components[panel.getComponentCount() - 1];
                    SummaryGUITask.this.hyperLinkTrigger(comp);
                }
            }
        }
    }

    private final class HyperlinkMouseListener
    extends MouseAdapter {
        private final JTree _tree;
        private Cursor _defaultCursor;
        private Cursor _handCursor;

        private HyperlinkMouseListener(JTree tree) {
            this._tree = tree;
            this._defaultCursor = Cursor.getDefaultCursor();
            this._handCursor = Cursor.getPredefinedCursor(12);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component comp = this.getComponentByMouseEvent(e);
            SummaryGUITask.this.hyperLinkTrigger(comp);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean resetParam = true;
            Component comp = this.getComponentByMouseEvent(e);
            if (comp != null && comp instanceof SummaryTreeCellRenderer.HyperLinkLabel) {
                this._tree.setCursor(this._handCursor);
                this._tree.setToolTipText(((JLabel)comp).getText());
                resetParam = false;
            }
            if (resetParam) {
                this._tree.setCursor(this._defaultCursor);
                this._tree.setToolTipText("");
            }
        }

        private Component getComponentByMouseEvent(MouseEvent e) {
            TreePath path;
            Object lastPath;
            Component rComponent;
            Point p = e.getPoint();
            int selRow = this._tree.getRowForLocation(p.x, p.y);
            SummaryTreeCellRenderer renderer = (SummaryTreeCellRenderer)this._tree.getCellRenderer();
            if (selRow != -1 && renderer != null && (rComponent = renderer.getTreeCellRendererComponent(this._tree, lastPath = (path = this._tree.getPathForRow(selRow)).getLastPathComponent(), this._tree.isRowSelected(selRow), this._tree.isExpanded(selRow), this._tree.getModel().isLeaf(lastPath), selRow, true)) instanceof JPanel) {
                Rectangle pathBounds = this._tree.getPathBounds(path);
                JPanel panel = (JPanel)rComponent;
                panel.setBounds(this._tree.getRowBounds(selRow));
                p.translate(-pathBounds.x, -pathBounds.y);
                return panel.getComponentAt(p);
            }
            return null;
        }
    }
}

