/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.cont;

import com.oracle.cie.common.ICommonConstants;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.msgpanel.MessageType;
import com.oracle.cie.wizard.gui.tasks.GUITask;
import com.oracle.cie.wizard.internal.cont.AbstractTaskContainer;
import com.oracle.cie.wizard.internal.cont.GUIContext;
import com.oracle.cie.wizard.tasks.TraversalMode;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class GUITaskContainer
extends AbstractTaskContainer<GUITaskContext, GUITask, GUIContext> {
    private static Logger _log = Logger.getLogger(GUITaskContainer.class.getName());
    protected boolean _bypassFailed;

    @Override
    public boolean isSupported(Class<?> taskClass) {
        return taskClass != null && GUITask.class.isAssignableFrom(taskClass);
    }

    @Override
    public boolean bypassTask() throws WizardException {
        _log.finer("Attempting to bypass task [" + this._task + "], traversal mode [" + (Object)((Object)this._traversalMode) + "]");
        boolean outcome = this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.BYPASS);
        this._bypassFailed = !outcome;
        return outcome;
    }

    @Override
    public void executeTask() {
        if (this._bypassFailed) {
            _log.finer("Bypass recovery for task [" + this._task + "], traversal mode [" + (Object)((Object)this._traversalMode) + "]");
            this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.BYPASS_RECOVERY);
        } else {
            _log.finer("Executing task [" + this._task + "], traversal mode [" + (Object)((Object)this._traversalMode) + "]");
            this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.EXECUTE);
        }
        if (((GUITask)this._task).autoAdvance()) {
            _log.finer("The task requires automatic advance. Requesting wizard to advance.");
            switch (this._traversalMode) {
                case FORWARD: {
                    this._proxy.goNext();
                    break;
                }
                case REVERSE: {
                    this._proxy.goPrevious();
                }
            }
        }
    }

    @Override
    public boolean isTaskComplete(TraversalMode direction) {
        return this.invokeOnEventDispatchThread(direction == TraversalMode.FORWARD ? TASK_RUNNER_METHOD.OK_NEXT : TASK_RUNNER_METHOD.OK_PREV);
    }

    @Override
    public void keepRunningTask() {
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.ENABLE_CTX);
    }

    @Override
    public void unconfigureTask() {
        super.unconfigureTask();
        this._bypassFailed = false;
    }

    @Override
    public boolean handlesFatalErrorExit() {
        return ((GUIContext)this._context).canHandleFatalErrorExit();
    }

    @Override
    protected GUIContext createTaskContext() {
        if (!this._proxy.isEmbeddedProcess()) {
            this.setupResources();
        }
        return new GUIContext(this);
    }

    @Override
    protected void resumeTask() {
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.SUSPEND);
    }

    @Override
    protected void doUnconfigureTask() {
        super.doUnconfigureTask();
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.RESET_CXT);
    }

    @Override
    protected void suspendTask() {
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.RESUME);
    }

    @Override
    protected void handleExit() {
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.NOTIFY_EXIT);
    }

    @Override
    protected void handleError() {
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.ERR_MSG);
    }

    @Override
    protected void handleCleanup() {
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.CLEANUP_MSG);
    }

    @Override
    protected void handleTermination() {
        this.invokeOnEventDispatchThread(TASK_RUNNER_METHOD.TERMINATED_MSG);
    }

    protected void setupResources() {
        ResourceBundleManager.manageBundles((String)"comdev", (String[])ICommonConstants.COMMON_UI_BUNDLES);
        ResourceBundleManager.manageBundles((String)"wizard-internal", (String[])new String[]{"resources/wizard/wizard_gui", "resources/wizard/wizard_gui_nonls"});
        try {
            ResourceBundleManager.manageBundles((String)"wizard-internal", (String[])new String[]{"resources/wizard/wizard_gui_custom"});
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        ResourceBundleManager.manageBundle((String)"wizard", (String)"resources/wizard/wizard_tasks_gui");
    }

    protected boolean invokeOnEventDispatchThread(TASK_RUNNER_METHOD method) {
        MethodRunner taskRunner = new MethodRunner(method);
        if (SwingUtilities.isEventDispatchThread()) {
            taskRunner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(taskRunner);
            }
            catch (Exception e) {
                this._proxy.error(WizardCompletionInfo.getInstance().getErrorCode(), e);
            }
        }
        return taskRunner.getResult();
    }

    protected class MethodRunner
    implements Runnable {
        private TASK_RUNNER_METHOD _taskMethod;
        private boolean _result;

        public MethodRunner(TASK_RUNNER_METHOD taskMethod) {
            this._taskMethod = taskMethod;
        }

        public boolean getResult() {
            return this._result;
        }

        @Override
        public void run() {
            try {
                _log.finest("Executing method: [" + (Object)((Object)this._taskMethod) + "]. Current task: [" + GUITaskContainer.this._task + "]");
                block1 : switch (this._taskMethod) {
                    case EXECUTE: {
                        ((GUIContext)GUITaskContainer.this._context).setupGUI((GUITask)GUITaskContainer.this._task, false);
                        break;
                    }
                    case OK_NEXT: {
                        ((GUIContext)GUITaskContainer.this._context).enableInput(false);
                        this._result = ((GUITask)GUITaskContainer.this._task).okNext();
                        break;
                    }
                    case OK_PREV: {
                        ((GUIContext)GUITaskContainer.this._context).enableInput(false);
                        this._result = ((GUITask)GUITaskContainer.this._task).okPrev();
                        break;
                    }
                    case SUSPEND: {
                        if (GUITaskContainer.this._task == null) break;
                        ((GUITask)GUITaskContainer.this._task).suspend();
                        break;
                    }
                    case RESUME: {
                        if (GUITaskContainer.this._task == null) break;
                        ((GUITask)GUITaskContainer.this._task).resume();
                        break;
                    }
                    case CLEANUP_MSG: {
                        ((GUIContext)GUITaskContainer.this._context).displayCleanupMessage();
                        break;
                    }
                    case TERMINATED_MSG: {
                        ((GUIContext)GUITaskContainer.this._context).disposeUI();
                        break;
                    }
                    case ERR_MSG: {
                        ((GUIContext)GUITaskContainer.this._context).handleFatalErrorMessage();
                        break;
                    }
                    case NOTIFY_EXIT: {
                        if (GUITaskContainer.this._task == null) break;
                        ((GUITask)GUITaskContainer.this._task).exiting();
                        break;
                    }
                    case RESET_CXT: {
                        ((GUIContext)GUITaskContainer.this._context).resetContextUI();
                        break;
                    }
                    case ENABLE_CTX: {
                        ((GUIContext)GUITaskContainer.this._context).enableInput(true);
                        break;
                    }
                    case BYPASS: {
                        ((GUIContext)GUITaskContainer.this._context).setupGUI((GUITask)GUITaskContainer.this._task, true);
                        boolean bl = this._result = GUITaskContainer.this._traversalMode == TraversalMode.FORWARD ? ((GUITask)GUITaskContainer.this._task).okNext() : ((GUITask)GUITaskContainer.this._task).okPrev();
                        if (!this._result || !((GUIContext)GUITaskContainer.this._context).areMessagesIntercepted()) break;
                        this._result = false;
                        break;
                    }
                    case BYPASS_RECOVERY: {
                        ((GUIContext)GUITaskContainer.this._context).postBypassRecovery((GUITask)GUITaskContainer.this._task);
                        if (((GUIContext)GUITaskContainer.this._context).getMessagePanel().hasValidationMessage(MessageType.ERROR) || ((GUIContext)GUITaskContainer.this._context).getMessagePanel().hasValidationMessage(MessageType.WARNING)) break;
                        switch (GUITaskContainer.this._traversalMode) {
                            case FORWARD: {
                                ((GUITask)GUITaskContainer.this._task).okNext();
                                break block1;
                            }
                            case REVERSE: {
                                ((GUITask)GUITaskContainer.this._task).okPrev();
                            }
                        }
                    }
                }
            }
            catch (Throwable th) {
                GUITaskContainer.this._proxy.error(WizardCompletionInfo.getInstance().getFatalErrorCode(), th);
            }
        }
    }

    protected static enum TASK_RUNNER_METHOD {
        EXECUTE,
        OK_NEXT,
        OK_PREV,
        SUSPEND,
        RESUME,
        NOTIFY_EXIT,
        CLEANUP_MSG,
        ERR_MSG,
        TERMINATED_MSG,
        RESET_CXT,
        ENABLE_CTX,
        BYPASS,
        BYPASS_RECOVERY;

    }
}

