/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.engine;

import com.oracle.cie.common.util.logging.Destination;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.WizardLogManager;
import java.util.logging.Level;

public class DefaultWizardLogManager
implements WizardLogManager {
    private LogFactory _factory;
    private WizardConfiguration _conf;

    @Override
    public void setWizardConfiguration(WizardConfiguration conf) {
        this._conf = conf;
    }

    @Override
    public void setupLogging() throws WizardException {
        this._factory = LogFactory.getFactory();
        if (this._factory.getRootLogs().isEmpty()) {
            LogFactory.getFactory().setupLogging(this._conf.getOptionValue(WizardConfiguration.LOGFILE), this._conf.getOptionValue(WizardConfiguration.LOGPRIORITY), true, new String[0]);
        }
    }

    @Override
    public String getLogDestination() {
        if (this._factory != null) {
            Destination destination = this._factory.getRootDestination();
            return destination.getDestName() != null ? destination.getDestName() : destination.toString();
        }
        return null;
    }

    @Override
    public Level getLoggerLevel() {
        return this._factory != null ? this._factory.getRootLevel() : null;
    }

    @Override
    public void setLoggerLevel(Level level) {
        if (this._factory != null) {
            this._factory.changeGlobalLogLevel(level);
        }
    }
}

