/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.tasks;

import com.oracle.cie.wizard.internal.cont.InternalTaskContext;
import com.oracle.cie.wizard.internal.tasks.AbstractInternalTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;

@TaskDescription(name="invokeStaticMethod", cachingPolicy=TaskCachingPolicy.REUSE)
public class InvokeStaticMethodTask
extends AbstractInternalTask {
    protected String _storageKey = null;
    protected String _invocationTargetClass = null;
    protected String _methodName = null;
    protected String _parameter1Key = null;
    protected String _parameter2Key = null;
    protected String _parameter3Key = null;
    protected String _parameter1Type = null;
    protected String _parameter2Type = null;
    protected String _parameter3Type = null;
    protected boolean _useException = false;

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"java.lang.Object"}, required=true)
    public void setInvocationTargetClass(String classname) {
        this._invocationTargetClass = classname;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setMethodName(String methodName) {
        this._methodName = methodName;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setParameter1Key(String parameter1Key) {
        this._parameter1Key = parameter1Key;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setParameter2Key(String parameter2Key) {
        this._parameter2Key = parameter2Key;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setParameter3Key(String parameter3Key) {
        this._parameter3Key = parameter3Key;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setParameter1Type(String parameter1Type) {
        this._parameter1Type = parameter1Type;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setParameter2Type(String parameter2Type) {
        this._parameter2Type = parameter2Type;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setParameter3Type(String parameter3Type) {
        this._parameter3Type = parameter3Type;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setStorageKey(String key) {
        this._storageKey = key;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setUseExceptionErrorMessage(String useException) {
        this._useException = Boolean.valueOf(useException);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute() throws TaskExecutionException {
        try {
            loader = ((InternalTaskContext)this._context).getProxy().getTaskClassLoader();
            clazz = loader.loadClass(((InternalTaskContext)this._context).substitute(this._namespace, this._invocationTargetClass));
        }
        catch (ClassNotFoundException x) {
            this._logger.log(Level.SEVERE, x.toString(), x);
            throw new TaskExecutionException(this, "Can't find class: " + ((InternalTaskContext)this._context).substitute(this._namespace, this._invocationTargetClass), x);
        }
        size = this._parameter1Key != null ? (this._parameter2Key != null ? (this._parameter3Key != null ? 3 : 2) : 1) : 0;
        parameterTypes = new Class[size];
        parameterValues = new Object[size];
        switch (size) {
            case 3: {
                parameterValues[2] = ((InternalTaskContext)this._context).retrieveObject(this._namespace, this._parameter3Key);
                if (this._parameter3Type == null) ** GOTO lbl21
                try {
                    parameterTypes[2] = Class.forName(this._parameter3Type);
                    ** GOTO lbl22
                }
                catch (ClassNotFoundException cnfx) {
                    this._logger.log(Level.SEVERE, cnfx.toString(), cnfx);
                    throw new TaskExecutionException(this, "Can't find class: " + this._parameter3Type, cnfx);
                }
lbl21:
                // 1 sources

                parameterTypes[2] = parameterValues[2].getClass();
            }
lbl22:
            // 3 sources

            case 2: {
                parameterValues[1] = ((InternalTaskContext)this._context).retrieveObject(this._namespace, this._parameter2Key);
                if (this._parameter2Type == null) ** GOTO lbl31
                try {
                    parameterTypes[1] = Class.forName(this._parameter2Type);
                    ** GOTO lbl32
                }
                catch (ClassNotFoundException cnfx) {
                    this._logger.log(Level.SEVERE, cnfx.toString(), cnfx);
                    throw new TaskExecutionException(this, "Can't find class: " + this._parameter2Type, cnfx);
                }
lbl31:
                // 1 sources

                parameterTypes[1] = parameterValues[1].getClass();
            }
lbl32:
            // 3 sources

            case 1: {
                parameterValues[0] = ((InternalTaskContext)this._context).retrieveObject(this._namespace, this._parameter1Key);
                if (this._parameter1Type != null) {
                    try {
                        parameterTypes[0] = Class.forName(this._parameter1Type);
                        break;
                    }
                    catch (ClassNotFoundException cnfx) {
                        this._logger.log(Level.SEVERE, cnfx.toString(), cnfx);
                        throw new TaskExecutionException(this, "Can't find class: " + this._parameter1Type, cnfx);
                    }
                }
                parameterTypes[0] = parameterValues[0].getClass();
            }
        }
        try {
            method = clazz.getMethod(this._methodName, parameterTypes);
            result = method.invoke(null, parameterValues);
            this._logger.finer("Successfully invoked " + method.getName() + " with result <" + result + ">");
            if (this._storageKey != null) {
                ((InternalTaskContext)this._context).storeObject(this._namespace, this._storageKey, result);
            }
        }
        catch (Exception x) {
            this._logger.log(Level.SEVERE, "Unable to invoke " + this._methodName + " on class <" + this._invocationTargetClass + ">", x);
            if (parameterValues != null) {
                for (i = 0; i < parameterValues.length; ++i) {
                    this._logger.severe("  parameterValue " + i + " = <" + (parameterValues[i] != null ? parameterValues[i].toString() : "null") + ">");
                }
            }
            errorMsg = "Unable to invoke " + this._methodName + " in InvokeStaticMethodTask";
            if (this._useException && x instanceof InvocationTargetException && x.getCause() != null && x.getCause().getMessage() != null) {
                errorMsg = x.getCause().getMessage();
            }
            throw new TaskExecutionException(this, errorMsg, x);
        }
    }

    @Override
    public void unconfigure() {
        this._invocationTargetClass = null;
        this._methodName = null;
        this._storageKey = null;
        this._parameter1Key = null;
        this._parameter2Key = null;
        this._parameter3Key = null;
        this._parameter1Type = null;
        this._parameter2Type = null;
        this._parameter3Type = null;
    }
}

