/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.Subflow;
import com.oracle.cie.wizard.internal.wcf.xml.TaskAttributeType;
import com.oracle.cie.wizard.internal.wcf.xml.TaskType;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import com.oracle.cie.wizard.wcf.TaskDefinition;
import com.oracle.cie.wizard.wcf.TaskEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class TaskEntryElem<E extends TaskType>
extends EntryElem<E>
implements TaskEntry {
    protected TaskDefinition _taskDefinition;
    protected Map<String, String> _attrs = new HashMap<String, String>();

    TaskEntryElem(Subflow<?> sequence, E entry) throws ExecPlanException {
        super(sequence, entry);
        this._taskDefinition = sequence.getTarget().getWCFParent().getTaskDefinition(((TaskType)this._xmlPeer).getName());
        for (TaskAttributeType attr : ((TaskType)this._xmlPeer).getAttributes()) {
            if (this._attrs.containsKey(attr.getName())) {
                this._log.warning("WCF [" + this.getParentTarget().getWCFParent().getWcFileName() + "] target [" + this.getParentTarget().getName() + "] task [" + this.getName() + "] contains multiple attributes [" + attr.getName() + "].");
                continue;
            }
            this._attrs.put(attr.getName(), attr.getValue());
        }
    }

    @Override
    public String getName() {
        return ((TaskType)this._xmlPeer).getName();
    }

    @Override
    public String getNamespace() {
        String namespace = ((TaskType)this._xmlPeer).getNamespace();
        return namespace != null ? namespace : this.getParentTarget().getNamespace();
    }

    @Override
    public TaskDefinition getTaskDefinition() {
        return this._taskDefinition;
    }

    @Override
    public Map<String, String> getAttributeMap() {
        return Collections.unmodifiableMap(this._attrs);
    }

    @Override
    public boolean isReverseDisallowed() {
        Boolean result = ((TaskType)this._xmlPeer).isReverseDisallowed();
        return result != null && result != false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" ").append(((TaskType)this.getXmlObject()).getName());
        return sb.toString();
    }
}

