/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.Target;
import com.oracle.cie.wizard.internal.wcf.TaskDefinitionWrapper;
import com.oracle.cie.wizard.internal.wcf.WCFParser;
import com.oracle.cie.wizard.internal.wcf.WCFWorkflow;
import com.oracle.cie.wizard.internal.wcf.xml.TargetType;
import com.oracle.cie.wizard.internal.wcf.xml.TaskDefFileType;
import com.oracle.cie.wizard.internal.wcf.xml.TaskDefinitionType;
import com.oracle.cie.wizard.internal.wcf.xml.WizardControlFileType;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

class WCFWrapper {
    private static Logger _log = Logger.getLogger(WCFWrapper.class.getName());
    private WCFWorkflow _workflow;
    private WCFParser _wcfParser;
    private String _wcFileName;
    private ClassLoader _classLoader;
    private WizardControlFileType _xmlPeer;
    private Map<String, TaskDefinitionWrapper> _taskDefinitionMap = new HashMap<String, TaskDefinitionWrapper>();

    WCFWrapper(WCFWorkflow workflow, WCFParser wcfParser, String wcFileName, ClassLoader classLoader) throws ExecPlanException {
        this._workflow = workflow;
        this._wcfParser = wcfParser;
        this._wcFileName = wcFileName;
        this._classLoader = classLoader;
        this._xmlPeer = this._wcfParser.parseWCF(this._wcFileName, this._classLoader);
        this.loadTaskDefinitions();
    }

    public WCFWorkflow getWorkflow() {
        return this._workflow;
    }

    public String getWcFileName() {
        return this._wcFileName;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public WizardControlFileType getWCFile() {
        return this._xmlPeer;
    }

    public String getNamespace() {
        return this._xmlPeer.getNamespace();
    }

    public Map<String, TaskDefinitionWrapper> getTaskDefinitionMap() {
        return this._taskDefinitionMap;
    }

    public TaskDefinitionWrapper getTaskDefinition(String name) {
        return this._taskDefinitionMap.get(name);
    }

    public Target createTargetWrapper(String targetName) throws ExecPlanException {
        for (TargetType target : this._xmlPeer.getTargets()) {
            if (!target.getName().equals(targetName)) continue;
            return new Target(this, target);
        }
        return null;
    }

    private void loadTaskDefinitions() throws ExecPlanException {
        ArrayList<String> loadedTDFiles = new ArrayList<String>();
        for (TaskDefFileType taskDefFile : this._xmlPeer.getTaskDefFiles()) {
            String tdResPath = taskDefFile.getFileResourcePath();
            if (loadedTDFiles.contains(tdResPath)) {
                _log.warning("WCF [" + this._wcFileName + "] contain duplicate refernce to Task Definitions File [" + tdResPath + "]");
                continue;
            }
            _log.fine("Extracting task definitions from " + tdResPath);
            for (TaskDefinitionType taskDef : this._wcfParser.parseTDFile(tdResPath, this._classLoader).getTaskDefs()) {
                String tdName = taskDef.getName();
                if (this._taskDefinitionMap.containsKey(tdName)) {
                    _log.info("Overriding task definition " + tdName);
                } else {
                    _log.fine("Adding task definition " + tdName);
                }
                this._taskDefinitionMap.put(tdName, new TaskDefinitionWrapper(taskDef));
            }
            loadedTDFiles.add(tdResPath);
        }
        _log.fine("Extracting task definitions from " + this._wcFileName);
        for (TaskDefinitionType taskDef : this._xmlPeer.getTaskDefs()) {
            String tdName = taskDef.getName();
            if (this._taskDefinitionMap.containsKey(tdName)) {
                _log.info("Overriding task definition " + tdName);
            } else {
                _log.fine("Adding task definition " + tdName);
            }
            this._taskDefinitionMap.put(tdName, new TaskDefinitionWrapper(taskDef));
        }
    }
}

