/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;

@TaskDescription(name="copyFiles")
public class CopyFilesTask
extends AbstractSilentTask {
    private static final int _bufferSize = 100000;
    private static final byte[] _buffer = new byte[100000];
    private String _source = null;
    private String _dest = null;
    private File _srcFile = null;
    private File _destFile = null;

    @Override
    public void execute() throws TaskExecutionException {
        if (this._source == null || this._source.equals("") || this._dest == null || this._dest.equals("")) {
            this._logger.log(Level.INFO, "Can not perform copy operation, missing source (" + this._source + ")  or destination (" + this._dest + ") file.");
            return;
        }
        this._dest = this._context.substitute(this._namespace, this._dest);
        this._source = this._context.substitute(this._namespace, this._source);
        this._srcFile = new File(this._source);
        this._destFile = new File(this._dest);
        if (!this._srcFile.exists()) {
            this._logger.log(Level.WARNING, "Source file doesn't exist:" + this._source);
            return;
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer(this.getClass() + ".execute()");
            this._logger.finer("Copying:\tSource=\"" + this._source + "\"\tDest=\"" + this._dest + "\"");
        }
        this.copyFiles(this._srcFile, this._destFile);
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setDest(String dest) {
        this._dest = dest;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setSource(String src) {
        this._source = src;
    }

    private boolean copyFiles(File fromFile, File toFile) {
        boolean rc = true;
        try {
            if (fromFile.isDirectory()) {
                File[] fileList = fromFile.listFiles();
                if (toFile.isFile() && !toFile.delete()) {
                    this._logger.severe("unable to delete dir " + toFile.getAbsolutePath());
                }
                if (!toFile.exists() && !toFile.mkdir()) {
                    this._logger.severe("unable to create dir " + toFile.getAbsolutePath());
                }
                for (File f : fileList) {
                    File newFile;
                    if (f.isDirectory()) {
                        String newFileName = toFile.getAbsolutePath() + File.separator + f.getName();
                        newFile = new File(newFileName);
                        rc = this.copyFiles(f, newFile);
                        continue;
                    }
                    String tmpFileName = toFile.getAbsolutePath() + File.separator + f.getName();
                    newFile = new File(tmpFileName);
                    if (!rc) continue;
                    rc = this.copyFile(f, newFile);
                }
                if (!toFile.setLastModified(fromFile.lastModified())) {
                    this._logger.warning("The last modified operation on " + toFile + " failed.");
                }
            } else if (toFile.isDirectory()) {
                String newFileName2 = toFile.getAbsolutePath() + File.separator + fromFile.getName();
                File newFile2 = new File(newFileName2);
                rc = this.copyFile(fromFile, newFile2);
            } else {
                rc = this.copyFile(fromFile, toFile);
            }
        }
        catch (Throwable thr) {
            this._logger.log(Level.FINE, "Exception while copying...", thr);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean copyFile(File fromFile, File toFile) throws Throwable {
        FileInputStream in = new FileInputStream(fromFile);
        FileOutputStream out = new FileOutputStream(toFile);
        while (true) {
            byte[] byArray = _buffer;
            // MONITORENTER : _buffer
            int i = in.read(_buffer);
            if (i == -1) {
                // MONITOREXIT : byArray
                in.close();
                out.flush();
                out.close();
                boolean rc = false;
                if (fromFile.length() == toFile.length()) return toFile.setLastModified(fromFile.lastModified());
                this._logger.severe("file size error " + toFile.getAbsolutePath());
                return rc;
            }
            out.write(_buffer, 0, i);
            // MONITOREXIT : byArray
        }
    }
}

