/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.ext.impl.OperationInputImpl;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;

@TaskDescription(name="loadResponseFile")
public class LoadResponseFileTask
extends AbstractSilentTask {
    @Override
    public void execute() throws TaskExecutionException {
        if (!OperationInputImpl.isInitialized()) {
            this._logger.log(Level.FINEST, "Failed to load response file as the OperationInput is not initialized");
            return;
        }
        OperationInputImpl operationInput = (OperationInputImpl)OperationInputImpl.getInstance();
        String responseFilePath = operationInput.getOptionValue(WizardConfiguration.RESPONSE_FILE.getName());
        if (StringUtil.isNullOrEmpty((String)responseFilePath)) {
            this._logger.log(Level.FINEST, "No response file provided to load");
            return;
        }
        File file = new File(responseFilePath);
        if (!file.exists() || file.isDirectory()) {
            this._logger.log(Level.WARNING, "Given response file (" + responseFilePath + ") either not exist or pointing to a directory location");
            return;
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
        }
        catch (IOException e) {
            this._logger.log(Level.WARNING, "Failed to load response file: " + responseFilePath, e);
            return;
        }
        for (String key : props.stringPropertyNames()) {
            operationInput.addVariable(key, props.getProperty(key));
        }
    }
}

