/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.validation;

import java.util.List;
import oracle.osysmodel.validation.PublishedRuleSet;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.RuleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult {
    public Boolean passed = null;
    public RuleSet ruleset;
    public String message;
    public List<RuleResult> whatPassed = null;
    public List<RuleResult> whatNotPassed = null;
    public List<RuleResult> whatNulled = null;
    public List<Rule> wasNotEvaluated = null;

    public ValidationResult(Boolean bl, RuleSet ruleSet, String string, List<RuleResult> list, List<RuleResult> list2, List<RuleResult> list3, List<Rule> list4) {
        this.passed = bl;
        this.whatPassed = list;
        this.whatNotPassed = list2;
        this.wasNotEvaluated = list4;
        this.whatNulled = list3;
        this.ruleset = ruleSet;
        this.message = string;
    }

    public String toString() {
        PublishedRuleSet publishedRuleSet = this.ruleset.getClass().getAnnotation(PublishedRuleSet.class);
        StringBuffer stringBuffer = new StringBuffer().append("\n\n " + publishedRuleSet).append(" passed=" + this.passed).append(" ,ruleset message=" + this.message);
        if (this.whatPassed != null && this.whatPassed.size() != 0) {
            stringBuffer.append("\n rules that passed : ");
            for (RuleResult object : this.whatPassed) {
                stringBuffer.append(" \n  " + object);
            }
        }
        if (this.whatNotPassed != null && this.whatNotPassed.size() != 0) {
            stringBuffer.append("\n rules that did not pass: ");
            for (RuleResult ruleResult : this.whatNotPassed) {
                stringBuffer.append(" \n  " + ruleResult);
            }
        }
        if (this.whatNulled != null && this.whatNulled.size() != 0) {
            stringBuffer.append("\n rules that could not be evaluated, most probably missing data: ");
            for (RuleResult ruleResult : this.whatNulled) {
                stringBuffer.append(" \n  " + ruleResult);
            }
        }
        if (this.wasNotEvaluated != null && this.wasNotEvaluated.size() != 0) {
            stringBuffer.append("\n rules that were not invoked: ");
            for (Rule rule : this.wasNotEvaluated) {
                stringBuffer.append(" \n  " + rule);
            }
        }
        return stringBuffer.toString();
    }
}

