/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.jaxb.messages;

import com.oracle.cie.common.util.reporting.jaxb.messages.CompletionWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.InitiationWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.MessageWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.ProgressWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.Wrapper;
import com.oracle.cie.common.util.reporting.messages.Completion;
import com.oracle.cie.common.util.reporting.messages.Initiation;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.common.util.reporting.messages.Progress;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;
import com.oracle.cie.common.util.reporting.messages.TypedMessage;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="report")
public class ReportWrapper
implements Wrapper {
    @XmlElements(value={@XmlElement(name="initiation", type=InitiationWrapper.class), @XmlElement(name="message", type=MessageWrapper.class), @XmlElement(name="progress", type=ProgressWrapper.class), @XmlElement(name="completion", type=CompletionWrapper.class)})
    @XmlElementWrapper(name="report_messages")
    public Collection<Wrapper> _reportMessages = new ArrayList<Wrapper>();
    @XmlTransient
    private Report _wrapped;

    public ReportWrapper() {
        this(null);
    }

    public ReportWrapper(Report wrapped) {
        if (wrapped != null) {
            this._wrapped = wrapped;
            for (ReportMessage reportMessage : this._wrapped.getReportMessages()) {
                Wrapper wrappedMessage;
                switch (reportMessage.getType()) {
                    case initiation: {
                        wrappedMessage = new InitiationWrapper((Initiation)reportMessage);
                        break;
                    }
                    case message: {
                        wrappedMessage = new MessageWrapper((Message)reportMessage);
                        break;
                    }
                    case progress: {
                        wrappedMessage = new ProgressWrapper((Progress)reportMessage);
                        break;
                    }
                    case completion: {
                        wrappedMessage = new CompletionWrapper((Completion)reportMessage);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Encountered unsupported report message type " + (Object)((Object)reportMessage.getType()));
                    }
                }
                this._reportMessages.add(wrappedMessage);
            }
        } else {
            this._wrapped = new Report();
        }
    }

    @Override
    public TypedMessage getWrapped() {
        Collection<ReportMessage> reportMessages = this._wrapped.getReportMessages();
        reportMessages.clear();
        for (Wrapper wrappedMessage : this._reportMessages) {
            reportMessages.add((ReportMessage)wrappedMessage.getWrapped());
        }
        return this._wrapped;
    }
}

