/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.jaspi.client;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.jboss.wsf.stack.cxf.jaspi.client.JaspiClientAuthenticator;

public class JaspiClientOutInterceptor
extends AbstractSoapInterceptor {
    private final JaspiClientAuthenticator authManager;

    public JaspiClientOutInterceptor(JaspiClientAuthenticator authManager) {
        super("pre-protocol");
        this.addAfter(SAAJInInterceptor.class.getName());
        this.authManager = authManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(SoapMessage message) throws Fault {
        SOAPMessage soapMessage;
        if (message.getContent(SOAPMessage.class) == null) {
            SAAJInInterceptor saajIn = new SAAJInInterceptor();
            saajIn.handleMessage(message);
        }
        if ((soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class)) == null) {
            return;
        }
        SOAPMessage copyMessage = null;
        try {
            MessageFactory messageFactory = SAAJInInterceptor.SAAJPreInInterceptor.INSTANCE.getFactory(message);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)bout);
            copyMessage = messageFactory.createMessage(soapMessage.getMimeHeaders(), (InputStream)new ByteArrayInputStream(bout.toByteArray()));
        }
        catch (SOAPException e) {
            throw new Fault((Throwable)e);
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
        if (copyMessage != null) {
            message.put(SOAPMessage.class, (Object)copyMessage);
        }
        try {
            this.authManager.secureRequest(message);
        }
        finally {
            message.put(SOAPMessage.class, (Object)soapMessage);
        }
    }
}

