/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.util.concurrent.CountDownRunnable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.irac.IracBatchSendResult;
import org.infinispan.xsite.irac.IracManagerKeyState;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;

public class IracResponseCollector
implements Runnable {
    private static final Log log = LogFactory.getLog(IracResponseCollector.class);
    private static final AtomicReferenceFieldUpdater<IracResponseCollector, IracBatchSendResult> RESULT_UPDATED = AtomicReferenceFieldUpdater.newUpdater(IracResponseCollector.class, IracBatchSendResult.class, "result");
    private volatile IracBatchSendResult result = IracBatchSendResult.OK;
    private volatile boolean exceptionReceived;
    @GuardedBy(value="failedKeys")
    private final IntSet failedKeys;
    private final Collection<IracManagerKeyState> batch;
    private final IracResponseCompleted listener;
    private final CountDownRunnable countDownRunnable;
    private final CompletableFuture<Void> completableFuture = new CompletableFuture();

    public IracResponseCollector(Collection<IracManagerKeyState> batch, IracResponseCompleted listener) {
        this.batch = batch;
        this.listener = listener;
        this.countDownRunnable = new CountDownRunnable(this);
        this.failedKeys = IntSets.mutableEmptySet((int)batch.size());
    }

    public void dependsOn(XSiteBackup backup, CompletionStage<? extends IntSet> request) {
        this.countDownRunnable.increment();
        request.whenComplete((bitSet, throwable) -> this.onResponse(backup, (IntSet)bitSet, (Throwable)throwable));
    }

    public CompletionStage<Void> freeze() {
        this.countDownRunnable.freeze();
        return this.completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(XSiteBackup backup, IntSet rspIntSet, Throwable throwable) {
        boolean trace = log.isTraceEnabled();
        try {
            if (throwable != null) {
                this.exceptionReceived = true;
                if (DefaultTakeOfflineManager.isCommunicationError(throwable)) {
                    RESULT_UPDATED.set(this, IracBatchSendResult.BACK_OFF_AND_RETRY);
                } else if (this.result == IracBatchSendResult.OK) {
                    RESULT_UPDATED.compareAndSet(this, IracBatchSendResult.OK, IracBatchSendResult.RETRY);
                }
            } else {
                if (trace) {
                    log.tracef("[IRAC] Received response from site %s (%d missing): %s", backup.getSiteName(), this.countDownRunnable.missing(), rspIntSet);
                }
                this.mergeIntSetResult(rspIntSet);
                if (!rspIntSet.isEmpty() && this.result == IracBatchSendResult.OK) {
                    RESULT_UPDATED.compareAndSet(this, IracBatchSendResult.OK, IracBatchSendResult.RETRY);
                }
            }
        }
        finally {
            this.countDownRunnable.decrement();
        }
    }

    @Override
    public void run() {
        if (this.exceptionReceived) {
            this.batch.forEach(IracManagerKeyState::retry);
            this.listener.onResponseCompleted(this.result, Collections.emptyList());
            this.completableFuture.complete(null);
            return;
        }
        ArrayList<IracManagerKeyState> successfulSent = new ArrayList<IracManagerKeyState>(this.batch.size());
        int index = 0;
        for (IracManagerKeyState state : this.batch) {
            if (this.hasKeyFailed(index)) {
                state.retry();
                continue;
            }
            if (!state.done()) continue;
            successfulSent.add(state);
        }
        this.listener.onResponseCompleted(this.result, successfulSent);
        this.completableFuture.complete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeIntSetResult(IntSet rsp) {
        IntSet intSet = this.failedKeys;
        synchronized (intSet) {
            this.failedKeys.addAll(rsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasKeyFailed(int index) {
        IntSet intSet = this.failedKeys;
        synchronized (intSet) {
            return this.failedKeys.contains(index);
        }
    }

    @FunctionalInterface
    public static interface IracResponseCompleted {
        public void onResponseCompleted(IracBatchSendResult var1, Collection<IracManagerKeyState> var2);
    }
}

