/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import jakarta.decorator.Decorator;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.AnnotatedTypeLoader;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployerEnvironmentFactory;
import org.jboss.weld.bootstrap.FastAnnotatedTypeLoader;
import org.jboss.weld.bootstrap.FastProcessAnnotatedTypeResolver;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.AnnotationApiAbstraction;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.SetMultimap;
import org.jboss.weld.util.reflection.Reflections;

public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private final ResourceLoader resourceLoader;
    private final SlimAnnotatedTypeStore annotatedTypeStore;
    private final GlobalEnablementBuilder globalEnablementBuilder;
    private final AnnotationApiAbstraction annotationApi;
    private final ClassFileServices classFileServices;

    public BeanDeployer(BeanManagerImpl manager, ServiceRegistry services) {
        this(manager, services, BeanDeployerEnvironmentFactory.newEnvironment(manager));
    }

    public BeanDeployer(BeanManagerImpl manager, ServiceRegistry services, BeanDeployerEnvironment environment) {
        super(manager, services, environment);
        this.resourceLoader = (ResourceLoader)manager.getServices().get(ResourceLoader.class);
        this.annotatedTypeStore = (SlimAnnotatedTypeStore)manager.getServices().get(SlimAnnotatedTypeStore.class);
        this.globalEnablementBuilder = (GlobalEnablementBuilder)manager.getServices().get(GlobalEnablementBuilder.class);
        this.annotationApi = (AnnotationApiAbstraction)manager.getServices().get(AnnotationApiAbstraction.class);
        this.classFileServices = (ClassFileServices)manager.getServices().get(ClassFileServices.class);
    }

    public BeanDeployer addClass(String className, AnnotatedTypeLoader loader) {
        this.addIfNotNull(loader.loadAnnotatedType(className, this.getManager().getId()));
        return this;
    }

    public BeanDeployer addClass(Class<?> clazz, AnnotatedTypeLoader loader) {
        this.addIfNotNull(loader.loadAnnotatedType(clazz, this.getManager().getId()));
        return this;
    }

    private <T> SlimAnnotatedTypeContext<T> addIfNotNull(SlimAnnotatedTypeContext<T> ctx) {
        if (ctx != null) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedType(ctx);
        }
        return ctx;
    }

    private void processPriority(AnnotatedType<?> type) {
        Integer value;
        Annotation priority = type.getAnnotation(this.annotationApi.PRIORITY_ANNOTATION_CLASS);
        if (priority != null && (value = this.annotationApi.getPriority(priority)) != null) {
            if (type.isAnnotationPresent(Interceptor.class)) {
                this.globalEnablementBuilder.addInterceptor(type.getJavaClass(), value);
            } else if (type.isAnnotationPresent(Decorator.class)) {
                this.globalEnablementBuilder.addDecorator(type.getJavaClass(), value);
            } else {
                this.globalEnablementBuilder.addAlternative(type.getJavaClass(), value);
            }
        }
    }

    public <T> BeanDeployer addSyntheticClass(AnnotatedType<T> source, Extension extension, String suffix) {
        if (suffix == null) {
            suffix = AnnotatedTypes.createTypeId(source);
        }
        ((BeanDeployerEnvironment)this.getEnvironment()).addSyntheticAnnotatedType(this.classTransformer.getUnbackedAnnotatedType(source, this.getManager().getId(), suffix), extension);
        return this;
    }

    public BeanDeployer addClasses(Iterable<String> classes) {
        AnnotatedTypeLoader loader = this.createAnnotatedTypeLoader();
        for (String className : classes) {
            this.addClass(className, loader);
        }
        return this;
    }

    public BeanDeployer addLoadedClasses(Iterable<Class<?>> classes) {
        AnnotatedTypeLoader loader = this.createAnnotatedTypeLoader();
        for (Class<?> clazz : classes) {
            this.addClass(clazz, loader);
        }
        return this;
    }

    protected AnnotatedTypeLoader createAnnotatedTypeLoader() {
        FastProcessAnnotatedTypeResolver resolver;
        if (this.classFileServices != null && (resolver = (FastProcessAnnotatedTypeResolver)Container.instance(this.getManager()).deploymentManager().getServices().get(FastProcessAnnotatedTypeResolver.class)) != null) {
            return new FastAnnotatedTypeLoader(this.getManager(), this.classTransformer, this.classFileServices, this.containerLifecycleEvents, resolver);
        }
        return new AnnotatedTypeLoader(this.getManager(), this.classTransformer, this.containerLifecycleEvents);
    }

    public void processAnnotatedTypes() {
        HashSet classesToBeAdded = new HashSet();
        HashSet classesToBeRemoved = new HashSet();
        for (SlimAnnotatedTypeContext<?> annotatedTypeContext : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            SlimAnnotatedType<?> annotatedType = annotatedTypeContext.getAnnotatedType();
            ProcessAnnotatedTypeImpl<?> event = this.containerLifecycleEvents.fireProcessAnnotatedType(this.getManager(), annotatedTypeContext);
            if (event != null) {
                if (event.isVeto()) {
                    ((BeanDeployerEnvironment)this.getEnvironment()).vetoJavaClass(annotatedType.getJavaClass());
                    classesToBeRemoved.add(annotatedTypeContext);
                    continue;
                }
                boolean dirty = event.isDirty();
                if (dirty) {
                    classesToBeRemoved.add(annotatedTypeContext);
                    classesToBeAdded.add(SlimAnnotatedTypeContext.of(event.getResultingAnnotatedType(), annotatedTypeContext.getExtension()));
                }
                this.processPriority(event.getResultingAnnotatedType());
                continue;
            }
            this.processPriority(annotatedType);
        }
        ((BeanDeployerEnvironment)this.getEnvironment()).removeAnnotatedTypes(classesToBeRemoved);
        ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedTypes(classesToBeAdded);
    }

    public void registerAnnotatedTypes() {
        for (SlimAnnotatedTypeContext<?> ctx : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            this.annotatedTypeStore.put(ctx.getAnnotatedType());
        }
    }

    public void createClassBeans() {
        SetMultimap<Class<?>, SlimAnnotatedType<?>> otherWeldClasses = SetMultimap.newSetMultimap();
        for (SlimAnnotatedTypeContext<?> ctx : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            this.createClassBean(ctx.getAnnotatedType(), otherWeldClasses);
        }
        this.ejbSupport.createSessionBeans((BeanDeployerEnvironment)this.getEnvironment(), otherWeldClasses, this.getManager());
    }

    protected void createClassBean(SlimAnnotatedType<?> annotatedType, SetMultimap<Class<?>, SlimAnnotatedType<?>> otherWeldClasses) {
        boolean managedBeanOrDecorator;
        boolean bl = managedBeanOrDecorator = !this.ejbSupport.isEjb(annotatedType.getJavaClass()) && Beans.isTypeManagedBeanOrDecoratorOrInterceptor(annotatedType);
        if (managedBeanOrDecorator) {
            this.containerLifecycleEvents.preloadProcessInjectionTarget(annotatedType.getJavaClass());
            this.containerLifecycleEvents.preloadProcessBeanAttributes(annotatedType.getJavaClass());
            EnhancedAnnotatedType<?> weldClass = this.classTransformer.getEnhancedAnnotatedType(annotatedType);
            if (weldClass.isAnnotationPresent(Decorator.class)) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessBean.class, annotatedType.getJavaClass());
                this.validateDecorator(weldClass);
                this.createDecorator(weldClass);
            } else if (weldClass.isAnnotationPresent(Interceptor.class)) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessBean.class, annotatedType.getJavaClass());
                this.validateInterceptor(weldClass);
                this.createInterceptor(weldClass);
            } else if (!weldClass.isAbstract()) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessManagedBean.class, annotatedType.getJavaClass());
                this.createManagedBean(weldClass);
            }
        } else {
            Class<? extends Annotation> scopeClass;
            if (Beans.isDecoratorDeclaringInAppropriateConstructor(annotatedType)) {
                BootstrapLogger.LOG.decoratorWithNonCdiConstructor(annotatedType.getJavaClass().getName());
            }
            if ((scopeClass = Beans.getBeanDefiningAnnotationScope(annotatedType)) != null && !Beans.hasSimpleCdiConstructor(annotatedType)) {
                BootstrapLogger.LOG.annotatedTypeNotRegisteredAsBeanDueToMissingAppropriateConstructor(annotatedType.getJavaClass().getName(), scopeClass.getSimpleName());
            }
            otherWeldClasses.put((Object)annotatedType.getJavaClass(), annotatedType);
        }
    }

    public void processClassBeanAttributes() {
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
        this.processBeans(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.processBeans(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.processBeans(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
    }

    private void preInitializeBeans(Iterable<? extends AbstractBean<?, ?>> beans) {
        for (AbstractBean<?, ?> bean : beans) {
            bean.preInitialize();
        }
    }

    protected void processBeans(Iterable<? extends AbstractBean<?, ?>> beans) {
        this.processInjectionTargetEvents(beans);
        this.processProducerEvents(beans);
        this.processBeanAttributes(beans);
    }

    protected void processBeanAttributes(Iterable<? extends AbstractBean<?, ?>> beans) {
        if (!this.containerLifecycleEvents.isProcessBeanAttributesObserved()) {
            return;
        }
        if (!beans.iterator().hasNext()) {
            return;
        }
        HashSet vetoedBeans = new HashSet();
        HashSet previouslySpecializedBeans = new HashSet();
        for (AbstractBean<?, ?> abstractBean : beans) {
            boolean vetoed = this.fireProcessBeanAttributes(abstractBean);
            if (!vetoed) continue;
            vetoedBeans.add(abstractBean);
        }
        for (AbstractBean<Object, Object> abstractBean : vetoedBeans) {
            if (abstractBean.isSpecializing()) {
                previouslySpecializedBeans.addAll(this.specializationAndEnablementRegistry.resolveSpecializedBeans(abstractBean));
                this.specializationAndEnablementRegistry.vetoSpecializingBean(abstractBean);
            }
            ((BeanDeployerEnvironment)this.getEnvironment()).vetoBean(abstractBean);
        }
        this.processBeans(previouslySpecializedBeans);
    }

    protected void searchForNewBeanDeclarations(Iterable<? extends AbstractBean<?, ?>> beans) {
        for (AbstractBean<?, ?> bean : beans) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addNewBeansFromInjectionPoints(bean);
        }
    }

    public void createProducersAndObservers() {
        for (AbstractClassBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans()) {
            this.createObserversProducersDisposers(bean);
        }
    }

    public void processProducerAttributes() {
        this.processBeans(((BeanDeployerEnvironment)this.getEnvironment()).getProducerFields());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getProducerFields());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
        this.processBeans(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
    }

    public void createNewBeans() {
        for (Type type : ((BeanDeployerEnvironment)this.getEnvironment()).getNewBeanTypes()) {
            Class clazz = Reflections.getRawType(type);
            if (this.ejbSupport.isEjb(clazz)) continue;
            this.createNewManagedBean(clazz, type);
        }
        this.ejbSupport.createNewSessionBeans((BeanDeployerEnvironment)this.getEnvironment(), this.getManager());
    }

    public void deploy() {
        this.initializeBeans();
        this.fireProcessBeanEvents();
        this.deployBeans();
        this.initializeObserverMethods();
        this.deployObserverMethods();
    }

    protected void validateInterceptor(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Decorator.class)) {
            throw BootstrapLogger.LOG.beanIsBothInterceptorAndDecorator(weldClass.getName());
        }
    }

    protected void validateDecorator(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Interceptor.class)) {
            throw BootstrapLogger.LOG.beanIsBothInterceptorAndDecorator(weldClass.getName());
        }
    }

    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        for (Bean<?> bean : beanList) {
            if (!(bean instanceof RIBean)) continue;
            ((RIBean)bean).initializeAfterBeanDiscovery();
        }
    }

    public void registerCdiInterceptorsForMessageDrivenBeans() {
        this.ejbSupport.registerCdiInterceptorsForMessageDrivenBeans((BeanDeployerEnvironment)this.getEnvironment(), this.getManager());
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void cleanup() {
        ((BeanDeployerEnvironment)this.getEnvironment()).cleanup();
    }
}

