/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.math.BigInteger;
import java.util.Map;
import java.util.Random;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueueAutoCreationTest
extends JMSClientTestSupport {
    Queue queue1;
    Random random = new Random();
    ActiveMQConnection testConn;
    ClientSession clientSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        String randomSuffix = new BigInteger(130, this.random).toString(32);
        this.testConn = (ActiveMQConnection)this.createCoreConnection();
        this.clientSession = this.testConn.getSessionFactory().createSession();
        this.queue1 = this.createAddressOnlyAndFakeQueue("queue1_" + randomSuffix);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.testConn.close();
        super.tearDown();
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        Configuration serverConfig = server.getConfiguration();
        serverConfig.setJournalType(JournalType.NIO);
        Map map = serverConfig.getAddressesSettings();
        if (map.size() == 0) {
            AddressSettings as = new AddressSettings();
            map.put("#", as);
        }
        Map.Entry entry = map.entrySet().iterator().next();
        AddressSettings settings = (AddressSettings)entry.getValue();
        settings.setAutoCreateQueues(Boolean.valueOf(true));
        this.instanceLog.debug((Object)("server cofg, isauto? " + ((AddressSettings)entry.getValue()).isAutoCreateQueues()));
    }

    protected Queue createAddressOnlyAndFakeQueue(String queueName) throws Exception {
        SimpleString address = SimpleString.toSimpleString((String)queueName);
        this.clientSession.createAddress(address, RoutingType.ANYCAST, false);
        return new ActiveMQQueue(queueName);
    }

    @Test(timeout=30000L)
    public void testSmallString() throws Exception {
        this.sendStringOfSize(1024, false);
    }

    @Test(timeout=30000L)
    public void testHugeString() throws Exception {
        this.sendStringOfSize(0x100000, false);
    }

    @Test(timeout=30000L)
    public void testAutoCreateOnTopic() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:5672");
        Connection connection = factory.createConnection();
        SimpleString addressName = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.instanceLog.debug((Object)("Address is " + addressName));
        this.clientSession.createAddress(addressName, RoutingType.ANYCAST, false);
        ActiveMQTopic topic = new ActiveMQTopic(addressName.toString());
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)topic);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)session.createTextMessage("hello"));
        }
        Assert.assertTrue((boolean)((ActiveMQDestination)topic).isCreated());
    }

    @Test(timeout=30000L)
    public void testAutoCreateOnTopicManySends() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:5672");
        Connection connection = factory.createConnection();
        SimpleString addressName = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.instanceLog.debug((Object)("Address is " + addressName));
        this.clientSession.createAddress(addressName, RoutingType.ANYCAST, false);
        Session session = connection.createSession(false, 1);
        for (int i = 0; i < 10; ++i) {
            ActiveMQTopic topic = new ActiveMQTopic(addressName.toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send((Message)session.createTextMessage("hello"));
            producer.close();
            Assert.assertTrue((boolean)((ActiveMQDestination)topic).isCreated());
        }
    }

    @Test(timeout=30000L)
    public void testAutoCreateOnTopicAndConsume() throws Exception {
        int i;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:5672");
        Connection connection = factory.createConnection();
        SimpleString addressName = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.instanceLog.debug((Object)("Address is " + addressName));
        this.clientSession.createAddress(addressName, RoutingType.ANYCAST, false);
        Connection recConnection = factory.createConnection();
        Session recSession = recConnection.createSession(1);
        Topic topicConsumer = recSession.createTopic(addressName.toString());
        MessageConsumer consumer = recSession.createConsumer((Destination)topicConsumer);
        recConnection.start();
        Session session = connection.createSession(false, 1);
        for (i = 0; i < 10; ++i) {
            Topic topic = session.createTopic(addressName.toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send((Message)session.createTextMessage("hello"));
            producer.close();
            Assert.assertTrue((boolean)((ActiveMQDestination)topic).isCreated());
        }
        for (i = 0; i < 10; ++i) {
            TextMessage message = (TextMessage)consumer.receive(10000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)"hello", (Object)message.getText());
        }
        Assert.assertNull((Object)consumer.receiveNoWait());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStringOfSize(int msgSize, boolean useCoreReceive) throws JMSException {
        try (Connection conn = this.createConnection();){
            Session session = conn.createSession(false, 1);
            MessageProducer prod = session.createProducer((Destination)this.queue1);
            TextMessage m = session.createTextMessage();
            m.setJMSDeliveryMode(2);
            StringBuffer buffer = new StringBuffer();
            while (buffer.length() < msgSize) {
                buffer.append(UUIDGenerator.getInstance().generateStringUUID());
            }
            String originalString = buffer.toString();
            m.setText(originalString);
            prod.send((Message)m);
            conn.close();
            conn = useCoreReceive ? this.createCoreConnection() : this.createConnection();
            session = conn.createSession(false, 1);
            MessageConsumer cons = session.createConsumer((Destination)this.queue1);
            conn.start();
            TextMessage rm = (TextMessage)cons.receive(5000L);
            Assert.assertNotNull((Object)rm);
            String str = rm.getText();
            Assert.assertEquals((Object)originalString, (Object)str);
        }
    }
}

