/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;

public class FederatedTestBase
extends ActiveMQTestBase {
    protected List<MBeanServer> mBeanServers = new ArrayList<MBeanServer>();
    protected List<ActiveMQServer> servers = new ArrayList<ActiveMQServer>();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < this.numberOfServers(); ++i) {
            MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer();
            this.mBeanServers.add(mBeanServer);
            Configuration config = this.createDefaultConfig(i, false).setSecurityEnabled(false);
            for (int j = 0; j < this.numberOfServers(); ++j) {
                config.addConnectorConfiguration("server" + j, "vm://" + j);
            }
            ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)mBeanServer, (boolean)false));
            this.servers.add(server);
            server.start();
            this.configureQueues(server);
        }
    }

    protected void configureQueues(ActiveMQServer server) throws Exception {
    }

    protected void createSimpleQueue(ActiveMQServer server, String queueName) throws Exception {
        SimpleString simpleStringQueueName = SimpleString.toSimpleString((String)queueName);
        try {
            server.createQueue(new QueueConfiguration(simpleStringQueueName).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int numberOfServers() {
        return 3;
    }

    public ActiveMQServer getServer(int i) {
        return this.servers.get(i);
    }
}

