/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactingOpenWireTest
extends BasicOpenWireTest {
    private static final Logger logger = Logger.getLogger(CompactingOpenWireTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        this.realStore = true;
        super.setUp();
        System.setProperty("org.apache.activemq.transport.AbstractInactivityMonitor.keepAliveTime", "2");
        this.createFactories();
        for (int i = 0; i < 30; ++i) {
            SimpleString coreQueue = new SimpleString(this.queueName + i);
            this.server.createQueue(new QueueConfiguration(coreQueue).setRoutingType(RoutingType.ANYCAST));
            this.testQueues.put(this.queueName, coreQueue);
        }
    }

    @Override
    protected String getConnectionUrl() {
        return "failover:tcp://localhost:61616?wireFormat.cacheEnabled=true";
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        super.extraServerConfig(serverConfig);
        serverConfig.setIDCacheSize(500);
        serverConfig.setPersistIDCache(true);
        serverConfig.setJournalSyncTransactional(false);
        serverConfig.setJournalSyncNonTransactional(false);
        serverConfig.setJournalFileSize(10240);
        serverConfig.setJournalCompactMinFiles(1);
        serverConfig.setJournalCompactPercentage(0);
        serverConfig.setJournalType(JournalType.MAPPED);
        serverConfig.setJournalBufferTimeout_NIO(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactCompact() throws Exception {
        int THREADS = 30;
        final AtomicInteger errors = new AtomicInteger(0);
        final AtomicBoolean running = new AtomicBoolean(true);
        ExecutorService executorService = Executors.newFixedThreadPool(31);
        CountDownLatch compactDone = new CountDownLatch(1);
        executorService.execute(() -> {
            while (running.get()) {
                try {
                    this.server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(10000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
            compactDone.countDown();
        });
        final CountDownLatch latchDone = new CountDownLatch(30);
        AssertionLoggerHandler.startCapture();
        try {
            final String space1k = new String(new char[5]).replace('\u0000', ' ');
            for (int i = 0; i < 30; ++i) {
                final int id = i % 10;
                executorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try (Connection connection = CompactingOpenWireTest.this.factory.createConnection();){
                            Session session = connection.createSession(true, 0);
                            Session consumerSession = connection.createSession(false, 2);
                            Queue queue = session.createQueue(CompactingOpenWireTest.this.queueName + id);
                            MessageProducer producer = session.createProducer((Destination)queue);
                            MessageConsumer consumer = consumerSession.createConsumer((Destination)queue);
                            connection.start();
                            for (int j = 0; j < 1000 && running.get(); ++j) {
                                TextMessage textMessage = session.createTextMessage("test");
                                textMessage.setStringProperty("1k", space1k);
                                producer.send((Message)textMessage);
                                if (j % 2 == 0) {
                                    session.commit();
                                    TextMessage message = (TextMessage)consumer.receive(5000L);
                                    Assert.assertNotNull((Object)message);
                                    Assert.assertEquals((Object)"test", (Object)message.getText());
                                    message.acknowledge();
                                    continue;
                                }
                                session.rollback();
                            }
                            logger.debug((Object)"Done! ");
                        }
                        catch (Throwable t) {
                            errors.incrementAndGet();
                            t.printStackTrace();
                        }
                        finally {
                            latchDone.countDown();
                        }
                    }
                });
            }
            latchDone.await(10L, TimeUnit.MINUTES);
            running.set(false);
            compactDone.await(10L, TimeUnit.MINUTES);
            executorService.shutdownNow();
            Assert.assertEquals((long)0L, (long)errors.get());
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ144003"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222055"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222302"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
            running.set(false);
            executorService.shutdownNow();
        }
        this.connection.close();
        this.server.stop();
        this.server.getConfiguration().setPersistIDCache(false);
        this.server.getConfiguration().setJournalPoolFiles(2);
        this.server.start();
        this.server.waitForActivation(1L, TimeUnit.SECONDS);
        this.server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(60000);
        this.server.stop();
        HashMap counts = this.countJournal(this.server.getConfiguration());
        counts.forEach((a, b) -> System.out.println(a + " = " + b));
        AtomicInteger duplicateIDCounts = (AtomicInteger)counts.get(37);
        Assert.assertTrue((String)("There are duplicate IDs on the journal even though the system was reconfigured to not persist them::" + duplicateIDCounts), (duplicateIDCounts == null || duplicateIDCounts.get() == 0 ? (byte)1 : 0) != 0);
    }
}

