/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.Test;

public class JMSConsumer2Test
extends BasicOpenWireTest {
    @Test
    public void testMessageListenerWithConsumerCanBeStoppedConcurently() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch closeDone = new CountDownLatch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        this.sendMessages(session, (Destination)destination, 2000);
        final ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)destination);
        final Map exceptions = Collections.synchronizedMap(new HashMap());
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exceptions.put(t, e);
            }
        });
        final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                final class AckAndClose
                implements Runnable {
                    private final Message message;
                    final /* synthetic */ AtomicInteger val$counter;
                    final /* synthetic */ ActiveMQMessageConsumer val$consumer;
                    final /* synthetic */ CountDownLatch val$closeDone;
                    final /* synthetic */ Map val$exceptions;

                    AckAndClose(Message m) {
                        this.val$counter = atomicInteger;
                        this.val$consumer = activeMQMessageConsumer;
                        this.val$closeDone = countDownLatch;
                        this.val$exceptions = map;
                        this.message = m;
                    }

                    @Override
                    public void run() {
                        block4: {
                            try {
                                int count = this.val$counter.incrementAndGet();
                                if (count == 590) {
                                    this.val$consumer.close();
                                    this.val$closeDone.countDown();
                                }
                                if (count % 200 == 0) {
                                    this.message.acknowledge();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (e instanceof IllegalStateException) break block4;
                                this.val$exceptions.put(Thread.currentThread(), e);
                            }
                        }
                    }
                }
                executor.execute(new AckAndClose(JMSConsumer2Test.this, m, counter, consumer, closeDone, exceptions));
            }
        });
        JMSConsumer2Test.assertTrue((boolean)closeDone.await(20L, TimeUnit.SECONDS));
        Thread.sleep(1000L);
        JMSConsumer2Test.assertTrue((String)("no exceptions: " + exceptions), (boolean)exceptions.isEmpty());
        executor.shutdown();
    }

    @Test
    public void testDupsOkConsumer() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 3);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 4);
        for (int i = 0; i < 4; ++i) {
            Message m = consumer.receive(1000L);
            JMSConsumer2Test.assertNotNull((Object)m);
        }
        JMSConsumer2Test.assertNull((Object)consumer.receive(1000L));
        consumer.close();
        consumer = session.createConsumer((Destination)destination);
        JMSConsumer2Test.assertNull((Object)consumer.receive(1000L));
    }

    @Test
    public void testRedispatchOfUncommittedTx() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        this.sendMessages((Connection)this.connection, (Destination)destination, 2);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message m = consumer.receive(1000L);
        JMSConsumer2Test.assertNotNull((Object)m);
        m = consumer.receive(5000L);
        JMSConsumer2Test.assertNotNull((Object)m);
        JMSConsumer2Test.assertFalse((String)"redelivered flag set", (boolean)m.getJMSRedelivered());
        Session redispatchSession = this.connection.createSession(true, 0);
        MessageConsumer redispatchConsumer = redispatchSession.createConsumer((Destination)destination);
        session.close();
        Message msg = redispatchConsumer.receive(3000L);
        JMSConsumer2Test.assertNotNull((Object)msg);
        JMSConsumer2Test.assertTrue((String)"redelivered flag set", (boolean)msg.getJMSRedelivered());
        JMSConsumer2Test.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        msg = redispatchConsumer.receive(1000L);
        JMSConsumer2Test.assertNotNull((Object)msg);
        JMSConsumer2Test.assertTrue((boolean)msg.getJMSRedelivered());
        JMSConsumer2Test.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        redispatchSession.commit();
        JMSConsumer2Test.assertNull((Object)redispatchConsumer.receive(500L));
        redispatchSession.close();
    }

    @Test
    public void testRedispatchOfRolledbackTx() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        this.sendMessages((Connection)this.connection, (Destination)destination, 2);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        JMSConsumer2Test.assertNotNull((Object)consumer.receive(1000L));
        JMSConsumer2Test.assertNotNull((Object)consumer.receive(1000L));
        Session redispatchSession = this.connection.createSession(true, 0);
        MessageConsumer redispatchConsumer = redispatchSession.createConsumer((Destination)destination);
        session.rollback();
        session.close();
        Message msg = redispatchConsumer.receive(1000L);
        JMSConsumer2Test.assertNotNull((Object)msg);
        JMSConsumer2Test.assertTrue((boolean)msg.getJMSRedelivered());
        JMSConsumer2Test.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        msg = redispatchConsumer.receive(1000L);
        JMSConsumer2Test.assertNotNull((Object)msg);
        JMSConsumer2Test.assertTrue((boolean)msg.getJMSRedelivered());
        JMSConsumer2Test.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        redispatchSession.commit();
        JMSConsumer2Test.assertNull((Object)redispatchConsumer.receive(500L));
        redispatchSession.close();
    }

    @Test
    public void testRedeliveryOnServerConnectionFailWithPendingAckInLocalTx() throws Exception {
        this.connection.start();
        this.sendMessages((Connection)this.connection, (Destination)new ActiveMQQueue(this.queueName), 1);
        this.connection.close();
        this.factory.setWatchTopicAdvisories(false);
        this.factory.setNonBlockingRedelivery(true);
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        CountDownLatch gotMessage = new CountDownLatch(1);
        consumer.setMessageListener(message -> gotMessage.countDown());
        JMSConsumer2Test.assertTrue((boolean)gotMessage.await(1L, TimeUnit.SECONDS));
        final Queue queueInstance = this.server.locateQueue(new SimpleString(this.queueName));
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return queueInstance.getAcknowledgeAttempts() > 0L;
            }
        });
        try {
            ((Socket)this.connection.getTransport().narrow(Socket.class)).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
        session = this.connection.createSession(true, 0);
        consumer = session.createConsumer((Destination)destination);
        JMSConsumer2Test.assertNotNull((Object)consumer.receive(2000L));
        session.commit();
        this.connection.close();
    }
}

