/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AddressSettingsConfigurationStorageTest
extends StorageManagerTestBase {
    private Map<SimpleString, PersistedAddressSetting> mapExpectedAddresses;

    public AddressSettingsConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mapExpectedAddresses = new HashMap<SimpleString, PersistedAddressSetting>();
    }

    protected void addAddress(StorageManager journal1, String address, AddressSettings setting) throws Exception {
        SimpleString str = new SimpleString(address);
        PersistedAddressSetting persistedSetting = new PersistedAddressSetting(str, setting);
        this.mapExpectedAddresses.put(str, persistedSetting);
        journal1.storeAddressSetting(persistedSetting);
    }

    @Test
    public void testStoreSecuritySettings() throws Exception {
        this.createStorage();
        AddressSettings setting = new AddressSettings();
        setting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK).setDeadLetterAddress(new SimpleString("some-test"));
        this.addAddress(this.journal, "a2", setting);
        this.journal.stop();
        this.createStorage();
        this.checkAddresses(this.journal);
        setting = new AddressSettings().setDeadLetterAddress(new SimpleString("new-adddress"));
        this.addAddress(this.journal, "a1", setting);
        this.journal.stop();
        this.createStorage();
        this.checkAddresses(this.journal);
        this.journal.stop();
        this.journal = null;
    }

    private void checkAddresses(StorageManager journal1) throws Exception {
        List listSetting = journal1.recoverAddressSettings();
        AddressSettingsConfigurationStorageTest.assertEquals((long)this.mapExpectedAddresses.size(), (long)listSetting.size());
        for (PersistedAddressSetting el : listSetting) {
            PersistedAddressSetting el2 = this.mapExpectedAddresses.get(el.getAddressMatch());
            AddressSettingsConfigurationStorageTest.assertEquals((Object)el.getAddressMatch(), (Object)el2.getAddressMatch());
            AddressSettingsConfigurationStorageTest.assertEquals((Object)el.getSetting(), (Object)el2.getSetting());
        }
    }
}

