/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.JournalUpdateCallback;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.replication.ReplicatedJournal;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ReplicationTest
extends ActiveMQTestBase {
    @Parameterized.Parameter
    public boolean pluggableQuorum;
    private ThreadFactory tFactory;
    private ExecutorService executor;
    private ExecutorFactory factory;
    private ScheduledExecutorService scheduledExecutor;
    private ActiveMQServer backupServer;
    private ActiveMQServer liveServer;
    private ServerLocator locator;
    private ReplicationManager manager;
    private static final SimpleString ADDRESS = new SimpleString("foobar123");

    @Parameterized.Parameters(name="PluggableQuorum={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    private void setupServer(boolean backup, String ... interceptors) throws Exception {
        this.setupServer(false, backup, null, interceptors);
    }

    private void setupServer(boolean useNetty, boolean backup, ExtraConfigurer extraConfig, String ... incomingInterceptors) throws Exception {
        TransportConfiguration liveConnector = null;
        TransportConfiguration liveAcceptor = null;
        TransportConfiguration backupConnector = null;
        TransportConfiguration backupAcceptor = null;
        if (useNetty) {
            liveConnector = TransportConfigurationUtils.getNettyConnector(true, 0);
            liveAcceptor = TransportConfigurationUtils.getNettyAcceptor(true, 0);
            backupConnector = TransportConfigurationUtils.getNettyConnector(false, 0);
            backupAcceptor = TransportConfigurationUtils.getNettyAcceptor(false, 0);
        } else {
            liveConnector = TransportConfigurationUtils.getInVMConnector(true);
            backupConnector = TransportConfigurationUtils.getInVMConnector(false);
            backupAcceptor = TransportConfigurationUtils.getInVMAcceptor(false);
        }
        Configuration liveConfig = this.createDefaultInVMConfig();
        Configuration backupConfig = this.createDefaultInVMConfig().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setIncomingInterceptorClassNames(incomingInterceptors.length > 0 ? Arrays.asList(incomingInterceptors) : new ArrayList());
        if (!this.pluggableQuorum) {
            ReplicatedBackupUtils.configureReplicationPair(backupConfig, backupConnector, backupAcceptor, liveConfig, liveConnector, liveAcceptor);
        } else {
            DistributedPrimitiveManagerConfiguration managerConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
            ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(backupConfig, backupConnector, backupAcceptor, liveConfig, liveConnector, liveAcceptor, managerConfiguration, managerConfiguration);
        }
        if (extraConfig != null) {
            extraConfig.config(liveConfig, backupConfig);
        }
        if (backup) {
            this.liveServer = this.createServer(liveConfig);
            this.liveServer.start();
            ReplicationTest.waitForComponent((ActiveMQComponent)this.liveServer);
        }
        this.backupServer = this.createServer(backupConfig);
        this.locator = useNetty ? this.createNettyNonHALocator() : this.createInVMNonHALocator();
        this.backupServer.start();
        if (backup) {
            ActiveMQTestBase.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer);
        }
        int count = 0;
        this.waitForReplication(count);
    }

    private void waitForReplication(int count) throws InterruptedException {
        if (this.liveServer == null) {
            return;
        }
        while (this.liveServer.getReplicationManager() == null && count < 10) {
            Thread.sleep(50L);
            ++count;
        }
    }

    private static void waitForComponent(ActiveMQComponent component) throws Exception {
        ReplicationTest.waitForComponent((ActiveMQComponent)component, (long)3L);
    }

    @Test
    public void testBasicConnection() throws Exception {
        this.setupServer(true, new String[0]);
        ReplicationTest.waitForComponent((ActiveMQComponent)this.liveServer.getReplicationManager());
    }

    @Test
    public void testConnectIntoNonBackup() throws Exception {
        this.setupServer(false, new String[0]);
        try {
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            this.manager = new ReplicationManager(null, (CoreRemotingConnection)sf.getConnection(), sf.getServerLocator().getCallTimeout(), sf.getServerLocator().getCallTimeout(), this.factory);
            this.addActiveMQComponent((ActiveMQComponent)this.manager);
            this.manager.start();
            Assert.fail((String)"Exception was expected");
        }
        catch (ActiveMQNotConnectedException sf) {
        }
        catch (ActiveMQException expected) {
            ReplicationTest.fail((String)("Invalid Exception type:" + expected.getType()));
        }
    }

    @Test
    public void testSendPackets() throws Exception {
        this.setupServer(true, new String[0]);
        JournalStorageManager storage = this.getStorage();
        this.manager = this.liveServer.getReplicationManager();
        ReplicationTest.waitForComponent((ActiveMQComponent)this.manager);
        ReplicatedJournal replicatedJournal = new ReplicatedJournal(1, (Journal)new FakeJournal(), this.manager);
        replicatedJournal.appendPrepareRecord(1L, (EncodingSupport)new FakeData(), false);
        replicatedJournal.appendAddRecord(1L, (byte)1, (EncodingSupport)new FakeData(), false);
        replicatedJournal.appendUpdateRecord(1L, (byte)2, (EncodingSupport)new FakeData(), false);
        replicatedJournal.appendDeleteRecord(1L, false);
        replicatedJournal.appendAddRecordTransactional(2L, 2L, (byte)1, (EncodingSupport)new FakeData());
        replicatedJournal.appendUpdateRecordTransactional(2L, 2L, (byte)2, (EncodingSupport)new FakeData());
        replicatedJournal.appendCommitRecord(2L, false);
        replicatedJournal.appendDeleteRecordTransactional(3L, 4L, (EncodingSupport)new FakeData());
        replicatedJournal.appendPrepareRecord(3L, (EncodingSupport)new FakeData(), false);
        replicatedJournal.appendRollbackRecord(3L, false);
        this.blockOnReplication((StorageManager)storage, this.manager);
        Assert.assertTrue((String)("Expecting no active tokens:" + this.manager.getActiveTokens()), (boolean)this.manager.getActiveTokens().isEmpty());
        CoreMessage msg = new CoreMessage().initBuffer(1024).setMessageID(1L);
        SimpleString dummy = new SimpleString("dummy");
        msg.setAddress(dummy);
        replicatedJournal.appendAddRecordTransactional(23L, 24L, (byte)1, (EncodingSupport)new FakeData());
        PagedMessageImpl pgmsg = new PagedMessageImpl((Message)msg, new long[0]);
        this.manager.pageWrite((PagedMessage)pgmsg, 1);
        this.manager.pageWrite((PagedMessage)pgmsg, 2);
        this.manager.pageWrite((PagedMessage)pgmsg, 3);
        this.manager.pageWrite((PagedMessage)pgmsg, 4);
        this.blockOnReplication((StorageManager)storage, this.manager);
        PagingManager pagingManager = this.createPageManager(this.backupServer.getStorageManager(), this.backupServer.getConfiguration(), this.backupServer.getExecutorFactory(), (HierarchicalRepository<AddressSettings>)this.backupServer.getAddressSettingsRepository());
        PagingStore store = pagingManager.getPageStore(dummy);
        store.start();
        Assert.assertEquals((long)4L, (long)store.getNumberOfPages());
        store.stop();
        this.manager.pageDeleted(dummy, 1);
        this.manager.pageDeleted(dummy, 2);
        this.manager.pageDeleted(dummy, 3);
        this.manager.pageDeleted(dummy, 4);
        this.manager.pageDeleted(dummy, 5);
        this.manager.pageDeleted(dummy, 6);
        this.blockOnReplication((StorageManager)storage, this.manager);
        CoreMessage serverMsg = new CoreMessage();
        serverMsg.setMessageID(500L);
        serverMsg.setAddress(new SimpleString("tttt"));
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)100);
        serverMsg.encodeHeadersAndProperties(buffer.byteBuf());
        this.manager.largeMessageBegin(500L);
        this.manager.largeMessageWrite(500L, new byte[1024]);
        this.manager.largeMessageDelete(Long.valueOf(500L), storage);
        this.blockOnReplication((StorageManager)storage, this.manager);
        store.start();
        Assert.assertEquals((long)0L, (long)store.getNumberOfPages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendPacketsWithFailure() throws Exception {
        int nMsg = 100;
        int stop = 37;
        this.setupServer(true, TestInterceptor.class.getName());
        this.manager = this.liveServer.getReplicationManager();
        ReplicationTest.waitForComponent((ActiveMQComponent)this.manager);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession();
        ClientSession session2 = sf.createSession();
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        session.start();
        session2.start();
        try {
            ClientConsumer consumer = session2.createConsumer(ADDRESS);
            for (int i = 0; i < 100; ++i) {
                ClientMessage message = session.createMessage(true);
                this.setBody(i, message);
                message.putIntProperty("counter", i);
                producer.send((Message)message);
                if (i == 37) {
                    TestInterceptor.value.set(false);
                }
                ClientMessage msgRcvd = consumer.receive(1000L);
                Assert.assertNotNull((String)"Message should exist!", (Object)msgRcvd);
                this.assertMessageBody(i, msgRcvd);
                Assert.assertEquals((long)i, (long)msgRcvd.getIntProperty("counter").intValue());
                msgRcvd.acknowledge();
            }
        }
        finally {
            TestInterceptor.value.set(false);
            if (!session.isClosed()) {
                session.close();
            }
            if (!session2.isClosed()) {
                session2.close();
            }
        }
    }

    @Test
    public void testExceptionSettingActionBefore() throws Exception {
        OperationContext ctx = OperationContextImpl.getContext((ExecutorFactory)this.factory);
        ctx.storeLineUp();
        String msg = "I'm an exception";
        ctx.onError(ActiveMQExceptionType.UNBLOCKED.getCode(), msg);
        final AtomicInteger lastError = new AtomicInteger(0);
        final ArrayList msgsResult = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(1);
        ctx.executeOnCompletion(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                lastError.set(errorCode);
                msgsResult.add(errorMessage);
                latch.countDown();
            }

            public void done() {
            }
        });
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)5L, (long)lastError.get());
        Assert.assertEquals((long)1L, (long)msgsResult.size());
        Assert.assertEquals((Object)msg, msgsResult.get(0));
        final CountDownLatch latch2 = new CountDownLatch(1);
        ctx.executeOnCompletion(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                lastError.set(errorCode);
                msgsResult.add(errorMessage);
                latch2.countDown();
            }

            public void done() {
            }
        });
        Assert.assertTrue((boolean)latch2.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)2L, (long)msgsResult.size());
        Assert.assertEquals((Object)msg, msgsResult.get(0));
        Assert.assertEquals((Object)msg, msgsResult.get(1));
        final CountDownLatch latch3 = new CountDownLatch(1);
        ctx.executeOnCompletion(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
            }

            public void done() {
                latch3.countDown();
            }
        });
        Assert.assertTrue((boolean)latch2.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testClusterConnectionConfigs() throws Exception {
        long ttlOverride = 123456789L;
        long checkPeriodOverride = 987654321L;
        ExtraConfigurer configurer = new ExtraConfigurer(){

            @Override
            public void config(Configuration liveConfig, Configuration backupConfig) {
                List ccList = backupConfig.getClusterConfigurations();
                Assert.assertTrue((ccList.size() > 0 ? (byte)1 : 0) != 0);
                ClusterConnectionConfiguration cc = (ClusterConnectionConfiguration)ccList.get(0);
                cc.setConnectionTTL(123456789L);
                cc.setClientFailureCheckPeriod(987654321L);
            }
        };
        this.setupServer(true, true, configurer, new String[0]);
        ReplicationTest.assertTrue((boolean)(this.backupServer instanceof ActiveMQServerImpl));
        ClusterController controller = this.backupServer.getClusterManager().getClusterController();
        ServerLocator replicationLocator = controller.getReplicationLocator();
        ReplicationTest.assertNotNull((Object)replicationLocator);
        ReplicationTest.assertEquals((long)123456789L, (long)replicationLocator.getConnectionTTL());
        ReplicationTest.assertEquals((long)987654321L, (long)replicationLocator.getClientFailureCheckPeriod());
    }

    private JournalStorageManager getStorage() throws Exception {
        return new JournalStorageManager(this.createDefaultInVMConfig(), (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.factory, this.factory);
    }

    private void blockOnReplication(StorageManager storage, ReplicationManager manager1) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        storage.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
            }

            public void done() {
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
    }

    @Test
    public void testNoActions() throws Exception {
        this.setupServer(true, new String[0]);
        JournalStorageManager storage = this.getStorage();
        this.manager = this.liveServer.getReplicationManager();
        ReplicationTest.waitForComponent((ActiveMQComponent)this.manager);
        ReplicatedJournal replicatedJournal = new ReplicatedJournal(1, (Journal)new FakeJournal(), this.manager);
        replicatedJournal.appendPrepareRecord(1L, (EncodingSupport)new FakeData(), false);
        final CountDownLatch latch = new CountDownLatch(1);
        storage.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
            }

            public void done() {
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((String)("should be empty " + this.manager.getActiveTokens()), (long)0L, (long)this.manager.getActiveTokens().size());
    }

    @Test
    public void testOrderOnNonPersistency() throws Exception {
        int i;
        this.setupServer(true, new String[0]);
        final ArrayList executions = new ArrayList();
        JournalStorageManager storage = this.getStorage();
        this.manager = this.liveServer.getReplicationManager();
        ReplicatedJournal replicatedJournal = new ReplicatedJournal(1, (Journal)new FakeJournal(), this.manager);
        int numberOfAdds = 200;
        final CountDownLatch latch = new CountDownLatch(numberOfAdds);
        OperationContext ctx = storage.getContext();
        for (i = 0; i < numberOfAdds; ++i) {
            final int nAdd = i;
            if (i % 2 == 0) {
                replicatedJournal.appendPrepareRecord((long)i, (EncodingSupport)new FakeData(), false);
            }
            ctx.executeOnCompletion(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                }

                public void done() {
                    executions.add(nAdd);
                    latch.countDown();
                }
            });
        }
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        for (i = 0; i < numberOfAdds; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)executions.get(i)).intValue());
        }
        Assert.assertEquals((long)0L, (long)this.manager.getActiveTokens().size());
    }

    @Test
    public void testReplicationLargeMessageFileClose() throws Exception {
        this.setupServer(true, new String[0]);
        JournalStorageManager storage = this.getStorage();
        this.manager = this.liveServer.getReplicationManager();
        ReplicationTest.waitForComponent((ActiveMQComponent)this.manager);
        CoreMessage msg = new CoreMessage().initBuffer(1024).setMessageID(1L);
        LargeServerMessage largeMsg = this.liveServer.getStorageManager().createLargeMessage(500L, (Message)msg);
        largeMsg.addBytes(new byte[1024]);
        largeMsg.releaseResources(true, true);
        this.blockOnReplication((StorageManager)storage, this.manager);
        LargeServerMessageImpl message1 = (LargeServerMessageImpl)ReplicationTest.getReplicationEndpoint((ActiveMQServer)this.backupServer).getLargeMessages().get(500L);
        Assert.assertNotNull((Object)message1);
        Assert.assertFalse((boolean)largeMsg.getAppendFile().isOpen());
        Assert.assertFalse((boolean)message1.getAppendFile().isOpen());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tFactory = new ActiveMQThreadFactory("ActiveMQ-ReplicationTest", false, ((Object)((Object)this)).getClass().getClassLoader());
        this.executor = Executors.newCachedThreadPool(this.tFactory);
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(10, this.tFactory);
        this.factory = new OrderedExecutorFactory((Executor)this.executor);
    }

    @After
    public void tearDown() throws Exception {
        ReplicationTest.stopComponent((ActiveMQComponent)this.manager);
        this.manager = null;
        ReplicationTest.closeServerLocator((ServerLocator)this.locator);
        ReplicationTest.stopComponent((ActiveMQComponent)this.backupServer);
        this.backupServer = null;
        ReplicationTest.stopComponent((ActiveMQComponent)this.liveServer);
        this.liveServer = null;
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.tFactory = null;
        this.scheduledExecutor = null;
        super.tearDown();
    }

    protected PagingManager createPageManager(StorageManager storageManager, Configuration configuration, ExecutorFactory executorFactory, HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        PagingManagerImpl paging = new PagingManagerImpl((PagingStoreFactory)new PagingStoreFactoryNIO(storageManager, configuration.getPagingLocation(), 1000L, null, executorFactory, false, null), addressSettingsRepository, configuration.getManagementAddress());
        paging.start();
        return paging;
    }

    private static interface ExtraConfigurer {
        public void config(Configuration var1, Configuration var2);
    }

    static final class FakeJournal
    implements Journal {
        FakeJournal() {
        }

        public void setRemoveExtraFilesOnLoad(boolean removeExtraFilesOnLoad) {
        }

        public void appendAddEvent(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        }

        public boolean isRemoveExtraFilesOnLoad() {
            return false;
        }

        public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        }

        public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        }

        public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        }

        public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, JournalUpdateCallback updateCallback, boolean sync, boolean repalceableUpdate) throws Exception {
        }

        public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion callback) throws Exception {
        }

        public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, boolean replaceableUpdate, JournalUpdateCallback updateCallback, IOCompletion callback) throws Exception {
        }

        public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        }

        public void appendUpdateRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        }

        public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        }

        public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        }

        public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        }

        public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        }

        public void flush() throws Exception {
        }

        public long getMaxRecordSize() {
            return ActiveMQDefaultConfiguration.getDefaultJournalBufferSizeAio();
        }

        public void appendCommitRecord(long txID, boolean sync) throws Exception {
        }

        public void appendDeleteRecord(long id, boolean sync) throws Exception {
        }

        public void tryAppendDeleteRecord(long id, JournalUpdateCallback updateConsumer, boolean sync) throws Exception {
        }

        public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        }

        public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        }

        public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        }

        public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        }

        public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        }

        public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        }

        public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        }

        public void tryAppendUpdateRecord(long id, byte recordType, byte[] record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceable) throws Exception {
        }

        public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        }

        public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        }

        public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        }

        public int getAlignment() throws Exception {
            return 0;
        }

        public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
            return new JournalLoadInformation();
        }

        public JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure, boolean fixbadtx) throws Exception {
            return new JournalLoadInformation();
        }

        public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure, boolean fixbadtx) throws Exception {
            return new JournalLoadInformation();
        }

        public boolean isStarted() {
            return false;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }

        public JournalLoadInformation loadInternalOnly() throws Exception {
            return new JournalLoadInformation();
        }

        public int getNumberOfRecords() {
            return 0;
        }

        public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        }

        public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        }

        public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        }

        public void tryAppendDeleteRecord(long id, boolean sync, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        }

        public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        }

        public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        }

        public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        }

        public void sync(IOCompletion callback) {
        }

        public int getUserVersion() {
            return 0;
        }

        public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        }

        public void lineUpContext(IOCompletion callback) {
        }

        public JournalLoadInformation loadSyncOnly(Journal.JournalState s) throws Exception {
            return null;
        }

        public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
            return null;
        }

        public void synchronizationLock() {
        }

        public void synchronizationUnlock() {
        }

        public void forceMoveNextFile() throws Exception {
        }

        public JournalFile[] getDataFiles() {
            return null;
        }

        public SequentialFileFactory getFileFactory() {
            return null;
        }

        public int getFileSize() {
            return 0;
        }

        public void scheduleCompactAndBlock(int timeout) throws Exception {
        }

        public void replicationSyncPreserveOldFiles() {
        }

        public void replicationSyncFinished() {
        }
    }

    public static final class TestInterceptor
    implements Interceptor {
        static AtomicBoolean value = new AtomicBoolean(true);

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            return value.get();
        }
    }

    class FakeData
    implements EncodingSupport {
        FakeData() {
        }

        public void decode(ActiveMQBuffer buffer) {
        }

        public void encode(ActiveMQBuffer buffer) {
            buffer.writeBytes(new byte[5]);
        }

        public int getEncodeSize() {
            return 5;
        }
    }
}

