/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.asyncio;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioFile;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AIOTestBase
extends ActiveMQTestBase {
    protected String fileName = "fileUsedOnNativeTests.log";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Assert.assertTrue((String)String.format("libAIO is not loaded on %s %s %s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")), (boolean)LibaioContext.isLoaded());
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertEquals((long)0L, (long)LibaioContext.getTotalMaxIO());
        super.tearDown();
    }

    protected void encodeBufer(ByteBuffer buffer) {
        buffer.clear();
        int size = buffer.limit();
        for (int i = 0; i < size - 1; ++i) {
            buffer.put((byte)(97 + i % 20));
        }
        buffer.put((byte)10);
    }

    protected void preAlloc(LibaioFile controller, long size) throws ActiveMQException {
        controller.fill(controller.getBlockSize(), size);
    }

    protected static class CountDownCallback
    implements IOCallback {
        private final CountDownLatch latch;
        private final List<Integer> outputList;
        private final int order;
        private final AtomicInteger errors;
        volatile boolean doneCalled = false;
        int errorCalled = 0;
        final AtomicInteger timesDoneCalled = new AtomicInteger(0);

        public CountDownCallback(CountDownLatch latch, AtomicInteger errors, List<Integer> outputList, int order) {
            this.latch = latch;
            this.outputList = outputList;
            this.order = order;
            this.errors = errors;
        }

        public void done() {
            if (this.outputList != null) {
                this.outputList.add(this.order);
            }
            this.doneCalled = true;
            this.timesDoneCalled.incrementAndGet();
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public void onError(int errorCode, String errorMessage) {
            new Exception("Error called:: " + errorCode + " message::" + errorMessage).printStackTrace();
            ++this.errorCalled;
            if (this.outputList != null) {
                this.outputList.add(this.order);
            }
            if (this.errors != null) {
                this.errors.incrementAndGet();
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public static void checkResults(int numberOfElements, ArrayList<Integer> result) {
            Assert.assertEquals((long)numberOfElements, (long)result.size());
            int i = 0;
            for (Integer resultI : result) {
                Assert.assertEquals((long)i++, (long)resultI.intValue());
            }
        }
    }
}

