/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricsSubsystemDefinition;
import org.wildfly.extension.metrics.PrometheusExporter;
import org.wildfly.extension.metrics.WildFlyMetricRegistry;

public class MetricsContextService
implements Service {
    private static final String CONTEXT_NAME = "/metrics";
    private final Consumer<MetricsContextService> consumer;
    private final Supplier<ExtensibleHttpManagement> extensibleHttpManagement;
    private Supplier<WildFlyMetricRegistry> wildflyMetricRegistry;
    private final Supplier<Boolean> securityEnabledSupplier;
    private final PrometheusExporter prometheusExporter = new PrometheusExporter();
    private HttpHandler overrideableMetricHandler;

    static void install(OperationContext context, final boolean securityEnabled) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MetricsSubsystemDefinition.METRICS_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName());
        Supplier extensibleHttpManagement = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.http.extensible", ExtensibleHttpManagement.class));
        Supplier wildflyMetricRegistry = serviceBuilder.requires(MetricsSubsystemDefinition.METRICS_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName());
        Consumer metricsContext = serviceBuilder.provides(new ServiceName[]{MetricsSubsystemDefinition.METRICS_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName()});
        Supplier<Object> securityEnabledSupplier = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.metrics.http-context.security-enabled") ? serviceBuilder.requires(ServiceName.parse((String)"org.wildfly.extension.metrics.http-context.security-enabled")) : new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return securityEnabled;
            }
        };
        MetricsContextService metricsContextService = new MetricsContextService(metricsContext, extensibleHttpManagement, wildflyMetricRegistry, (Supplier<Boolean>)securityEnabledSupplier);
        serviceBuilder.setInstance((Service)metricsContextService).install();
    }

    public MetricsContextService(Consumer<MetricsContextService> consumer, Supplier<ExtensibleHttpManagement> extensibleHttpManagement, Supplier<WildFlyMetricRegistry> wildflyMetricRegistry, Supplier<Boolean> securityEnabledSupplier) {
        this.consumer = consumer;
        this.extensibleHttpManagement = extensibleHttpManagement;
        this.wildflyMetricRegistry = wildflyMetricRegistry;
        this.securityEnabledSupplier = securityEnabledSupplier;
    }

    public void start(StartContext context) {
        this.extensibleHttpManagement.get().addManagementHandler(CONTEXT_NAME, this.securityEnabledSupplier.get().booleanValue(), new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (MetricsContextService.this.overrideableMetricHandler != null) {
                    MetricsContextService.this.overrideableMetricHandler.handleRequest(exchange);
                    return;
                }
                WildFlyMetricRegistry metricRegistry = (WildFlyMetricRegistry)MetricsContextService.this.wildflyMetricRegistry.get();
                metricRegistry.readLock();
                try {
                    String wildFlyMetrics = MetricsContextService.this.prometheusExporter.export(metricRegistry);
                    exchange.getResponseSender().send(wildFlyMetrics);
                }
                finally {
                    metricRegistry.unlock();
                }
            }
        });
        this.consumer.accept(this);
    }

    public void stop(StopContext context) {
        this.extensibleHttpManagement.get().removeContext(CONTEXT_NAME);
        this.consumer.accept(null);
    }

    public void setOverrideableMetricHandler(HttpHandler handler) {
        this.overrideableMetricHandler = handler;
    }
}

