/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.util.Objects;

public final class Version
implements Comparable<Version> {
    private static final Version VERSION = Version.getVersion(Version.class);
    private final int major;
    private final int minor;
    private final int micro;
    private final String suffix;
    private final String versionString;

    public static Version getVersion(Class<?> clazz) {
        String version = clazz.getPackage().getImplementationVersion();
        if (version != null) {
            try {
                String[] versionParts = version.split("[.\\-]");
                int major = Integer.parseInt(versionParts[0]);
                int minor = versionParts.length > 1 ? Integer.parseInt(versionParts[1]) : 0;
                int micro = versionParts.length > 2 ? Integer.parseInt(versionParts[2]) : 0;
                String suffix = versionParts.length > 3 ? versionParts[3] : null;
                return new Version(major, minor, micro, suffix);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Version(0, 0, 0, "UNKNOWN");
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static void main(String[] args) {
        System.out.println("ProtoStream version " + Version.getVersion());
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String suffix) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.suffix = suffix;
        suffix = suffix == null ? "" : ("SNAPSHOT".equals(suffix) ? "-SNAPSHOT" : '.' + suffix);
        this.versionString = major + "." + minor + "." + micro + suffix;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return other.major == this.major && other.minor == this.minor && other.micro == this.micro && Objects.equals(this.suffix, other.suffix);
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.major + this.minor) + this.micro) + (this.suffix != null ? this.suffix.hashCode() : 0);
    }

    @Override
    public int compareTo(Version other) {
        if (this == other) {
            return 0;
        }
        int d = this.major - other.major;
        if (d == 0 && (d = this.minor - other.minor) == 0 && (d = this.micro - other.micro) == 0) {
            d = this.suffix == null ? (other.suffix == null ? 0 : -1) : (other.suffix == null ? 1 : this.suffix.compareTo(other.suffix));
        }
        return d;
    }
}

