/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.context;

import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.SessionContext;
import jakarta.ejb.TimerService;
import jakarta.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.allowedmethods.MethodType;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.context.EJBContextImpl;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.InterceptorContext;

public class SessionContextImpl
extends EJBContextImpl
implements SessionContext {
    private static final long serialVersionUID = 1L;
    private final boolean stateful;

    public SessionContextImpl(SessionBeanComponentInstance instance) {
        super(instance);
        this.stateful = instance.getComponent() instanceof StatefulSessionComponent;
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        return this.getComponent().getBusinessObject(businessInterface, invocation);
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        AllowedMethodsInformation.checkAllowed(MethodType.GET_EJB_LOCAL_OBJECT);
        InterceptorContext invocation = CurrentInvocationContext.get();
        return this.getComponent().getEJBLocalObject(invocation);
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        AllowedMethodsInformation.checkAllowed(MethodType.GET_EJB_OBJECT);
        InterceptorContext invocation = CurrentInvocationContext.get();
        return this.getComponent().getEJBObject(invocation);
    }

    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        ComponentView view = (ComponentView)invocation.getPrivateData(ComponentView.class);
        if (view.getViewClass().equals(this.getComponent().getEjbObjectType()) || view.getViewClass().equals(this.getComponent().getEjbLocalObjectType())) {
            throw EjbLogger.ROOT_LOGGER.cannotCall("getInvokedBusinessInterface", "EjbObject", "EJBLocalObject");
        }
        return view.getViewClass();
    }

    @Override
    public SessionBeanComponent getComponent() {
        return (SessionBeanComponent)super.getComponent();
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        throw EjbLogger.ROOT_LOGGER.cannotCall("getMessageContext()", "MessageContext");
    }

    public boolean wasCancelCalled() throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        CancellationFlag flag = (CancellationFlag)invocation.getPrivateData(CancellationFlag.class);
        if (flag == null) {
            throw EjbLogger.ROOT_LOGGER.noAsynchronousInvocationInProgress();
        }
        return flag.isCancelFlagSet();
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        AllowedMethodsInformation.checkAllowed(MethodType.GET_TIMER_SERVICE);
        if (this.stateful) {
            throw EjbLogger.ROOT_LOGGER.notAllowedFromStatefulBeans("getTimerService()");
        }
        return super.getTimerService();
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        AllowedMethodsInformation.checkAllowed(MethodType.GET_USER_TRANSACTION);
        return this.getComponent().getUserTransaction();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        AllowedMethodsInformation.checkAllowed(MethodType.SET_ROLLBACK_ONLY);
        super.setRollbackOnly();
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        AllowedMethodsInformation.checkAllowed(MethodType.GET_ROLLBACK_ONLY);
        return super.getRollbackOnly();
    }
}

